/*
*				ginitprotos.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Function prototypes for the ginit library.
*/

#if !defined(_GINITPROTOS_H)
#define _GINITPROTOS_H

/*	gibifur.c */
IMPORT	void	g_prompt_for_tracked_bifurcations(INIT_DATA*);

/*	gicc.c */
IMPORT	void	init_CC_interaction(INIT_DATA*,INIT_PHYSICS*);

#if defined(TWOD)
/*	gielrp.c */
IMPORT	ELLIPSOID	*allocate_ellipsoid(ELLIPSOID*,int);
IMPORT	ELLIPSOID	*prompt_for_ellipsoid(Front*,const char*,float*,
					      float*,const LAYER_FLAG*,
					      INIT_PHYSICS*);
IMPORT	float	max_radii(ELLIPSOID*);
IMPORT	void	init_el_riem_prob(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	print_ellipsoid(ELLIPSOID*,INTERFACE*);
IMPORT	void	set_default_ellipsoid_structure(ELLIPSOID*,int);
IMPORT	void	set_elliptical_comp_type(COMP_TYPE*,INIT_PHYSICS*);
#endif /* defined(TWOD) */
IMPORT  int     read_vector(float*,float*,int);
IMPORT  void    make_plane_wave(float,COMPONENT,COMPONENT,float,float,
                                int,RECT_GRID*);
IMPORT  void    set_up_ambient_elliptic_region(bool,COMP_TYPE*,Gas_param*,
                                               const char*,Front*,INIT_DATA*);


/*	giglobs.c */
IMPORT	COMP_TYPE	*comp_type(COMPONENT);
IMPORT	const COMPONENT *comps_with_type(COMP_TYPE_TYPE,int*);
IMPORT	int	g_init_composition_type(INIT_PHYSICS*,INIT_DATA*,size_t*,int*);
IMPORT	int	max_num_comps(void);
IMPORT	void	check_float_input(const char*,float,float,float,int);
IMPORT	void	check_int_input(const char*,int,int,int,int);
IMPORT	void	g_compute_sizest(int,size_t*,int*,int);
IMPORT	void	g_prompt_for_composition_type(INIT_DATA*);
IMPORT	void	g_prompt_for_maximum_number_of_components(void);
IMPORT	void	get_state_ambient(float*,Locstate,COMP_TYPE*,
				  HYPER_SURF*,INTERFACE*,INIT_DATA*,int);
IMPORT	void	free_comp_types(void);
IMPORT	void	prompt_for_gravity(INIT_DATA*);
#if defined(ONED)
IMPORT	bool	overlays_exist(void);
IMPORT	void	get_state_1d_overlay(float*,Locstate,COMP_TYPE*,
				     HYPER_SURF*,INTERFACE*,INIT_DATA*,int);
#endif /* defined(ONED) */

/*	gictype.c */
IMPORT	COMP_TYPE	*g_get_comp_type_type(LAYER_SYS*,int,int,
				     INIT_PHYSICS*,INIT_DATA*);
IMPORT	void	prompt_for_comp_type_type(COMP_TYPE*,const char*,INIT_PHYSICS*);
IMPORT	void	set_rarefaction_wave_1d_comp_type(COMP_TYPE*,Front*);

/*	girt.c */
IMPORT	STRATIFICATION_TYPE prompt_for_stratification(const char*);
IMPORT	void	get_state_in_stratified_region(STRATIFICATION_TYPE,Locstate,
					       float,float,Locstate);
IMPORT	void	get_state_rt_kh_perturbed(float*,Locstate,COMP_TYPE*,
					  HYPER_SURF*,INTERFACE*,INIT_DATA*,
					  int);
#if defined(TWOD) || defined(THREED)
IMPORT	void	free_rt_kh_comp_type(COMP_TYPE*);
IMPORT	void	set_rt_kh_comp_type(COMP_TYPE*,Front*);
#endif /* defined(TWOD) || defined(THREED) */

/*	gilayer.c */
IMPORT	LAYER_SURF	*alloc_layer_surf(void);
IMPORT  void    g_prompt_for_constant_flow_region(COMPONENT,Locstate,
                                                  INTERFACE*);
IMPORT	bool	rarefaction_edge_at_coords(float*,HYPER_SURF*,
					   RAREFACTION_EDGE_TYPE);
IMPORT	float	get_surf_height(float*,LAYER_SURF*);
IMPORT	void	init_multi_layer(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	set_stretching_comp_type(COMP_TYPE*,Front*);
#if defined(ONED)
IMPORT	void	prompt_for_1d_overlay(INIT_DATA*,COMP_TYPE*,INIT_PHYSICS*,
				      const char*,OVERLAY_TYPE);
IMPORT	void	set_1d_overlay_comp_type(COMP_TYPE*);
#endif /* defined(ONED) */

/*	girpregion.c */
IMPORT	void	set_up_riemann_problem_region(int,int,int,int,float*,
                                              float*,SIDE,Locstate,Locstate,
					      LAYER_SYS*,INIT_PHYSICS*,
					      INIT_DATA*);

#if defined(TWOD)
/*	gimkcur.c */
IMPORT	HYPER_SURF	*g_make_ellipse(ELLIPSOID*,COMPONENT,COMPONENT,Front*);
IMPORT	void	coords_on_pert_ellipsoid(float*,float*,ELLIPSOID*);
IMPORT	void	g_make_ellip_region_boundaries2d(ELLIPSOID*,Front*);
IMPORT	void	g_make_fourier_curve(int,int,float,float,FOURIER_POLY*,
				     COMPONENT,COMPONENT,float);
IMPORT	void	make_neumann_curve(INTERFACE*,NODE*,NODE*,float,float,float,
				   float,int,int,COMPONENT,COMPONENT,CURVE**);
IMPORT	void	make_rotated_curve(float*,float,float*,float*,
				   float (*f) (float,POINTER),
				   float (*fprime) (float,POINTER),
				   POINTER,NODE*,COMPONENT,COMPONENT,
				   CURVE**,ORIENTATION,
				   int,int,int,float,Front*);
IMPORT	void	make_vertical_axis_curve(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	make_ramp(int,float,float,float,float,COMPONENT,COMPONENT,
			  RECT_GRID*,CURVE**);
IMPORT	void	set_tangent_to_origin(TANGENT_FUNCTION*);
IMPORT	float	sin_sqr_pert(float,POINTER);
IMPORT	float	sin_sqr_pert_prime(float,POINTER);
#endif /* defined(TWOD) */
IMPORT	void	set_normal_to_origin(NORMAL_FUNCTION*);

/*	gimksurf.c */
#if defined(THREED)
IMPORT	HYPER_SURF *g_make_ellipsoid(ELLIPSOID*,COMPONENT,COMPONENT,Front*);
IMPORT	void	   g_make_ellip_region_boundaries3d(ELLIPSOID*,Front*);
IMPORT	void	   make_random_surface(int,Front*,SINE_PERT*,COMPONENT,
				       COMPONENT,float,int);
#endif /* defined(THREED) */

/*	ginitintfc.c */
IMPORT	const char *comp_type_name(COMP_TYPE_TYPE);
IMPORT  int     g_prompt_for_bdry_wave_type(INIT_DATA*,
					    const char*,const Prompt_type*);
IMPORT	int	g_prompt_for_boundary_state(int,const char*,float*,
					    COMPONENT,int,HYPER_SURF*,
					    INIT_DATA*,INIT_PHYSICS*);
IMPORT	int	g_prompt_for_wave_type(const char*,INTERFACE*,INIT_PHYSICS*);
IMPORT	void	g_init_cauchy_data_pointers(INIT_PHYSICS*,bool);
IMPORT	void	g_init_interface(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	g_init_problem_type(INIT_PHYSICS*);
IMPORT  void    g_init_parabolic(Front*);
IMPORT	void	gi_set_interface_hooks(int,INIT_DATA*);
IMPORT	void	prompt_for_ambient_state(COMP_TYPE*,Gas_param*,const char*,
					 Front*,INIT_DATA*);
IMPORT	void	prompt_for_problem_type(INIT_PHYSICS*,Prob_type*);
IMPORT	void	g_prompt_for_ref_state(const char*,Locstate,int,
				       Gas_param*,INIT_DATA*);
IMPORT	void	set_ambient_boundary_state(Locstate,float*,COMPONENT,
					   INTERFACE*,INIT_DATA*);
IMPORT	void	set_ambient_comp_type(COMP_TYPE*,Front*);
IMPORT	void	set_obstacle_comp_type(COMP_TYPE*,Front*);

/*      giphysprompt.c */
IMPORT  void    g_prompt_for_physics_options(INIT_DATA*);
IMPORT	void	g_set_prompting_hooks(INIT_DATA*);
IMPORT	void	init_artificial_parameters(INIT_DATA*);

/*	ginitphys.c */
IMPORT	void	g_init_physics(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	g_copy_into_front(Front*,Front*);
IMPORT	void	g_copy_into_wave(Wave*,Wave*);
IMPORT	void	g_set_basic_phys_parameters(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	read_print_stratified_state_function(const IO_TYPE*,INTERFACE*);
IMPORT	void	set_gas_hooks(INIT_DATA*,INIT_PHYSICS*);

/*	giparams.c */
IMPORT	Gas_param	*g_init_eos_params(INIT_DATA*,INIT_PHYSICS*,
					   const char*,bool);
IMPORT	Gas_param	*g_prompt_for_eos_params(INIT_DATA*,INIT_PHYSICS*,
						 bool,const char*);
IMPORT  Gas_param       **g_prompt_for_eos_params_list(INIT_DATA*,INIT_PHYSICS*,
                                                       bool,int*);
IMPORT	void	prompt_for_artificial_viscosity_and_heat_conduction(INIT_DATA*,
								    const char*,
								    const char*,
								    bool,
								    AVISC*);

/*	gipert.c */
#if defined(TWOD) || defined(THREED)
IMPORT	float	get_rho_prime(Locstate,COMP_TYPE*,float);
IMPORT	void	init_kelvin_helmholtz(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	init_random_surface(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	lin_pert_state(Locstate,float*,Front*,Wave*,int);
IMPORT	void	rt_ml_linear_pert(LAYER_SYS*,INIT_DATA*);
#endif /* defined(TWOD) || defined(THREED) */

/*	gijet.c */
IMPORT	void	init_fuel_injection_jet(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	init_injection_inlet_jet(INIT_DATA*,INIT_PHYSICS*);

/*      giboone.c */
IMPORT  void    init_neutrino_booster_detector(INIT_DATA*,INIT_PHYSICS*);
IMPORT  void    set_state_cracked_pmt_bottom(float*,COMPONENT,Locstate);

/*	gipppert.c */
#if defined(TWOD) || defined(THREED)
IMPORT	int	pp_get_next_mode(int*,int,LIN_PERT*);
IMPORT	int	pp_list_modes(NORMAL_MODE**,LIN_PERT*,int,int,int);
IMPORT	void	brdcst_info(LIN_PERT*,NORMAL_MODE**,int,int*);
#endif /* defined(TWOD) || defined(THREED) */

/*	giprt.c */
IMPORT  float           **velocity_gradient(float*,Front*,Wave*,COMPONENT);
IMPORT	INPUT_SOLN	**g_set_input_solution(Printplot*);
IMPORT	PRINTING_LIST	*g_set_printing_list(INIT_PHYSICS*,INIT_DATA*,
					     Printplot*);
IMPORT	PROBE	*init_probe(float*,float*,int*,const float*,
                            INIT_DATA*,INIT_PHYSICS*);
IMPORT	Plot_choice	*g_set_plot_choices(INIT_DATA*);
IMPORT	void	fprint_rarefaction_wave_1d(FILE*,_RAREFACTION_WAVE_1D*);
IMPORT	void	g_init_printing_and_plotting(INIT_PHYSICS*,INIT_DATA*,
					     Printplot*,int);
IMPORT	void	g_init_statistics(Front*,Grid*,Wave*,Printplot*,INIT_DATA*);
IMPORT	void	g_prompt_for_optional_printing_variables(INIT_DATA*);
IMPORT	void	g_prompt_for_printing_and_plotting(INIT_DATA*);

/*	gireadstate.c */
IMPORT	Locstate g_read_print_state_data(INIT_DATA*,const IO_TYPE*,
                                         Locstate,INTERFACE*);
IMPORT	int	read_Gas_param_list(INIT_DATA*,const IO_TYPE*,uint64_t**,
				    Gas_param***,int,size_t,bool);
IMPORT	void	g_free_restart_params_list(void);
IMPORT	void	g_read_print_ContactWallNodeParams(const IO_TYPE*,INTERFACE*);
IMPORT	void	g_read_print_Dirichlet_bdry_states(INIT_DATA*,const IO_TYPE*,
                                                   INTERFACE*);
IMPORT	void	g_read_print_Gas_param_list(INIT_DATA*,const IO_TYPE*,
                                            INTERFACE*);
IMPORT	void	g_read_print_RP_DATA_at_nodes(INIT_DATA*,const IO_TYPE*,
                                              INTERFACE*);
IMPORT  void    g_read_print_boundary_state_data(INIT_DATA*,const IO_TYPE*,
                                                 INTERFACE*,int);
IMPORT	void	read_print_avisc_params(INIT_DATA*,const IO_TYPE*,int,AVISC*);
IMPORT	void	read_print_gas_data(const IO_TYPE*,Locstate*,int,int,size_t,int,
				    uint64_t*,Gas_param**,int);
IMPORT	void	read_print_thermodynamic_restrictions(Gas_param*,
                                                      const IO_TYPE*);
IMPORT	void	reset_artificial_viscosity_and_heat_conduction(INIT_DATA*);
IMPORT	void	set_restart_params(Gas_param**,uint64_t,int,
				   uint64_t*,Gas_param**);

/*	girefl.c */
IMPORT	void	init_ramp_reflection(INIT_DATA*,INIT_PHYSICS*);

/*	girestrt.c */
IMPORT	void	g_restart_initializer(int*,int,COMPONENT,
				      INPUT_SOLN**,Locstate,INIT_DATA*);
IMPORT	void	g_restart_intfc_initializer(POINT*,HYPER_SURF_ELEMENT*,
					    HYPER_SURF*,Locstate,Locstate,
					    INIT_DATA*);
IMPORT	void	g_restart_set_intfc_states(float*,float*,int,POINT*,
					   HYPER_SURF_ELEMENT*,HYPER_SURF*);

/*	girstate.c.c */
IMPORT	RANDOM_STATE	*allocate_random_state_structure(INTERFACE*);
IMPORT	RANDOM_STATE	*copy_random_state_structure(RANDOM_STATE*,INTERFACE*);
IMPORT	int	prompt_for_random_flow_inlet(float*,COMPONENT,HYPER_SURF*,
					     INTERFACE*,int,INIT_DATA*);
IMPORT	void	free_random_state_structure(RANDOM_STATE*);
IMPORT	void	init_random_state_region(Locstate,RANDOM_STATE*,Front*);
IMPORT	void	random_region_state(Locstate,float*,RANDOM_STATE*);
IMPORT	void	read_print_random_velocity_inlet_data(INIT_DATA*,const IO_TYPE*,
						      BOUNDARY_STATE*,
						      INTERFACE*);
IMPORT	void	set_random_region_comp_type(COMP_TYPE*,Front*);

/*	gisc.c */
IMPORT	void	set_untracked_shock_wave_comp_type(COMP_TYPE*,UT_SHOCK*,Front*);
#if defined(TWOD)
IMPORT	void	init_meshkov(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	init_shock_diffraction(INIT_DATA*,INIT_PHYSICS*);
IMPORT	void	init_shock_transmission(INIT_DATA*,INIT_PHYSICS*);
#endif /* defined(TWOD) */

/*	gistate.c */
IMPORT	_RAREFACTION_WAVE_1D *allocate_RAREFACTION_WAVE_1D(Front*);
IMPORT	int	init_state_type(int);
IMPORT	void	init_shock_states(float,float,float,float*,Gas_param*,
				  Locstate,Locstate);
IMPORT	void	prompt_for_behind_contact_state(Locstate,Locstate,
						Gas_param*,bool,float*,int,
						INIT_DATA*);
IMPORT	void	prompt_for_behind_shock_state(Locstate,Locstate,bool,float*,
					      int,bool,INIT_DATA*);
#if defined(COMBUSTION_CODE)
IMPORT	void	prompt_for_burning(Gas_param**,const char*);
#endif /* defined(COMBUSTION_CODE) */

#if defined(TWOD)
/*    girm_linear.c */
IMPORT	void	rm_linear(INIT_DATA*,INIT_PHYSICS*,LAYER_SYS*);
#endif /* defined(TWOD) */

/*    gihypinit.c */
IMPORT	void	g_set_hyp_solvers(INIT_DATA*,Wave*,Front*);
IMPORT	void	g_setup_available_hyperbolic_methods_list(INIT_DATA*);

/*    gitabregion.c */
IMPORT	void	set_tabulated_region_comp_type(COMP_TYPE*,Front*);
IMPORT	void	set_up_read_state_from_file_region(COMP_TYPE*,const char*,
                                                   Front*);

/*    spolars.c */
IMPORT	int	sp_main(int,char**,INIT_DATA*,INIT_PHYSICS*);

/*    testsolver.c */
IMPORT  int     gsolv_main(int,char**,INIT_DATA*,INIT_PHYSICS*);

#endif /* !defined(_GINITPROTOS_H) */
