/*
*				ghypvec.c
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Contains the drivers for the vectorized hyperbolic scheme:
*/


#include <ghyp/ghyp.h> 
#include <gdecs/vecdecs.h>



/*
*			  ghyp_vec()
*
*	The subroutine first loads the state variables into vst, the source
*	variables to src, then passes to the oned_interior_scheme().
*/

/*ARGSUSED*/
EXPORT	void ghyp_vec(
	int		swp_num,
	int		*iperm,
	float		*dir,
	Wave		*wv,
	Wave		*newwv,
	Front		*fr,
	Front		*newfr,
	int		*icoords,
	int		imin,
	int		imax,
	float		dt,
	float		dh)
{
	Vec_Gas		*vst = g_wave_vgas(wv);
	Vec_Src		*src = g_wave_vsrc(wv);
	int		idir = iperm[swp_num];
	int		dim = wv->rect_grid->dim;
	int		nrad = vsten_radius(wv);
	int		vsize;
#if defined(ROTATIONAL_SYMMETRY)
	static	float	alpha;
	static	bool	first = YES;
#endif /* defined(ROTATIONAL_SYMMETRY) */

#if defined(TIME_HYPVEC)
	start_clock("ghyp_vec");
#endif /* defined(TIME_HYPVEC) */

	debug_print("ghyp_vec","Entered ghyp_vec(), dir = %d\n",idir);
#if defined(ROTATIONAL_SYMMETRY)
	if (first == YES)
	{
	    first = NO;
	    alpha = rotational_symmetry();
	}
#endif /* defined(ROTATIONAL_SYMMETRY) */

	vsize = imax - imin;
	if (vsize < wv->npts_vsten) return;
	if (load_state_vectors(swp_num,iperm,vst,0,vsize,wv,newwv,
			       icoords,imin) == CONSTANT_IN_TIME)
	{
#if defined(TIME_HYPVEC)
	    stop_clock("ghyp_vec");
#endif /* defined(TIME_HYPVEC) */
	    return;
	}

#if defined(ROTATIONAL_SYMMETRY)
	if ( (alpha > 0.0) && (iperm[swp_num] == 0))
 	{
 	    RECT_GRID *rgr = wv->rect_grid;
	    float     *radii = src->radii;
	    int       j;
 
	    src->rmin = pos_radius(0.0,rgr);
 	    for (j = 0; j < vsize; j++)
 	    	radii[j] = pos_radius(cell_center(j+imin,0,rgr),rgr);
 	}
#endif /* defined(ROTATIONAL_SYMMETRY) */

	oned_interior_scheme(swp_num,iperm,icoords,wv,newwv,fr,newfr,NULL,
		             0,vsize,vst,src,dt,dh,dim);

	assign_wave_state_vectors(swp_num,iperm,wv,newwv,vst,nrad,
		                  vsize-nrad,icoords,imin);

	debug_print("ghyp_vec","Left ghyp_vec(), dir = %d\n",idir);
#if defined(TIME_HYPVEC)
	stop_clock("ghyp_vec");
#endif /* defined(TIME_HYPVEC) */
}		/*end ghyp_vec*/


EXPORT	void copy_states_to_new_time_level(
	int		*idirs,
	Wave		*wv,
	Wave		*newwv,
	int		imin,
	int		imax,
	int		*icoords,
	int		pbuf)
{
	int		i;
	size_t		sizest = wv->sizest;

	for (i = imin; i < imax; ++i)
	{
	    icoords[idirs[0]] = i + pbuf;
	    assign(Rect_state(icoords,newwv),Rect_state(icoords,wv),sizest);
	}
}		/*end copy_states_to_new_time_level*/
