/*
*
*				jwl.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Template file for the implementation of new equation of state models
*
*/

#if !defined(_JWL_H)
#define _JWL_H

#include <geos/geosdecs.h>

	/* Structures for accessing equation of state information */

struct _JWL_EOS {
	EOS	eos;

	/* Basic independent parameters defining material */
	float	_Rho0;	/* Reference density */
	float	_P1, _P2;	/* Units of pressure */
	float	_R1, _R2;	/* dimensionless */
	float	_W;	/* Gruneisen coefficient, dimensionless */
	float	_R;	/* Gas constant, defines temperature units */
	float	_dH;	/* heat of detonation */

	/* Useful combinations of EOS parameters */

	float	_Rho1;	/* Rho0*R1 */
	float	_Rho2;	/* Rho0*R2 */
	float	_W_1;	/* W/r1 */
	float	_W_2;	/* W/r2 */
	float	_Wp1;	/* W + 1*/
	float	_Pref0;	/* p1*exp(-R1) + p2*exp(-R2)*/
};
typedef struct _JWL_EOS JWL_EOS;

#define	JWL_Eos(state)	((JWL_EOS *)Params(state)->eos)
#define	Rho0(state)	(JWL_Eos(state))->_Rho0
#define	P1(state)	(JWL_Eos(state))->_P1
#define	P2(state)	(JWL_Eos(state))->_P2
#define	R1(state)	(JWL_Eos(state))->_R1
#define	R2(state)	(JWL_Eos(state))->_R2
#define	W(state)	(JWL_Eos(state))->_W
#define	Rho1(state)	(JWL_Eos(state))->_Rho1
#define	Rho2(state)	(JWL_Eos(state))->_Rho2
#define	W1(state)	(JWL_Eos(state))->_W_1
#define	W2(state)	(JWL_Eos(state))->_W_2
#define	Wp1(state)	(JWL_Eos(state))->_Wp1
#define	R(state)	(JWL_Eos(state))->_R
#define	Pref0(state)	(JWL_Eos(state))->_Pref0
#define	dH(state)	(JWL_Eos(state))->_dH

#endif /* !defined(_JWL_H) */
