/*
*
*				gentest.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Template file for the implementation of new equation of state models
*
*/

#if !defined(_GENTEST_H)
#define _GENTEST_H

#include <geos/poly.h>

	/* Structures for accessing equation of state information */

struct _GENTEST_EOS {
	POLY_EOS	Poly;
	float		pinf;
};
typedef struct _GENTEST_EOS GENTEST_EOS;

#define	GENTEST_Eos(state)	((GENTEST_EOS *)Params(state)->eos)

	/* Macros */

#define Pinf(state)		(GENTEST_Eos(state)->pinf)
#define	stiff_pressure(state) 	(pressure(state) + Pinf(state))

#endif /* !defined(_GENTEST_H) */
