/*
*				vecdecs.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Contains definitions for vectorization in C.
*/

#if !defined(_VECDECS_H)
#define _VECDECS_H

#if !defined(float)
		/* SINGLE PRECISION VERSION */

	/* Functions not in toblas */

#define add_vector_to_vector(n,v1,v2)					\
		add_scalar_times_vector_to_vector(n,1.0,v1,v2)

#define vector_equals_vector_plus_vector(n,v1,v2,v3)			\
{									\
	copy_vector_to_vector(n,v2,v1);					\
	add_scalar_times_vector_to_vector(n,1.0,v3,v1);			\
}

#define vector_equals_vector_times_vector(n,v1,v2,v3)			\
{									\
	copy_vector_to_vector(n,v2,v1);					\
	multiply_vector_by_vector(n,v1,v3);				\
}

#define vector_equals_vector_divided_by_vector(n,v1,v2,v3)		\
{									\
	copy_vector_to_vector(n,v2,v1);					\
	divide_vector_by_vector(n,v1,v3);				\
}

#define vector_equals_scalar_times_sum_of_vectors(n,v1,a,v2,v3)		\
{									\
	vector_equals_vector_plus_vector(n,v1,v2,v3);			\
	multiply_vector_by_scalar(n,v1,a);				\
}

#define absolute_value_of_vector(n,v)					\
{									\
	int i;								\
									\
	for (i = 0; i < n; i++) v[i] = fabs(v[i]);			\
}


#else /* !defined(float) */

		/* DOUBLE PRECISION VERSION */

#define inner_product dinner_product

#define norm_vector dnorm_vector

#define zero_vector dzero_vector

#define subtract_vector_from_vector dsubtract_vector_from_vector

#define add_scalar_times_vector_to_vector dadd_scalar_times_vector_to_vector

#define add_vector_times_vector_to_vector dadd_vector_times_vector_to_vector

#define copy_vector_to_vector dcopy_vector_to_vector

#define multiply_vector_by_scalar dmultiply_vector_by_scalar

#define multiply_vector_by_vector dmultiply_vector_by_vector

#define divide_vector_by_vector ddivide_vector_by_vector

#define vector_equals_scalar dvector_equals_scalar

#define add_scalar_to_vector dadd_scalar_to_vector

#define min_max_vector dmin_max_vector

#define sum_elements_of_vector dsum_elements_of_vector

#define vector_equals_scalar_plus_vector dvector_equals_scalar_plus_vector

#define vector_equals_scalar_times_vector dvector_equals_scalar_times_vector

#define vector_equals_vector_plus_scalar_times_vector			\
		dvector_equals_vector_plus_scalar_times_vector

#define vector_equals_vector_minus_vector dvector_equals_vector_minus_vector


	/* Functions not in toblas */

#define add_vector_to_vector(n,v1,v2)					\
		dadd_scalar_times_vector_to_vector(n,1.0,v1,v2)

#define vector_equals_vector_plus_vector(n,v1,v2,v3)			\
{									\
	dcopy_vector_to_vector(n,v2,v1);				\
	dadd_scalar_times_vector_to_vector(n,1.0,v3,v1);		\
}

#define vector_equals_vector_times_vector(n,v1,v2,v3)			\
{									\
	dcopy_vector_to_vector(n,v2,v1);				\
	dmultiply_vector_by_vector(n,v1,v3);				\
}

#define vector_equals_vector_divided_by_vector(n,v1,v2,v3)		\
{									\
	dcopy_vector_to_vector(n,v2,v1);				\
	ddivide_vector_by_vector(n,v1,v3);				\
}

#define vector_equals_scalar_times_sum_of_vectors(n,v1,a,v2,v3)		\
{									\
	dvector_equals_vector_plus_vector(n,v1,v2,v3);			\
	dmultiply_vector_by_scalar(n,v1,a);				\
}

#define absolute_value_of_vector(n,v)					\
{									\
	int i;								\
									\
	for (i = 0; i < n; i++) v[i] = fabs(v[i]);			\
}


#endif /* !defined(float) */

		/* MIXED MODE FUNCTIONS */
	/* Functions not in toblas */

#define dadd_vector_to_vector(n,v1,v2)					\
		dadd_scalar_times_vector_to_vector(n,1.0,v1,v2)

#define dvector_equals_vector_plus_vector(n,v1,v2,v3)			\
{									\
	dcopy_vector_to_vector(n,v2,v1);				\
	dadd_scalar_times_vector_to_vector(n,1.0,v3,v1);		\
}

#define dvector_equals_vector_times_vector(n,v1,v2,v3)			\
{									\
	dcopy_vector_to_vector(n,v2,v1);				\
	dmultiply_vector_by_vector(n,v1,v3);				\
}

#define dvector_equals_vector_divided_by_vector(n,v1,v2,v3)		\
{									\
	dcopy_vector_to_vector(n,v2,v1);				\
	ddivide_vector_by_vector(n,v1,v3);				\
}

#define dvector_equals_scalar_times_sum_of_vectors(n,v1,a,v2,v3)	\
{									\
	dvector_equals_vector_plus_vector(n,v1,v2,v3);			\
	dmultiply_vector_by_scalar(n,v1,a);				\
}

#define dabsolute_value_of_vector(n,v)					\
{									\
	int i;								\
									\
	for (i = 0; i < n; i++) v[i] = fabs(v[i]);			\
}


#endif /* !defined(_VECDECS_H) */
