/*
*				guserrp.h:
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*			User Supplied Operations
*/

#if !defined(_USERRP_H)
#define _USERRP_H

#include <gdecs/gdecs.h>

struct _G_RPROBLEM {
	F_RPROBLEM frproblem;
	int _num_incident;
	int _num_refl;
	int _num_transm;
	int _num_inc_shock;
	int _num_contact;
};
typedef struct _G_RPROBLEM G_RPROBLEM;

	/* G_RPROBLEM access macros */
#define g_rproblem(rp)  ((G_RPROBLEM *) (rp))
#define	rp_num_incident(rp)		(g_rproblem(rp)->_num_incident)
#define	rp_num_refl(rp)			(g_rproblem(rp)->_num_refl)
#define	rp_num_transm(rp)		(g_rproblem(rp)->_num_transm)
#define	rp_num_inc_shock(rp)		(g_rproblem(rp)->_num_inc_shock)
#define	rp_num_contact(rp)		(g_rproblem(rp)->_num_contact)


struct _G_RP_NODE {
	RP_NODE rpn;
	O_CURVE_FAMILY *_inc_shock1;
	O_CURVE_FAMILY *_reflected1;
	O_CURVE_FAMILY *_transmitted;
	O_CURVE_FAMILY *_inc_shock2;
	O_CURVE_FAMILY *_reflected2;
	O_CURVE_FAMILY *_contact1;
	O_CURVE_FAMILY *_contact2;
};
typedef struct _G_RP_NODE G_RP_NODE;

	/* G_RPROBLEM access macros */
#define g_rp_node(rpn)  ((G_RP_NODE *) (rpn))
#define	rpn_inc_shock1(rpn)	(g_rp_node(rpn)->_inc_shock1)
#define	rpn_reflected1(rpn)	(g_rp_node(rpn)->_reflected1)
#define	rpn_transmitted(rpn)	(g_rp_node(rpn)->_transmitted)
#define	rpn_inc_shock2(rpn)	(g_rp_node(rpn)->_inc_shock2)
#define	rpn_reflected2(rpn)	(g_rp_node(rpn)->_reflected2)
#define	rpn_contact1(rpn)	(g_rp_node(rpn)->_contact1)
#define	rpn_contact2(rpn)	(g_rp_node(rpn)->_contact2)



#endif /* !defined(_USERRP_H) */
