/*
*			fscat1d.c
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/

#if defined(ONED)

#define DEBUG_STRING	"fscatter"
#include <front/fdecs.h>

	/* LOCAL Function Declarations */

/*
*		f_intfc_communication1d():
*
*	This function drives the interface communication.  Communication is
*	only performed if necessary.  Non-reflecting boundaries are processed
*	first.  One coordinate direction is considered at a time, and the
*	interface merged before going to the other direction.  Also, a
*	consistency check is performed on the components, which should catch
*	any errors made in the interface reconstruction.
*/

EXPORT bool f_intfc_communication1d(
	Front		*fr)
{
	COMPONENT	i_comp;
	INTERFACE	*intfc = fr->interf;
	INTERFACE	*sav_intfc;
	INTERFACE       *send[2], *receive[2];
	INTERFACE	*tmp_intfc;
	POINT		*pt, **p;
	RECT_GRID	*gr = fr->rect_grid;
	int		myid, dst, src, nn;
	int		i;
	float           cut, nor[3];
	bool		status = FUNCTION_SUCCEEDED;
	bool         sav_copy;

	DEBUG_ENTER(f_intfc_communication1d)
	sav_intfc = current_interface();
	set_current_interface(intfc);

	if (DEBUG)
	{
	    (void) printf("Input interface\n");
	    print_interface(intfc);
	}

	i_comp = positive_component(intfc->points[0]);

	/* Delete points in buffer regions */

	for (p = intfc->points; p && *p; ++p)
	{
	    if ((Coords(*p)[0] < gr->L[0]) || (Coords(*p)[0] > gr->U[0]) ||
		is_subdomain_boundary(Hyper_surf(*p)))
	    {
		delete_point(*p);
		if (intfc->points == NULL)
		    break;
		p = intfc->points-1;
	    }
	}

	if (DEBUG)
	{
	    (void) printf("Interface after deletion in buffer zones\n");
	    print_interface(intfc);
	}

	/* Set up interfaces to send */

	sav_copy = copy_intfc_states();
	for (i = 0; i < 2; ++i)
	{
	    switch (rect_boundary_type(intfc,0,i))
	    {
	    case SUBDOMAIN_BOUNDARY:
	    case REFLECTION_BOUNDARY:
	        if (DEBUG)
		    (void) printf("%s on side %d\n",
		                  wave_type_as_string(
				      rect_boundary_type(intfc,0,i),intfc),i);
	        set_size_of_intfc_state(size_of_state(intfc));
	        set_copy_intfc_states(YES);
	        send[i] = copy_interface(intfc);
	        if (send[i] == NULL)
	        {
		    screen("ERROR in f_intfc_communication1d(), "
		           "copy_interface() failed\n");
		    clean_up(ERROR);
	        }
		break;
	    default:
	        send[i] = NULL;
		break;
	    }
	}
	set_current_interface(intfc);
	set_copy_intfc_states(sav_copy);

	/* Clip send interfaces */

	if (send[0] != NULL)
	{
	    cut = gr->L[0] + (gr->L[0] - gr->VL[0]);
	    for (p = send[0]->points; p && *p; ++p)
	    {
	        if (Coords(*p)[0] > cut)
	        {
		    delete_point(*p);
		    if (send[0]->points == NULL)
		        break;
		    p = send[0]->points-1;
	        }
	    }
	    nor[0] = 1.0;  nor[1] = nor[2] = 0.0;
	    if (rect_boundary_type(intfc,0,0) == REFLECTION_BOUNDARY)
	        reflect_interface(send[0],gr->L,nor);
	}
	if (send[1] != NULL)
	{
	    cut = gr->U[0] + (gr->U[0] - gr->VU[0]);
	    for (p = send[1]->points; p && *p; ++p)
	    {
	        if (Coords(*p)[0] < cut)
	        {
		    delete_point(*p);
		    if (send[1]->points == NULL)
		        break;
		    p = send[1]->points-1;
	        }
	    }
	    nor[0] = -1.0;  nor[1] = nor[2] = 0.0;
	    if (rect_boundary_type(intfc,0,1) == REFLECTION_BOUNDARY)
	        reflect_interface(send[1],gr->U,nor);
	}

	/* Compress storage of the send interfaces */

	sav_copy = copy_intfc_states();
	for (i = 0; i < 2; ++i)
	{
	    if (send[i] != NULL)
	    {
	        tmp_intfc = send[i];
	        set_size_of_intfc_state(size_of_state(intfc));
	        set_copy_intfc_states(YES);
	        send[i] = copy_interface(tmp_intfc);
	        if (send[i] == NULL)
	        {
		    screen("ERROR in f_intfc_communication1d(), "
		           "copy_interface() failed\n");
		    clean_up(ERROR);
	        }
	        (void) delete_interface(tmp_intfc);
	    }
	}
	set_current_interface(intfc);
	set_copy_intfc_states(sav_copy);

	myid = pp_mynode();
	nn = pp_numnodes();

	receive[0] = receive[1] = NULL;
	if (rect_boundary_type(intfc,0,0) == REFLECTION_BOUNDARY)
	    receive[0] = send[0];
	else if (rect_boundary_type(intfc,0,0) == SUBDOMAIN_BOUNDARY)
	{
	    dst = myid-1;
	    if (dst < 0)
		dst = nn - 1;
	    send_interface(send[0],dst);
	}
	if (rect_boundary_type(intfc,0,1) == SUBDOMAIN_BOUNDARY)
	{
	    src = myid+1;
	    if (src >= nn)
		src = 0;
	    receive[1] = receive_interface(src);
	}

	if (rect_boundary_type(intfc,0,1) == REFLECTION_BOUNDARY)
	    receive[1] = send[1];
	else if (rect_boundary_type(intfc,0,1) == SUBDOMAIN_BOUNDARY)
	{
	    dst = myid+1;
	    if (dst >= nn)
		dst = 0;
	    send_interface(send[1],dst);
	}
	if (rect_boundary_type(intfc,0,0) == SUBDOMAIN_BOUNDARY)
	{
	    src = myid-1;
	    if (src < 0)
		src = nn-1;
	    receive[0] = receive_interface(src);
	}

	set_current_interface(intfc);
	set_copy_intfc_states(YES);
	for (i = 0; i < 2; ++i)
	{
	    if (receive[i] == NULL)
		continue;
	    for (p = receive[i]->points; p && *p; ++p)
		(void) copy_point(*p);
	}
	set_copy_intfc_states(sav_copy);
	for (i = 0; i < 2; ++i)
	{
	    if (send[i] != NULL)
	        (void) delete_interface(send[i]);
	    if ((receive[i] != send[i]) && (receive[i] != NULL))
		(void) delete_interface(receive[i]);
	}

	if (!set_boundary(intfc,gr,i_comp,grid_tolerance(gr)))
	{
	    screen("ERROR in f_intfc_communication1d(), "
		   "set_boundary() failed\n");
	    clean_up(ERROR);
	    return FUNCTION_FAILED;
	}
	pt = intfc->points[0];
	if (is_bdry(pt) && (wave_type(pt) == ERROR))
	{
	    wave_type(pt) = SUBDOMAIN_BOUNDARY;
	    if (size_of_state(intfc) != 0)
	    {
		obstacle_state(intfc,left_state(pt),size_of_state(intfc));
		obstacle_state(intfc,right_state(pt),size_of_state(intfc));
	    }
	}
	pt = intfc->points[intfc->num_points-1];
	if (is_bdry(pt) && (wave_type(pt) == ERROR))
	    wave_type(pt) = SUBDOMAIN_BOUNDARY;
	if (!make_point_comp_lists(intfc))
	{
	    screen("ERROR in f_intfc_communication1d(), "
		   "make_point_comp_lists failed\n");
	    clean_up(ERROR);
	    return FUNCTION_FAILED;
	}
	set_current_interface(sav_intfc);

	if (DEBUG)
	{
	    (void) printf("Final Interface\n");
	    print_interface(intfc);
	}

	DEBUG_LEAVE(f_intfc_communication1d)
	return status;
}		/*end f_intfc_communication1d*/

#endif /* defined(ONED) */
