/*
*				frp.h
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*	Contains structures related to the solution of two dimensional
*	Riemann problems.
*/

#if !defined(_FRP_H)
#define _FRP_H

#include <front/fdecs.h>

struct  _RP_NODE {
	NODE *node;
	NODE *old_node;		/* Corresponding node in fr->interf */
	int states_assigned_at_node;
	struct _RP_NODE *prev,*next;
	struct _O_CURVE	*neumann1,*neumann2,*dirichlet1,*dirichlet2,
			*subdomain1,*subdomain2;
};
typedef struct _RP_NODE RP_NODE;

struct _RPROBLEM {
		/* time zero data */

	INTERFACE	*new_intfc;	/* newfr->interf */

		/* in data */

	INTERFACE	*old_intfc;	/* oldfr->interf */
	struct _Front	*fr;		/* oldfr */
	POINTER		wave;
	float		dt;
	float		dt_frac;
	struct _RP_NODE *first_rp_node;
	struct _RP_NODE *last_rp_node;

		/* Curves in the rproblem */

	struct _O_CURVE_FAMILY *bdry_curves;
	struct _O_CURVE_FAMILY *old_bdry_curves;
	struct _O_CURVE_FAMILY *ang_ordered_curves;
	struct _O_CURVE_FAMILY *old_ang_ordered_curves;

		/* global information */

	struct _RPROBLEM	*next;
	struct _RPROBLEM	*prev;

		/* Statistical Information */
	
	int bdry_type1, bdry_type2;
	int num_nd, num_fxd, num_srce;
	int num_nod, num_bdry_nod, num_phys;
	int num_ang_ordered_curves;

};
typedef struct _RPROBLEM	RPROBLEM;

struct _F_USER_RPROBLEM {
	int size_rproblem;
	int size_rp_node;

	void (*_init_rp_nodes)(RPROBLEM*);
	void (*_delete_curve_from_rp_node)(CURVE*,RP_NODE*,RPROBLEM*);
	void (*_free_rp_node)(RP_NODE*,RPROBLEM*);
	void (*_user_free_rp_node)(RP_NODE*,RPROBLEM*);
	void (*_print_rp_node)(RP_NODE*,RPROBLEM*);
	void (*_user_print_rp_node)(RP_NODE*,RPROBLEM*);
	void (*_print_rproblem)(RPROBLEM*);
	void (*_user_print_rproblem)(RPROBLEM*);
	void (*_set_rp_statistics)(RPROBLEM*);
	void (*_set_phys_ocurves_to_null)(RP_NODE*,RPROBLEM*);
};
typedef struct _F_USER_RPROBLEM F_USER_RPROBLEM;

struct _F_RPROBLEM {
	RPROBLEM rproblem;
	F_USER_RPROBLEM f_user_rp;
};
typedef struct _F_RPROBLEM F_RPROBLEM;

#define f_rproblem(rp)	((F_RPROBLEM *) (rp))
#define f_user_rproblem(rp)	(f_rproblem(rp)->f_user_rp)


#endif /* defined(_FRP_H) */
