#ifndef VECTOR_GL_HPP
#define VECTOR_GL_HPP 1

//include your favorite opengl header first.

inline void glVertex(Vector2d const &v) {
	glVertex2dv(v.c);
}

inline void glVertex(Vector2d const &v, double const &z) {
	glVertex3d(v.c[0], v.c[1], z);
}

inline void glVertex(Vector3d const &v) {
	glVertex3dv(v.c);
}

inline void glVertex(Vector2f const &v) {
	glVertex2fv(v.c);
}

inline void glVertex(Vector2f const &v, float const &z) {
	glVertex3f(v.c[0], v.c[1], z);
}

inline void glVertex(Vector3f const &v) {
	glVertex3fv(v.c);
}

inline void glNormal(Vector3d const &v) {
	glNormal3dv(v.c);
}

inline void glNormal(Vector2d const &v, double &z) {
	glNormal3d(v.c[0], v.c[1], z);
}


inline void glNormal(Vector3f const &v) {
	glNormal3fv(v.c);
}

inline void glNormal(Vector2f const &v, float &z) {
	glNormal3f(v.c[0], v.c[1], z);
}


inline void glColor(Vector3d const &v) {
	glColor3dv(v.c);
}

inline void glColor(Vector3d const &v, double a) {
	glColor4d(v.c[0], v.c[1], v.c[2], a);
}

inline void glColor(Vector< double, 4 > const &v) {
	glColor4dv(v.c);
}

inline void glColor(Vector3f const &v) {
	glColor3fv(v.c);
}

inline void glColor(Vector3f const &v, float a) {
	glColor4f(v.c[0], v.c[1], v.c[2], a);
}

inline void glColor(Vector< float, 4 > const &v) {
	glColor4fv(v.c);
}

inline void glTranslate(Vector< float, 3 > const &v) {
	glTranslatef(v.c[0], v.c[1], v.c[2]);
}

inline void glTranslate(Vector< double, 3 > const &v) {
	glTranslated(v.c[0], v.c[1], v.c[2]);
}


#endif
