#ifndef QUAT_GL_HPP
#define QUAT_GL_HPP

#include "Quat.hpp"

inline void glRotate(Quat< double > const &a) {
	double wx = a.w * a.x;
	double wy = a.w * a.y;
	double wz = a.w * a.z;

	double xx = a.x * a.x;
	double xy = a.x * a.y;
	double xz = a.x * a.z;

	double yy = a.y * a.y;
	double yz = a.y * a.z;

	double zz = a.z * a.z;

	double mat[16] = {
		1 - 2*yy - 2*zz,	2 * xy + 2 * wz,	2 * xz - 2 * wy,	0,
		2 * xy - 2 * wz,	1 - 2*xx - 2*zz,	2 * yz + 2 * wx,	0,
		2 * xz + 2 * wy,	2 * yz - 2 * wx,	1 - 2*xx - 2*yy,	0,
		0,					0,					0,					1
	};

	glMultMatrixd(mat);
}

inline void glRotate(Quat< float > const &a) {
	float wx = a.w * a.x;
	float wy = a.w * a.y;
	float wz = a.w * a.z;

	float xx = a.x * a.x;
	float xy = a.x * a.y;
	float xz = a.x * a.z;

	float yy = a.y * a.y;
	float yz = a.y * a.z;

	float zz = a.z * a.z;

	float mat[16] = {
		1 - 2*yy - 2*zz,	2 * xy + 2 * wz,	2 * xz - 2 * wy,	0,
		2 * xy - 2 * wz,	1 - 2*xx - 2*zz,	2 * yz + 2 * wx,	0,
		2 * xz + 2 * wy,	2 * yz - 2 * wx,	1 - 2*xx - 2*yy,	0,
		0,					0,					0,					1
	};

	glMultMatrixf(mat);
}

#endif
