#ifndef LIBRARY_HPP
#define LIBRARY_HPP

#include "Skeleton.hpp"

#include <Character/Character.hpp>

#include <string>

namespace Library {
	using std::string;

	enum Annotation {
		LeftFootPlant = 1 << 0,
		RightFootPlant = 1 << 1,
	};

	//each motion provides a bare interface to many frames of poses:
	// (each pose annotated with a convenient state vector as well!)
	class Motion {
	public:
		void get_delta(unsigned int frame_from, unsigned int frame_to, Character::StateDelta &into) const;
		void get_state(unsigned int frame, Character::State &into) const;
		void get_angles(unsigned int frame, Character::Angles &into) const;
		void get_pose(unsigned int frame, Character::Pose &into) const;

		int get_annotation(unsigned int frame) const;
		void add_annotation(unsigned int frame, Annotation annotation);
		void clear_annotation(unsigned int frame, Annotation annotation);
		bool save_annotations() const;
		bool load_annotations();

		unsigned int frames() const; //length in timesteps.
		float length() const; //length in time.
		//not for modification by library users!
		Library::Skeleton const *skeleton;
		vector< double > data;
		string filename;
		vector< int > annotations; // int bitset per frame
	};


	//read in the library
	// - expects directories with one more dirs and/or one .asf, many .amc's
	void init(string base_path = "data");

	// recursively add all .afs/.amc's starting at base_path. Called by init.
	void directory_recursion(string base_path);

	//access some list of motions:
	unsigned int motion_count();
	Motion const &motion(unsigned int index);
	Motion       &motion_nonconst(unsigned int index);

	//in case you want to cache data:
	extern unsigned int signature;
};
#endif //LIBRARY_HPP
