#include "GLExtensions.hpp"
#include <iostream>
#ifndef MACOSX
#ifdef WINDOWS
//windows use wgl, methinks.
#include <wingdi.h>
#else
//linux use glx
#include <GL/glx.h>
#endif
#endif

using std::cerr;
using std::endl;

//GLExtensions::request is described below, since it is auto-generated.

void GLExtensions::reload() {
	set< string > old_set = get_set();
	get_set().clear();
	for (set< string >::iterator s = old_set.begin(); s != old_set.end(); ++s) {
		if (!GLExtensions::request(*s)) {
			cerr << "Can't reload extension '" << *s << "'. Bailing." << endl;
		}
	}
}

set< string > &GLExtensions::get_set() {
	static set< string > my_set;
	return my_set;
}

typedef void (*VoidFuncPtr)();

#ifndef MACOSX
#ifdef WINDOWS
inline VoidFuncPtr get_proc(string name) {
	return (VoidFuncPtr)wglGetProcAddress( (LPCSTR)name.c_str() );
}
#else
inline VoidFuncPtr get_proc(string name) {
	return (VoidFuncPtr)glXGetProcAddressARB( (const GLubyte *)name.c_str() );
}
#endif //WINDOWS
#endif

bool GLExtensions::request(string extension) {
#ifndef MACOSX
	bool loaded = false;
	//Load proper pointers...

	//  ...for GL_APPLE_element_array:
	if (extension == "GL_APPLE_element_array") {
		loaded = true
			&& (glDrawElementArrayAPPLE = (PFNGLDRAWELEMENTARRAYAPPLEPROC)get_proc("glDrawElementArrayAPPLE"))
			&& (glDrawRangeElementArrayAPPLE = (PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC)get_proc("glDrawRangeElementArrayAPPLE"))
			&& (glElementPointerAPPLE = (PFNGLELEMENTPOINTERAPPLEPROC)get_proc("glElementPointerAPPLE"))
			&& (glMultiDrawElementArrayAPPLE = (PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC)get_proc("glMultiDrawElementArrayAPPLE"))
			&& (glMultiDrawRangeElementArrayAPPLE = (PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC)get_proc("glMultiDrawRangeElementArrayAPPLE"))
			;
	}

	//  ...for GL_APPLE_fence:
	else if (extension == "GL_APPLE_fence") {
		loaded = true
			&& (glDeleteFencesAPPLE = (PFNGLDELETEFENCESAPPLEPROC)get_proc("glDeleteFencesAPPLE"))
			&& (glFinishFenceAPPLE = (PFNGLFINISHFENCEAPPLEPROC)get_proc("glFinishFenceAPPLE"))
			&& (glFinishObjectAPPLE = (PFNGLFINISHOBJECTAPPLEPROC)get_proc("glFinishObjectAPPLE"))
			&& (glGenFencesAPPLE = (PFNGLGENFENCESAPPLEPROC)get_proc("glGenFencesAPPLE"))
			&& (glIsFenceAPPLE = (PFNGLISFENCEAPPLEPROC)get_proc("glIsFenceAPPLE"))
			&& (glSetFenceAPPLE = (PFNGLSETFENCEAPPLEPROC)get_proc("glSetFenceAPPLE"))
			&& (glTestFenceAPPLE = (PFNGLTESTFENCEAPPLEPROC)get_proc("glTestFenceAPPLE"))
			&& (glTestObjectAPPLE = (PFNGLTESTOBJECTAPPLEPROC)get_proc("glTestObjectAPPLE"))
			;
	}

	//  ...for GL_APPLE_vertex_array_object:
	else if (extension == "GL_APPLE_vertex_array_object") {
		loaded = true
			&& (glBindVertexArrayAPPLE = (PFNGLBINDVERTEXARRAYAPPLEPROC)get_proc("glBindVertexArrayAPPLE"))
			&& (glDeleteVertexArraysAPPLE = (PFNGLDELETEVERTEXARRAYSAPPLEPROC)get_proc("glDeleteVertexArraysAPPLE"))
			&& (glGenVertexArraysAPPLE = (PFNGLGENVERTEXARRAYSAPPLEPROC)get_proc("glGenVertexArraysAPPLE"))
			&& (glIsVertexArrayAPPLE = (PFNGLISVERTEXARRAYAPPLEPROC)get_proc("glIsVertexArrayAPPLE"))
			;
	}

	//  ...for GL_APPLE_vertex_array_range:
	else if (extension == "GL_APPLE_vertex_array_range") {
		loaded = true
			&& (glFlushVertexArrayRangeAPPLE = (PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC)get_proc("glFlushVertexArrayRangeAPPLE"))
			&& (glVertexArrayParameteriAPPLE = (PFNGLVERTEXARRAYPARAMETERIAPPLEPROC)get_proc("glVertexArrayParameteriAPPLE"))
			&& (glVertexArrayRangeAPPLE = (PFNGLVERTEXARRAYRANGEAPPLEPROC)get_proc("glVertexArrayRangeAPPLE"))
			;
	}

	//  ...for GL_ARB_color_buffer_float:
	else if (extension == "GL_ARB_color_buffer_float") {
		loaded = true
			&& (glClampColorARB = (PFNGLCLAMPCOLORARBPROC)get_proc("glClampColorARB"))
			;
	}

	//  ...for GL_ARB_draw_buffers:
	else if (extension == "GL_ARB_draw_buffers") {
		loaded = true
			&& (glDrawBuffersARB = (PFNGLDRAWBUFFERSARBPROC)get_proc("glDrawBuffersARB"))
			;
	}

	//  ...for GL_ARB_matrix_palette:
	else if (extension == "GL_ARB_matrix_palette") {
		loaded = true
			&& (glCurrentPaletteMatrixARB = (PFNGLCURRENTPALETTEMATRIXARBPROC)get_proc("glCurrentPaletteMatrixARB"))
			&& (glMatrixIndexPointerARB = (PFNGLMATRIXINDEXPOINTERARBPROC)get_proc("glMatrixIndexPointerARB"))
			&& (glMatrixIndexubvARB = (PFNGLMATRIXINDEXUBVARBPROC)get_proc("glMatrixIndexubvARB"))
			&& (glMatrixIndexuivARB = (PFNGLMATRIXINDEXUIVARBPROC)get_proc("glMatrixIndexuivARB"))
			&& (glMatrixIndexusvARB = (PFNGLMATRIXINDEXUSVARBPROC)get_proc("glMatrixIndexusvARB"))
			;
	}

	//  ...for GL_ARB_multisample:
	else if (extension == "GL_ARB_multisample") {
		loaded = true
			&& (glSampleCoverageARB = (PFNGLSAMPLECOVERAGEARBPROC)get_proc("glSampleCoverageARB"))
			;
	}

	//  ...for GL_ARB_multitexture:
	else if (extension == "GL_ARB_multitexture") {
		loaded = true
			&& (glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)get_proc("glActiveTextureARB"))
			&& (glClientActiveTextureARB = (PFNGLCLIENTACTIVETEXTUREARBPROC)get_proc("glClientActiveTextureARB"))
			&& (glMultiTexCoord1dARB = (PFNGLMULTITEXCOORD1DARBPROC)get_proc("glMultiTexCoord1dARB"))
			&& (glMultiTexCoord1dvARB = (PFNGLMULTITEXCOORD1DVARBPROC)get_proc("glMultiTexCoord1dvARB"))
			&& (glMultiTexCoord1fARB = (PFNGLMULTITEXCOORD1FARBPROC)get_proc("glMultiTexCoord1fARB"))
			&& (glMultiTexCoord1fvARB = (PFNGLMULTITEXCOORD1FVARBPROC)get_proc("glMultiTexCoord1fvARB"))
			&& (glMultiTexCoord1iARB = (PFNGLMULTITEXCOORD1IARBPROC)get_proc("glMultiTexCoord1iARB"))
			&& (glMultiTexCoord1ivARB = (PFNGLMULTITEXCOORD1IVARBPROC)get_proc("glMultiTexCoord1ivARB"))
			&& (glMultiTexCoord1sARB = (PFNGLMULTITEXCOORD1SARBPROC)get_proc("glMultiTexCoord1sARB"))
			&& (glMultiTexCoord1svARB = (PFNGLMULTITEXCOORD1SVARBPROC)get_proc("glMultiTexCoord1svARB"))
			&& (glMultiTexCoord2dARB = (PFNGLMULTITEXCOORD2DARBPROC)get_proc("glMultiTexCoord2dARB"))
			&& (glMultiTexCoord2dvARB = (PFNGLMULTITEXCOORD2DVARBPROC)get_proc("glMultiTexCoord2dvARB"))
			&& (glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC)get_proc("glMultiTexCoord2fARB"))
			&& (glMultiTexCoord2fvARB = (PFNGLMULTITEXCOORD2FVARBPROC)get_proc("glMultiTexCoord2fvARB"))
			&& (glMultiTexCoord2iARB = (PFNGLMULTITEXCOORD2IARBPROC)get_proc("glMultiTexCoord2iARB"))
			&& (glMultiTexCoord2ivARB = (PFNGLMULTITEXCOORD2IVARBPROC)get_proc("glMultiTexCoord2ivARB"))
			&& (glMultiTexCoord2sARB = (PFNGLMULTITEXCOORD2SARBPROC)get_proc("glMultiTexCoord2sARB"))
			&& (glMultiTexCoord2svARB = (PFNGLMULTITEXCOORD2SVARBPROC)get_proc("glMultiTexCoord2svARB"))
			&& (glMultiTexCoord3dARB = (PFNGLMULTITEXCOORD3DARBPROC)get_proc("glMultiTexCoord3dARB"))
			&& (glMultiTexCoord3dvARB = (PFNGLMULTITEXCOORD3DVARBPROC)get_proc("glMultiTexCoord3dvARB"))
			&& (glMultiTexCoord3fARB = (PFNGLMULTITEXCOORD3FARBPROC)get_proc("glMultiTexCoord3fARB"))
			&& (glMultiTexCoord3fvARB = (PFNGLMULTITEXCOORD3FVARBPROC)get_proc("glMultiTexCoord3fvARB"))
			&& (glMultiTexCoord3iARB = (PFNGLMULTITEXCOORD3IARBPROC)get_proc("glMultiTexCoord3iARB"))
			&& (glMultiTexCoord3ivARB = (PFNGLMULTITEXCOORD3IVARBPROC)get_proc("glMultiTexCoord3ivARB"))
			&& (glMultiTexCoord3sARB = (PFNGLMULTITEXCOORD3SARBPROC)get_proc("glMultiTexCoord3sARB"))
			&& (glMultiTexCoord3svARB = (PFNGLMULTITEXCOORD3SVARBPROC)get_proc("glMultiTexCoord3svARB"))
			&& (glMultiTexCoord4dARB = (PFNGLMULTITEXCOORD4DARBPROC)get_proc("glMultiTexCoord4dARB"))
			&& (glMultiTexCoord4dvARB = (PFNGLMULTITEXCOORD4DVARBPROC)get_proc("glMultiTexCoord4dvARB"))
			&& (glMultiTexCoord4fARB = (PFNGLMULTITEXCOORD4FARBPROC)get_proc("glMultiTexCoord4fARB"))
			&& (glMultiTexCoord4fvARB = (PFNGLMULTITEXCOORD4FVARBPROC)get_proc("glMultiTexCoord4fvARB"))
			&& (glMultiTexCoord4iARB = (PFNGLMULTITEXCOORD4IARBPROC)get_proc("glMultiTexCoord4iARB"))
			&& (glMultiTexCoord4ivARB = (PFNGLMULTITEXCOORD4IVARBPROC)get_proc("glMultiTexCoord4ivARB"))
			&& (glMultiTexCoord4sARB = (PFNGLMULTITEXCOORD4SARBPROC)get_proc("glMultiTexCoord4sARB"))
			&& (glMultiTexCoord4svARB = (PFNGLMULTITEXCOORD4SVARBPROC)get_proc("glMultiTexCoord4svARB"))
			;
	}

	//  ...for GL_ARB_occlusion_query:
	else if (extension == "GL_ARB_occlusion_query") {
		loaded = true
			&& (glBeginQueryARB = (PFNGLBEGINQUERYARBPROC)get_proc("glBeginQueryARB"))
			&& (glDeleteQueriesARB = (PFNGLDELETEQUERIESARBPROC)get_proc("glDeleteQueriesARB"))
			&& (glEndQueryARB = (PFNGLENDQUERYARBPROC)get_proc("glEndQueryARB"))
			&& (glGenQueriesARB = (PFNGLGENQUERIESARBPROC)get_proc("glGenQueriesARB"))
			&& (glGetQueryivARB = (PFNGLGETQUERYIVARBPROC)get_proc("glGetQueryivARB"))
			&& (glGetQueryObjectivARB = (PFNGLGETQUERYOBJECTIVARBPROC)get_proc("glGetQueryObjectivARB"))
			&& (glGetQueryObjectuivARB = (PFNGLGETQUERYOBJECTUIVARBPROC)get_proc("glGetQueryObjectuivARB"))
			&& (glIsQueryARB = (PFNGLISQUERYARBPROC)get_proc("glIsQueryARB"))
			;
	}

	//  ...for GL_ARB_point_parameters:
	else if (extension == "GL_ARB_point_parameters") {
		loaded = true
			&& (glPointParameterfARB = (PFNGLPOINTPARAMETERFARBPROC)get_proc("glPointParameterfARB"))
			&& (glPointParameterfvARB = (PFNGLPOINTPARAMETERFVARBPROC)get_proc("glPointParameterfvARB"))
			;
	}

	//  ...for GL_ARB_shader_objects:
	else if (extension == "GL_ARB_shader_objects") {
		loaded = true
			&& (glAttachObjectARB = (PFNGLATTACHOBJECTARBPROC)get_proc("glAttachObjectARB"))
			&& (glCompileShaderARB = (PFNGLCOMPILESHADERARBPROC)get_proc("glCompileShaderARB"))
			&& (glCreateProgramObjectARB = (PFNGLCREATEPROGRAMOBJECTARBPROC)get_proc("glCreateProgramObjectARB"))
			&& (glCreateShaderObjectARB = (PFNGLCREATESHADEROBJECTARBPROC)get_proc("glCreateShaderObjectARB"))
			&& (glDeleteObjectARB = (PFNGLDELETEOBJECTARBPROC)get_proc("glDeleteObjectARB"))
			&& (glDetachObjectARB = (PFNGLDETACHOBJECTARBPROC)get_proc("glDetachObjectARB"))
			&& (glGetActiveUniformARB = (PFNGLGETACTIVEUNIFORMARBPROC)get_proc("glGetActiveUniformARB"))
			&& (glGetAttachedObjectsARB = (PFNGLGETATTACHEDOBJECTSARBPROC)get_proc("glGetAttachedObjectsARB"))
			&& (glGetHandleARB = (PFNGLGETHANDLEARBPROC)get_proc("glGetHandleARB"))
			&& (glGetInfoLogARB = (PFNGLGETINFOLOGARBPROC)get_proc("glGetInfoLogARB"))
			&& (glGetObjectParameterfvARB = (PFNGLGETOBJECTPARAMETERFVARBPROC)get_proc("glGetObjectParameterfvARB"))
			&& (glGetObjectParameterivARB = (PFNGLGETOBJECTPARAMETERIVARBPROC)get_proc("glGetObjectParameterivARB"))
			&& (glGetShaderSourceARB = (PFNGLGETSHADERSOURCEARBPROC)get_proc("glGetShaderSourceARB"))
			&& (glGetUniformfvARB = (PFNGLGETUNIFORMFVARBPROC)get_proc("glGetUniformfvARB"))
			&& (glGetUniformivARB = (PFNGLGETUNIFORMIVARBPROC)get_proc("glGetUniformivARB"))
			&& (glGetUniformLocationARB = (PFNGLGETUNIFORMLOCATIONARBPROC)get_proc("glGetUniformLocationARB"))
			&& (glLinkProgramARB = (PFNGLLINKPROGRAMARBPROC)get_proc("glLinkProgramARB"))
			&& (glShaderSourceARB = (PFNGLSHADERSOURCEARBPROC)get_proc("glShaderSourceARB"))
			&& (glUniform1fARB = (PFNGLUNIFORM1FARBPROC)get_proc("glUniform1fARB"))
			&& (glUniform1fvARB = (PFNGLUNIFORM1FVARBPROC)get_proc("glUniform1fvARB"))
			&& (glUniform1iARB = (PFNGLUNIFORM1IARBPROC)get_proc("glUniform1iARB"))
			&& (glUniform1ivARB = (PFNGLUNIFORM1IVARBPROC)get_proc("glUniform1ivARB"))
			&& (glUniform2fARB = (PFNGLUNIFORM2FARBPROC)get_proc("glUniform2fARB"))
			&& (glUniform2fvARB = (PFNGLUNIFORM2FVARBPROC)get_proc("glUniform2fvARB"))
			&& (glUniform2iARB = (PFNGLUNIFORM2IARBPROC)get_proc("glUniform2iARB"))
			&& (glUniform2ivARB = (PFNGLUNIFORM2IVARBPROC)get_proc("glUniform2ivARB"))
			&& (glUniform3fARB = (PFNGLUNIFORM3FARBPROC)get_proc("glUniform3fARB"))
			&& (glUniform3fvARB = (PFNGLUNIFORM3FVARBPROC)get_proc("glUniform3fvARB"))
			&& (glUniform3iARB = (PFNGLUNIFORM3IARBPROC)get_proc("glUniform3iARB"))
			&& (glUniform3ivARB = (PFNGLUNIFORM3IVARBPROC)get_proc("glUniform3ivARB"))
			&& (glUniform4fARB = (PFNGLUNIFORM4FARBPROC)get_proc("glUniform4fARB"))
			&& (glUniform4fvARB = (PFNGLUNIFORM4FVARBPROC)get_proc("glUniform4fvARB"))
			&& (glUniform4iARB = (PFNGLUNIFORM4IARBPROC)get_proc("glUniform4iARB"))
			&& (glUniform4ivARB = (PFNGLUNIFORM4IVARBPROC)get_proc("glUniform4ivARB"))
			&& (glUniformMatrix2fvARB = (PFNGLUNIFORMMATRIX2FVARBPROC)get_proc("glUniformMatrix2fvARB"))
			&& (glUniformMatrix3fvARB = (PFNGLUNIFORMMATRIX3FVARBPROC)get_proc("glUniformMatrix3fvARB"))
			&& (glUniformMatrix4fvARB = (PFNGLUNIFORMMATRIX4FVARBPROC)get_proc("glUniformMatrix4fvARB"))
			&& (glUseProgramObjectARB = (PFNGLUSEPROGRAMOBJECTARBPROC)get_proc("glUseProgramObjectARB"))
			&& (glValidateProgramARB = (PFNGLVALIDATEPROGRAMARBPROC)get_proc("glValidateProgramARB"))
			;
	}

	//  ...for GL_ARB_texture_compression:
	else if (extension == "GL_ARB_texture_compression") {
		loaded = true
			&& (glCompressedTexImage1DARB = (PFNGLCOMPRESSEDTEXIMAGE1DARBPROC)get_proc("glCompressedTexImage1DARB"))
			&& (glCompressedTexImage2DARB = (PFNGLCOMPRESSEDTEXIMAGE2DARBPROC)get_proc("glCompressedTexImage2DARB"))
			&& (glCompressedTexImage3DARB = (PFNGLCOMPRESSEDTEXIMAGE3DARBPROC)get_proc("glCompressedTexImage3DARB"))
			&& (glCompressedTexSubImage1DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC)get_proc("glCompressedTexSubImage1DARB"))
			&& (glCompressedTexSubImage2DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC)get_proc("glCompressedTexSubImage2DARB"))
			&& (glCompressedTexSubImage3DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC)get_proc("glCompressedTexSubImage3DARB"))
			&& (glGetCompressedTexImageARB = (PFNGLGETCOMPRESSEDTEXIMAGEARBPROC)get_proc("glGetCompressedTexImageARB"))
			;
	}

	//  ...for GL_ARB_transpose_matrix:
	else if (extension == "GL_ARB_transpose_matrix") {
		loaded = true
			&& (glLoadTransposeMatrixdARB = (PFNGLLOADTRANSPOSEMATRIXDARBPROC)get_proc("glLoadTransposeMatrixdARB"))
			&& (glLoadTransposeMatrixfARB = (PFNGLLOADTRANSPOSEMATRIXFARBPROC)get_proc("glLoadTransposeMatrixfARB"))
			&& (glMultTransposeMatrixdARB = (PFNGLMULTTRANSPOSEMATRIXDARBPROC)get_proc("glMultTransposeMatrixdARB"))
			&& (glMultTransposeMatrixfARB = (PFNGLMULTTRANSPOSEMATRIXFARBPROC)get_proc("glMultTransposeMatrixfARB"))
			;
	}

	//  ...for GL_ARB_vertex_blend:
	else if (extension == "GL_ARB_vertex_blend") {
		loaded = true
			&& (glVertexBlendARB = (PFNGLVERTEXBLENDARBPROC)get_proc("glVertexBlendARB"))
			&& (glWeightbvARB = (PFNGLWEIGHTBVARBPROC)get_proc("glWeightbvARB"))
			&& (glWeightdvARB = (PFNGLWEIGHTDVARBPROC)get_proc("glWeightdvARB"))
			&& (glWeightfvARB = (PFNGLWEIGHTFVARBPROC)get_proc("glWeightfvARB"))
			&& (glWeightivARB = (PFNGLWEIGHTIVARBPROC)get_proc("glWeightivARB"))
			&& (glWeightPointerARB = (PFNGLWEIGHTPOINTERARBPROC)get_proc("glWeightPointerARB"))
			&& (glWeightsvARB = (PFNGLWEIGHTSVARBPROC)get_proc("glWeightsvARB"))
			&& (glWeightubvARB = (PFNGLWEIGHTUBVARBPROC)get_proc("glWeightubvARB"))
			&& (glWeightuivARB = (PFNGLWEIGHTUIVARBPROC)get_proc("glWeightuivARB"))
			&& (glWeightusvARB = (PFNGLWEIGHTUSVARBPROC)get_proc("glWeightusvARB"))
			;
	}

	//  ...for GL_ARB_vertex_buffer_object:
	else if (extension == "GL_ARB_vertex_buffer_object") {
		loaded = true
			&& (glBindBufferARB = (PFNGLBINDBUFFERARBPROC)get_proc("glBindBufferARB"))
			&& (glBufferDataARB = (PFNGLBUFFERDATAARBPROC)get_proc("glBufferDataARB"))
			&& (glBufferSubDataARB = (PFNGLBUFFERSUBDATAARBPROC)get_proc("glBufferSubDataARB"))
			&& (glDeleteBuffersARB = (PFNGLDELETEBUFFERSARBPROC)get_proc("glDeleteBuffersARB"))
			&& (glGenBuffersARB = (PFNGLGENBUFFERSARBPROC)get_proc("glGenBuffersARB"))
			&& (glGetBufferParameterivARB = (PFNGLGETBUFFERPARAMETERIVARBPROC)get_proc("glGetBufferParameterivARB"))
			&& (glGetBufferPointervARB = (PFNGLGETBUFFERPOINTERVARBPROC)get_proc("glGetBufferPointervARB"))
			&& (glGetBufferSubDataARB = (PFNGLGETBUFFERSUBDATAARBPROC)get_proc("glGetBufferSubDataARB"))
			&& (glIsBufferARB = (PFNGLISBUFFERARBPROC)get_proc("glIsBufferARB"))
			&& (glMapBufferARB = (PFNGLMAPBUFFERARBPROC)get_proc("glMapBufferARB"))
			&& (glUnmapBufferARB = (PFNGLUNMAPBUFFERARBPROC)get_proc("glUnmapBufferARB"))
			;
	}

	//  ...for GL_ARB_vertex_program:
	else if (extension == "GL_ARB_vertex_program") {
		loaded = true
			&& (glBindProgramARB = (PFNGLBINDPROGRAMARBPROC)get_proc("glBindProgramARB"))
			&& (glDeleteProgramsARB = (PFNGLDELETEPROGRAMSARBPROC)get_proc("glDeleteProgramsARB"))
			&& (glDisableVertexAttribArrayARB = (PFNGLDISABLEVERTEXATTRIBARRAYARBPROC)get_proc("glDisableVertexAttribArrayARB"))
			&& (glEnableVertexAttribArrayARB = (PFNGLENABLEVERTEXATTRIBARRAYARBPROC)get_proc("glEnableVertexAttribArrayARB"))
			&& (glGenProgramsARB = (PFNGLGENPROGRAMSARBPROC)get_proc("glGenProgramsARB"))
			&& (glGetProgramEnvParameterdvARB = (PFNGLGETPROGRAMENVPARAMETERDVARBPROC)get_proc("glGetProgramEnvParameterdvARB"))
			&& (glGetProgramEnvParameterfvARB = (PFNGLGETPROGRAMENVPARAMETERFVARBPROC)get_proc("glGetProgramEnvParameterfvARB"))
			&& (glGetProgramivARB = (PFNGLGETPROGRAMIVARBPROC)get_proc("glGetProgramivARB"))
			&& (glGetProgramLocalParameterdvARB = (PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC)get_proc("glGetProgramLocalParameterdvARB"))
			&& (glGetProgramLocalParameterfvARB = (PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC)get_proc("glGetProgramLocalParameterfvARB"))
			&& (glGetProgramStringARB = (PFNGLGETPROGRAMSTRINGARBPROC)get_proc("glGetProgramStringARB"))
			&& (glGetVertexAttribdvARB = (PFNGLGETVERTEXATTRIBDVARBPROC)get_proc("glGetVertexAttribdvARB"))
			&& (glGetVertexAttribfvARB = (PFNGLGETVERTEXATTRIBFVARBPROC)get_proc("glGetVertexAttribfvARB"))
			&& (glGetVertexAttribivARB = (PFNGLGETVERTEXATTRIBIVARBPROC)get_proc("glGetVertexAttribivARB"))
			&& (glGetVertexAttribPointervARB = (PFNGLGETVERTEXATTRIBPOINTERVARBPROC)get_proc("glGetVertexAttribPointervARB"))
			&& (glIsProgramARB = (PFNGLISPROGRAMARBPROC)get_proc("glIsProgramARB"))
			&& (glProgramEnvParameter4dARB = (PFNGLPROGRAMENVPARAMETER4DARBPROC)get_proc("glProgramEnvParameter4dARB"))
			&& (glProgramEnvParameter4dvARB = (PFNGLPROGRAMENVPARAMETER4DVARBPROC)get_proc("glProgramEnvParameter4dvARB"))
			&& (glProgramEnvParameter4fARB = (PFNGLPROGRAMENVPARAMETER4FARBPROC)get_proc("glProgramEnvParameter4fARB"))
			&& (glProgramEnvParameter4fvARB = (PFNGLPROGRAMENVPARAMETER4FVARBPROC)get_proc("glProgramEnvParameter4fvARB"))
			&& (glProgramLocalParameter4dARB = (PFNGLPROGRAMLOCALPARAMETER4DARBPROC)get_proc("glProgramLocalParameter4dARB"))
			&& (glProgramLocalParameter4dvARB = (PFNGLPROGRAMLOCALPARAMETER4DVARBPROC)get_proc("glProgramLocalParameter4dvARB"))
			&& (glProgramLocalParameter4fARB = (PFNGLPROGRAMLOCALPARAMETER4FARBPROC)get_proc("glProgramLocalParameter4fARB"))
			&& (glProgramLocalParameter4fvARB = (PFNGLPROGRAMLOCALPARAMETER4FVARBPROC)get_proc("glProgramLocalParameter4fvARB"))
			&& (glProgramStringARB = (PFNGLPROGRAMSTRINGARBPROC)get_proc("glProgramStringARB"))
			&& (glVertexAttrib1dARB = (PFNGLVERTEXATTRIB1DARBPROC)get_proc("glVertexAttrib1dARB"))
			&& (glVertexAttrib1dvARB = (PFNGLVERTEXATTRIB1DVARBPROC)get_proc("glVertexAttrib1dvARB"))
			&& (glVertexAttrib1fARB = (PFNGLVERTEXATTRIB1FARBPROC)get_proc("glVertexAttrib1fARB"))
			&& (glVertexAttrib1fvARB = (PFNGLVERTEXATTRIB1FVARBPROC)get_proc("glVertexAttrib1fvARB"))
			&& (glVertexAttrib1sARB = (PFNGLVERTEXATTRIB1SARBPROC)get_proc("glVertexAttrib1sARB"))
			&& (glVertexAttrib1svARB = (PFNGLVERTEXATTRIB1SVARBPROC)get_proc("glVertexAttrib1svARB"))
			&& (glVertexAttrib2dARB = (PFNGLVERTEXATTRIB2DARBPROC)get_proc("glVertexAttrib2dARB"))
			&& (glVertexAttrib2dvARB = (PFNGLVERTEXATTRIB2DVARBPROC)get_proc("glVertexAttrib2dvARB"))
			&& (glVertexAttrib2fARB = (PFNGLVERTEXATTRIB2FARBPROC)get_proc("glVertexAttrib2fARB"))
			&& (glVertexAttrib2fvARB = (PFNGLVERTEXATTRIB2FVARBPROC)get_proc("glVertexAttrib2fvARB"))
			&& (glVertexAttrib2sARB = (PFNGLVERTEXATTRIB2SARBPROC)get_proc("glVertexAttrib2sARB"))
			&& (glVertexAttrib2svARB = (PFNGLVERTEXATTRIB2SVARBPROC)get_proc("glVertexAttrib2svARB"))
			&& (glVertexAttrib3dARB = (PFNGLVERTEXATTRIB3DARBPROC)get_proc("glVertexAttrib3dARB"))
			&& (glVertexAttrib3dvARB = (PFNGLVERTEXATTRIB3DVARBPROC)get_proc("glVertexAttrib3dvARB"))
			&& (glVertexAttrib3fARB = (PFNGLVERTEXATTRIB3FARBPROC)get_proc("glVertexAttrib3fARB"))
			&& (glVertexAttrib3fvARB = (PFNGLVERTEXATTRIB3FVARBPROC)get_proc("glVertexAttrib3fvARB"))
			&& (glVertexAttrib3sARB = (PFNGLVERTEXATTRIB3SARBPROC)get_proc("glVertexAttrib3sARB"))
			&& (glVertexAttrib3svARB = (PFNGLVERTEXATTRIB3SVARBPROC)get_proc("glVertexAttrib3svARB"))
			&& (glVertexAttrib4bvARB = (PFNGLVERTEXATTRIB4BVARBPROC)get_proc("glVertexAttrib4bvARB"))
			&& (glVertexAttrib4dARB = (PFNGLVERTEXATTRIB4DARBPROC)get_proc("glVertexAttrib4dARB"))
			&& (glVertexAttrib4dvARB = (PFNGLVERTEXATTRIB4DVARBPROC)get_proc("glVertexAttrib4dvARB"))
			&& (glVertexAttrib4fARB = (PFNGLVERTEXATTRIB4FARBPROC)get_proc("glVertexAttrib4fARB"))
			&& (glVertexAttrib4fvARB = (PFNGLVERTEXATTRIB4FVARBPROC)get_proc("glVertexAttrib4fvARB"))
			&& (glVertexAttrib4ivARB = (PFNGLVERTEXATTRIB4IVARBPROC)get_proc("glVertexAttrib4ivARB"))
			&& (glVertexAttrib4NbvARB = (PFNGLVERTEXATTRIB4NBVARBPROC)get_proc("glVertexAttrib4NbvARB"))
			&& (glVertexAttrib4NivARB = (PFNGLVERTEXATTRIB4NIVARBPROC)get_proc("glVertexAttrib4NivARB"))
			&& (glVertexAttrib4NsvARB = (PFNGLVERTEXATTRIB4NSVARBPROC)get_proc("glVertexAttrib4NsvARB"))
			&& (glVertexAttrib4NubARB = (PFNGLVERTEXATTRIB4NUBARBPROC)get_proc("glVertexAttrib4NubARB"))
			&& (glVertexAttrib4NubvARB = (PFNGLVERTEXATTRIB4NUBVARBPROC)get_proc("glVertexAttrib4NubvARB"))
			&& (glVertexAttrib4NuivARB = (PFNGLVERTEXATTRIB4NUIVARBPROC)get_proc("glVertexAttrib4NuivARB"))
			&& (glVertexAttrib4NusvARB = (PFNGLVERTEXATTRIB4NUSVARBPROC)get_proc("glVertexAttrib4NusvARB"))
			&& (glVertexAttrib4sARB = (PFNGLVERTEXATTRIB4SARBPROC)get_proc("glVertexAttrib4sARB"))
			&& (glVertexAttrib4svARB = (PFNGLVERTEXATTRIB4SVARBPROC)get_proc("glVertexAttrib4svARB"))
			&& (glVertexAttrib4ubvARB = (PFNGLVERTEXATTRIB4UBVARBPROC)get_proc("glVertexAttrib4ubvARB"))
			&& (glVertexAttrib4uivARB = (PFNGLVERTEXATTRIB4UIVARBPROC)get_proc("glVertexAttrib4uivARB"))
			&& (glVertexAttrib4usvARB = (PFNGLVERTEXATTRIB4USVARBPROC)get_proc("glVertexAttrib4usvARB"))
			&& (glVertexAttribPointerARB = (PFNGLVERTEXATTRIBPOINTERARBPROC)get_proc("glVertexAttribPointerARB"))
			;
	}

	//  ...for GL_ARB_vertex_shader:
	else if (extension == "GL_ARB_vertex_shader") {
		loaded = true
			&& (glBindAttribLocationARB = (PFNGLBINDATTRIBLOCATIONARBPROC)get_proc("glBindAttribLocationARB"))
			&& (glGetActiveAttribARB = (PFNGLGETACTIVEATTRIBARBPROC)get_proc("glGetActiveAttribARB"))
			&& (glGetAttribLocationARB = (PFNGLGETATTRIBLOCATIONARBPROC)get_proc("glGetAttribLocationARB"))
			;
	}

	//  ...for GL_ARB_window_pos:
	else if (extension == "GL_ARB_window_pos") {
		loaded = true
			&& (glWindowPos2dARB = (PFNGLWINDOWPOS2DARBPROC)get_proc("glWindowPos2dARB"))
			&& (glWindowPos2dvARB = (PFNGLWINDOWPOS2DVARBPROC)get_proc("glWindowPos2dvARB"))
			&& (glWindowPos2fARB = (PFNGLWINDOWPOS2FARBPROC)get_proc("glWindowPos2fARB"))
			&& (glWindowPos2fvARB = (PFNGLWINDOWPOS2FVARBPROC)get_proc("glWindowPos2fvARB"))
			&& (glWindowPos2iARB = (PFNGLWINDOWPOS2IARBPROC)get_proc("glWindowPos2iARB"))
			&& (glWindowPos2ivARB = (PFNGLWINDOWPOS2IVARBPROC)get_proc("glWindowPos2ivARB"))
			&& (glWindowPos2sARB = (PFNGLWINDOWPOS2SARBPROC)get_proc("glWindowPos2sARB"))
			&& (glWindowPos2svARB = (PFNGLWINDOWPOS2SVARBPROC)get_proc("glWindowPos2svARB"))
			&& (glWindowPos3dARB = (PFNGLWINDOWPOS3DARBPROC)get_proc("glWindowPos3dARB"))
			&& (glWindowPos3dvARB = (PFNGLWINDOWPOS3DVARBPROC)get_proc("glWindowPos3dvARB"))
			&& (glWindowPos3fARB = (PFNGLWINDOWPOS3FARBPROC)get_proc("glWindowPos3fARB"))
			&& (glWindowPos3fvARB = (PFNGLWINDOWPOS3FVARBPROC)get_proc("glWindowPos3fvARB"))
			&& (glWindowPos3iARB = (PFNGLWINDOWPOS3IARBPROC)get_proc("glWindowPos3iARB"))
			&& (glWindowPos3ivARB = (PFNGLWINDOWPOS3IVARBPROC)get_proc("glWindowPos3ivARB"))
			&& (glWindowPos3sARB = (PFNGLWINDOWPOS3SARBPROC)get_proc("glWindowPos3sARB"))
			&& (glWindowPos3svARB = (PFNGLWINDOWPOS3SVARBPROC)get_proc("glWindowPos3svARB"))
			;
	}

	//  ...for GL_ATI_draw_buffers:
	else if (extension == "GL_ATI_draw_buffers") {
		loaded = true
			&& (glDrawBuffersATI = (PFNGLDRAWBUFFERSATIPROC)get_proc("glDrawBuffersATI"))
			;
	}

	//  ...for GL_ATI_element_array:
	else if (extension == "GL_ATI_element_array") {
		loaded = true
			&& (glDrawElementArrayATI = (PFNGLDRAWELEMENTARRAYATIPROC)get_proc("glDrawElementArrayATI"))
			&& (glDrawRangeElementArrayATI = (PFNGLDRAWRANGEELEMENTARRAYATIPROC)get_proc("glDrawRangeElementArrayATI"))
			&& (glElementPointerATI = (PFNGLELEMENTPOINTERATIPROC)get_proc("glElementPointerATI"))
			;
	}

	//  ...for GL_ATI_envmap_bumpmap:
	else if (extension == "GL_ATI_envmap_bumpmap") {
		loaded = true
			&& (glGetTexBumpParameterfvATI = (PFNGLGETTEXBUMPPARAMETERFVATIPROC)get_proc("glGetTexBumpParameterfvATI"))
			&& (glGetTexBumpParameterivATI = (PFNGLGETTEXBUMPPARAMETERIVATIPROC)get_proc("glGetTexBumpParameterivATI"))
			&& (glTexBumpParameterfvATI = (PFNGLTEXBUMPPARAMETERFVATIPROC)get_proc("glTexBumpParameterfvATI"))
			&& (glTexBumpParameterivATI = (PFNGLTEXBUMPPARAMETERIVATIPROC)get_proc("glTexBumpParameterivATI"))
			;
	}

	//  ...for GL_ATI_fragment_shader:
	else if (extension == "GL_ATI_fragment_shader") {
		loaded = true
			&& (glAlphaFragmentOp1ATI = (PFNGLALPHAFRAGMENTOP1ATIPROC)get_proc("glAlphaFragmentOp1ATI"))
			&& (glAlphaFragmentOp2ATI = (PFNGLALPHAFRAGMENTOP2ATIPROC)get_proc("glAlphaFragmentOp2ATI"))
			&& (glAlphaFragmentOp3ATI = (PFNGLALPHAFRAGMENTOP3ATIPROC)get_proc("glAlphaFragmentOp3ATI"))
			&& (glBeginFragmentShaderATI = (PFNGLBEGINFRAGMENTSHADERATIPROC)get_proc("glBeginFragmentShaderATI"))
			&& (glBindFragmentShaderATI = (PFNGLBINDFRAGMENTSHADERATIPROC)get_proc("glBindFragmentShaderATI"))
			&& (glColorFragmentOp1ATI = (PFNGLCOLORFRAGMENTOP1ATIPROC)get_proc("glColorFragmentOp1ATI"))
			&& (glColorFragmentOp2ATI = (PFNGLCOLORFRAGMENTOP2ATIPROC)get_proc("glColorFragmentOp2ATI"))
			&& (glColorFragmentOp3ATI = (PFNGLCOLORFRAGMENTOP3ATIPROC)get_proc("glColorFragmentOp3ATI"))
			&& (glDeleteFragmentShaderATI = (PFNGLDELETEFRAGMENTSHADERATIPROC)get_proc("glDeleteFragmentShaderATI"))
			&& (glEndFragmentShaderATI = (PFNGLENDFRAGMENTSHADERATIPROC)get_proc("glEndFragmentShaderATI"))
			&& (glGenFragmentShadersATI = (PFNGLGENFRAGMENTSHADERSATIPROC)get_proc("glGenFragmentShadersATI"))
			&& (glPassTexCoordATI = (PFNGLPASSTEXCOORDATIPROC)get_proc("glPassTexCoordATI"))
			&& (glSampleMapATI = (PFNGLSAMPLEMAPATIPROC)get_proc("glSampleMapATI"))
			&& (glSetFragmentShaderConstantATI = (PFNGLSETFRAGMENTSHADERCONSTANTATIPROC)get_proc("glSetFragmentShaderConstantATI"))
			;
	}

	//  ...for GL_ATI_map_object_buffer:
	else if (extension == "GL_ATI_map_object_buffer") {
		loaded = true
			&& (glMapObjectBufferATI = (PFNGLMAPOBJECTBUFFERATIPROC)get_proc("glMapObjectBufferATI"))
			&& (glUnmapObjectBufferATI = (PFNGLUNMAPOBJECTBUFFERATIPROC)get_proc("glUnmapObjectBufferATI"))
			;
	}

	//  ...for GL_ATI_pn_triangles:
	else if (extension == "GL_ATI_pn_triangles") {
		loaded = true
			&& (glPNTrianglesfATI = (PFNGLPNTRIANGLESFATIPROC)get_proc("glPNTrianglesfATI"))
			&& (glPNTrianglesiATI = (PFNGLPNTRIANGLESIATIPROC)get_proc("glPNTrianglesiATI"))
			;
	}

	//  ...for GL_ATI_separate_stencil:
	else if (extension == "GL_ATI_separate_stencil") {
		loaded = true
			&& (glStencilFuncSeparateATI = (PFNGLSTENCILFUNCSEPARATEATIPROC)get_proc("glStencilFuncSeparateATI"))
			&& (glStencilOpSeparateATI = (PFNGLSTENCILOPSEPARATEATIPROC)get_proc("glStencilOpSeparateATI"))
			;
	}

	//  ...for GL_ATI_vertex_array_object:
	else if (extension == "GL_ATI_vertex_array_object") {
		loaded = true
			&& (glArrayObjectATI = (PFNGLARRAYOBJECTATIPROC)get_proc("glArrayObjectATI"))
			&& (glFreeObjectBufferATI = (PFNGLFREEOBJECTBUFFERATIPROC)get_proc("glFreeObjectBufferATI"))
			&& (glGetArrayObjectfvATI = (PFNGLGETARRAYOBJECTFVATIPROC)get_proc("glGetArrayObjectfvATI"))
			&& (glGetArrayObjectivATI = (PFNGLGETARRAYOBJECTIVATIPROC)get_proc("glGetArrayObjectivATI"))
			&& (glGetObjectBufferfvATI = (PFNGLGETOBJECTBUFFERFVATIPROC)get_proc("glGetObjectBufferfvATI"))
			&& (glGetObjectBufferivATI = (PFNGLGETOBJECTBUFFERIVATIPROC)get_proc("glGetObjectBufferivATI"))
			&& (glGetVariantArrayObjectfvATI = (PFNGLGETVARIANTARRAYOBJECTFVATIPROC)get_proc("glGetVariantArrayObjectfvATI"))
			&& (glGetVariantArrayObjectivATI = (PFNGLGETVARIANTARRAYOBJECTIVATIPROC)get_proc("glGetVariantArrayObjectivATI"))
			&& (glIsObjectBufferATI = (PFNGLISOBJECTBUFFERATIPROC)get_proc("glIsObjectBufferATI"))
			&& (glNewObjectBufferATI = (PFNGLNEWOBJECTBUFFERATIPROC)get_proc("glNewObjectBufferATI"))
			&& (glUpdateObjectBufferATI = (PFNGLUPDATEOBJECTBUFFERATIPROC)get_proc("glUpdateObjectBufferATI"))
			&& (glVariantArrayObjectATI = (PFNGLVARIANTARRAYOBJECTATIPROC)get_proc("glVariantArrayObjectATI"))
			;
	}

	//  ...for GL_ATI_vertex_attrib_array_object:
	else if (extension == "GL_ATI_vertex_attrib_array_object") {
		loaded = true
			&& (glGetVertexAttribArrayObjectfvATI = (PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC)get_proc("glGetVertexAttribArrayObjectfvATI"))
			&& (glGetVertexAttribArrayObjectivATI = (PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC)get_proc("glGetVertexAttribArrayObjectivATI"))
			&& (glVertexAttribArrayObjectATI = (PFNGLVERTEXATTRIBARRAYOBJECTATIPROC)get_proc("glVertexAttribArrayObjectATI"))
			;
	}

	//  ...for GL_ATI_vertex_streams:
	else if (extension == "GL_ATI_vertex_streams") {
		loaded = true
			&& (glClientActiveVertexStreamATI = (PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC)get_proc("glClientActiveVertexStreamATI"))
			&& (glNormalStream3bATI = (PFNGLNORMALSTREAM3BATIPROC)get_proc("glNormalStream3bATI"))
			&& (glNormalStream3bvATI = (PFNGLNORMALSTREAM3BVATIPROC)get_proc("glNormalStream3bvATI"))
			&& (glNormalStream3dATI = (PFNGLNORMALSTREAM3DATIPROC)get_proc("glNormalStream3dATI"))
			&& (glNormalStream3dvATI = (PFNGLNORMALSTREAM3DVATIPROC)get_proc("glNormalStream3dvATI"))
			&& (glNormalStream3fATI = (PFNGLNORMALSTREAM3FATIPROC)get_proc("glNormalStream3fATI"))
			&& (glNormalStream3fvATI = (PFNGLNORMALSTREAM3FVATIPROC)get_proc("glNormalStream3fvATI"))
			&& (glNormalStream3iATI = (PFNGLNORMALSTREAM3IATIPROC)get_proc("glNormalStream3iATI"))
			&& (glNormalStream3ivATI = (PFNGLNORMALSTREAM3IVATIPROC)get_proc("glNormalStream3ivATI"))
			&& (glNormalStream3sATI = (PFNGLNORMALSTREAM3SATIPROC)get_proc("glNormalStream3sATI"))
			&& (glNormalStream3svATI = (PFNGLNORMALSTREAM3SVATIPROC)get_proc("glNormalStream3svATI"))
			&& (glVertexBlendEnvfATI = (PFNGLVERTEXBLENDENVFATIPROC)get_proc("glVertexBlendEnvfATI"))
			&& (glVertexBlendEnviATI = (PFNGLVERTEXBLENDENVIATIPROC)get_proc("glVertexBlendEnviATI"))
			&& (glVertexStream1dATI = (PFNGLVERTEXSTREAM1DATIPROC)get_proc("glVertexStream1dATI"))
			&& (glVertexStream1dvATI = (PFNGLVERTEXSTREAM1DVATIPROC)get_proc("glVertexStream1dvATI"))
			&& (glVertexStream1fATI = (PFNGLVERTEXSTREAM1FATIPROC)get_proc("glVertexStream1fATI"))
			&& (glVertexStream1fvATI = (PFNGLVERTEXSTREAM1FVATIPROC)get_proc("glVertexStream1fvATI"))
			&& (glVertexStream1iATI = (PFNGLVERTEXSTREAM1IATIPROC)get_proc("glVertexStream1iATI"))
			&& (glVertexStream1ivATI = (PFNGLVERTEXSTREAM1IVATIPROC)get_proc("glVertexStream1ivATI"))
			&& (glVertexStream1sATI = (PFNGLVERTEXSTREAM1SATIPROC)get_proc("glVertexStream1sATI"))
			&& (glVertexStream1svATI = (PFNGLVERTEXSTREAM1SVATIPROC)get_proc("glVertexStream1svATI"))
			&& (glVertexStream2dATI = (PFNGLVERTEXSTREAM2DATIPROC)get_proc("glVertexStream2dATI"))
			&& (glVertexStream2dvATI = (PFNGLVERTEXSTREAM2DVATIPROC)get_proc("glVertexStream2dvATI"))
			&& (glVertexStream2fATI = (PFNGLVERTEXSTREAM2FATIPROC)get_proc("glVertexStream2fATI"))
			&& (glVertexStream2fvATI = (PFNGLVERTEXSTREAM2FVATIPROC)get_proc("glVertexStream2fvATI"))
			&& (glVertexStream2iATI = (PFNGLVERTEXSTREAM2IATIPROC)get_proc("glVertexStream2iATI"))
			&& (glVertexStream2ivATI = (PFNGLVERTEXSTREAM2IVATIPROC)get_proc("glVertexStream2ivATI"))
			&& (glVertexStream2sATI = (PFNGLVERTEXSTREAM2SATIPROC)get_proc("glVertexStream2sATI"))
			&& (glVertexStream2svATI = (PFNGLVERTEXSTREAM2SVATIPROC)get_proc("glVertexStream2svATI"))
			&& (glVertexStream3dATI = (PFNGLVERTEXSTREAM3DATIPROC)get_proc("glVertexStream3dATI"))
			&& (glVertexStream3dvATI = (PFNGLVERTEXSTREAM3DVATIPROC)get_proc("glVertexStream3dvATI"))
			&& (glVertexStream3fATI = (PFNGLVERTEXSTREAM3FATIPROC)get_proc("glVertexStream3fATI"))
			&& (glVertexStream3fvATI = (PFNGLVERTEXSTREAM3FVATIPROC)get_proc("glVertexStream3fvATI"))
			&& (glVertexStream3iATI = (PFNGLVERTEXSTREAM3IATIPROC)get_proc("glVertexStream3iATI"))
			&& (glVertexStream3ivATI = (PFNGLVERTEXSTREAM3IVATIPROC)get_proc("glVertexStream3ivATI"))
			&& (glVertexStream3sATI = (PFNGLVERTEXSTREAM3SATIPROC)get_proc("glVertexStream3sATI"))
			&& (glVertexStream3svATI = (PFNGLVERTEXSTREAM3SVATIPROC)get_proc("glVertexStream3svATI"))
			&& (glVertexStream4dATI = (PFNGLVERTEXSTREAM4DATIPROC)get_proc("glVertexStream4dATI"))
			&& (glVertexStream4dvATI = (PFNGLVERTEXSTREAM4DVATIPROC)get_proc("glVertexStream4dvATI"))
			&& (glVertexStream4fATI = (PFNGLVERTEXSTREAM4FATIPROC)get_proc("glVertexStream4fATI"))
			&& (glVertexStream4fvATI = (PFNGLVERTEXSTREAM4FVATIPROC)get_proc("glVertexStream4fvATI"))
			&& (glVertexStream4iATI = (PFNGLVERTEXSTREAM4IATIPROC)get_proc("glVertexStream4iATI"))
			&& (glVertexStream4ivATI = (PFNGLVERTEXSTREAM4IVATIPROC)get_proc("glVertexStream4ivATI"))
			&& (glVertexStream4sATI = (PFNGLVERTEXSTREAM4SATIPROC)get_proc("glVertexStream4sATI"))
			&& (glVertexStream4svATI = (PFNGLVERTEXSTREAM4SVATIPROC)get_proc("glVertexStream4svATI"))
			;
	}

	//  ...for GL_EXT_blend_color:
	else if (extension == "GL_EXT_blend_color") {
		loaded = true
			&& (glBlendColorEXT = (PFNGLBLENDCOLOREXTPROC)get_proc("glBlendColorEXT"))
			;
	}

	//  ...for GL_EXT_blend_equation_separate:
	else if (extension == "GL_EXT_blend_equation_separate") {
		loaded = true
			&& (glBlendEquationSeparateEXT = (PFNGLBLENDEQUATIONSEPARATEEXTPROC)get_proc("glBlendEquationSeparateEXT"))
			;
	}

	//  ...for GL_EXT_blend_func_separate:
	else if (extension == "GL_EXT_blend_func_separate") {
		loaded = true
			&& (glBlendFuncSeparateEXT = (PFNGLBLENDFUNCSEPARATEEXTPROC)get_proc("glBlendFuncSeparateEXT"))
			;
	}

	//  ...for GL_EXT_blend_minmax:
	else if (extension == "GL_EXT_blend_minmax") {
		loaded = true
			&& (glBlendEquationEXT = (PFNGLBLENDEQUATIONEXTPROC)get_proc("glBlendEquationEXT"))
			;
	}

	//  ...for GL_EXT_color_subtable:
	else if (extension == "GL_EXT_color_subtable") {
		loaded = true
			&& (glColorSubTableEXT = (PFNGLCOLORSUBTABLEEXTPROC)get_proc("glColorSubTableEXT"))
			&& (glCopyColorSubTableEXT = (PFNGLCOPYCOLORSUBTABLEEXTPROC)get_proc("glCopyColorSubTableEXT"))
			;
	}

	//  ...for GL_EXT_compiled_vertex_array:
	else if (extension == "GL_EXT_compiled_vertex_array") {
		loaded = true
			&& (glLockArraysEXT = (PFNGLLOCKARRAYSEXTPROC)get_proc("glLockArraysEXT"))
			&& (glUnlockArraysEXT = (PFNGLUNLOCKARRAYSEXTPROC)get_proc("glUnlockArraysEXT"))
			;
	}

	//  ...for GL_EXT_convolution:
	else if (extension == "GL_EXT_convolution") {
		loaded = true
			&& (glConvolutionFilter1DEXT = (PFNGLCONVOLUTIONFILTER1DEXTPROC)get_proc("glConvolutionFilter1DEXT"))
			&& (glConvolutionFilter2DEXT = (PFNGLCONVOLUTIONFILTER2DEXTPROC)get_proc("glConvolutionFilter2DEXT"))
			&& (glConvolutionParameterfEXT = (PFNGLCONVOLUTIONPARAMETERFEXTPROC)get_proc("glConvolutionParameterfEXT"))
			&& (glConvolutionParameterfvEXT = (PFNGLCONVOLUTIONPARAMETERFVEXTPROC)get_proc("glConvolutionParameterfvEXT"))
			&& (glConvolutionParameteriEXT = (PFNGLCONVOLUTIONPARAMETERIEXTPROC)get_proc("glConvolutionParameteriEXT"))
			&& (glConvolutionParameterivEXT = (PFNGLCONVOLUTIONPARAMETERIVEXTPROC)get_proc("glConvolutionParameterivEXT"))
			&& (glCopyConvolutionFilter1DEXT = (PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC)get_proc("glCopyConvolutionFilter1DEXT"))
			&& (glCopyConvolutionFilter2DEXT = (PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC)get_proc("glCopyConvolutionFilter2DEXT"))
			&& (glGetConvolutionFilterEXT = (PFNGLGETCONVOLUTIONFILTEREXTPROC)get_proc("glGetConvolutionFilterEXT"))
			&& (glGetConvolutionParameterfvEXT = (PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC)get_proc("glGetConvolutionParameterfvEXT"))
			&& (glGetConvolutionParameterivEXT = (PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC)get_proc("glGetConvolutionParameterivEXT"))
			&& (glGetSeparableFilterEXT = (PFNGLGETSEPARABLEFILTEREXTPROC)get_proc("glGetSeparableFilterEXT"))
			&& (glSeparableFilter2DEXT = (PFNGLSEPARABLEFILTER2DEXTPROC)get_proc("glSeparableFilter2DEXT"))
			;
	}

	//  ...for GL_EXT_coordinate_frame:
	else if (extension == "GL_EXT_coordinate_frame") {
		loaded = true
			&& (glBinormal3bEXT = (PFNGLBINORMAL3BEXTPROC)get_proc("glBinormal3bEXT"))
			&& (glBinormal3bvEXT = (PFNGLBINORMAL3BVEXTPROC)get_proc("glBinormal3bvEXT"))
			&& (glBinormal3dEXT = (PFNGLBINORMAL3DEXTPROC)get_proc("glBinormal3dEXT"))
			&& (glBinormal3dvEXT = (PFNGLBINORMAL3DVEXTPROC)get_proc("glBinormal3dvEXT"))
			&& (glBinormal3fEXT = (PFNGLBINORMAL3FEXTPROC)get_proc("glBinormal3fEXT"))
			&& (glBinormal3fvEXT = (PFNGLBINORMAL3FVEXTPROC)get_proc("glBinormal3fvEXT"))
			&& (glBinormal3iEXT = (PFNGLBINORMAL3IEXTPROC)get_proc("glBinormal3iEXT"))
			&& (glBinormal3ivEXT = (PFNGLBINORMAL3IVEXTPROC)get_proc("glBinormal3ivEXT"))
			&& (glBinormal3sEXT = (PFNGLBINORMAL3SEXTPROC)get_proc("glBinormal3sEXT"))
			&& (glBinormal3svEXT = (PFNGLBINORMAL3SVEXTPROC)get_proc("glBinormal3svEXT"))
			&& (glBinormalPointerEXT = (PFNGLBINORMALPOINTEREXTPROC)get_proc("glBinormalPointerEXT"))
			&& (glTangent3bEXT = (PFNGLTANGENT3BEXTPROC)get_proc("glTangent3bEXT"))
			&& (glTangent3bvEXT = (PFNGLTANGENT3BVEXTPROC)get_proc("glTangent3bvEXT"))
			&& (glTangent3dEXT = (PFNGLTANGENT3DEXTPROC)get_proc("glTangent3dEXT"))
			&& (glTangent3dvEXT = (PFNGLTANGENT3DVEXTPROC)get_proc("glTangent3dvEXT"))
			&& (glTangent3fEXT = (PFNGLTANGENT3FEXTPROC)get_proc("glTangent3fEXT"))
			&& (glTangent3fvEXT = (PFNGLTANGENT3FVEXTPROC)get_proc("glTangent3fvEXT"))
			&& (glTangent3iEXT = (PFNGLTANGENT3IEXTPROC)get_proc("glTangent3iEXT"))
			&& (glTangent3ivEXT = (PFNGLTANGENT3IVEXTPROC)get_proc("glTangent3ivEXT"))
			&& (glTangent3sEXT = (PFNGLTANGENT3SEXTPROC)get_proc("glTangent3sEXT"))
			&& (glTangent3svEXT = (PFNGLTANGENT3SVEXTPROC)get_proc("glTangent3svEXT"))
			&& (glTangentPointerEXT = (PFNGLTANGENTPOINTEREXTPROC)get_proc("glTangentPointerEXT"))
			;
	}

	//  ...for GL_EXT_copy_texture:
	else if (extension == "GL_EXT_copy_texture") {
		loaded = true
			&& (glCopyTexImage1DEXT = (PFNGLCOPYTEXIMAGE1DEXTPROC)get_proc("glCopyTexImage1DEXT"))
			&& (glCopyTexImage2DEXT = (PFNGLCOPYTEXIMAGE2DEXTPROC)get_proc("glCopyTexImage2DEXT"))
			&& (glCopyTexSubImage1DEXT = (PFNGLCOPYTEXSUBIMAGE1DEXTPROC)get_proc("glCopyTexSubImage1DEXT"))
			&& (glCopyTexSubImage2DEXT = (PFNGLCOPYTEXSUBIMAGE2DEXTPROC)get_proc("glCopyTexSubImage2DEXT"))
			&& (glCopyTexSubImage3DEXT = (PFNGLCOPYTEXSUBIMAGE3DEXTPROC)get_proc("glCopyTexSubImage3DEXT"))
			;
	}

	//  ...for GL_EXT_cull_vertex:
	else if (extension == "GL_EXT_cull_vertex") {
		loaded = true
			&& (glCullParameterdvEXT = (PFNGLCULLPARAMETERDVEXTPROC)get_proc("glCullParameterdvEXT"))
			&& (glCullParameterfvEXT = (PFNGLCULLPARAMETERFVEXTPROC)get_proc("glCullParameterfvEXT"))
			;
	}

	//  ...for GL_EXT_depth_bounds_test:
	else if (extension == "GL_EXT_depth_bounds_test") {
		loaded = true
			&& (glDepthBoundsEXT = (PFNGLDEPTHBOUNDSEXTPROC)get_proc("glDepthBoundsEXT"))
			;
	}

	//  ...for GL_EXT_draw_range_elements:
	else if (extension == "GL_EXT_draw_range_elements") {
		loaded = true
			&& (glDrawRangeElementsEXT = (PFNGLDRAWRANGEELEMENTSEXTPROC)get_proc("glDrawRangeElementsEXT"))
			;
	}

	//  ...for GL_EXT_fog_coord:
	else if (extension == "GL_EXT_fog_coord") {
		loaded = true
			&& (glFogCoorddEXT = (PFNGLFOGCOORDDEXTPROC)get_proc("glFogCoorddEXT"))
			&& (glFogCoorddvEXT = (PFNGLFOGCOORDDVEXTPROC)get_proc("glFogCoorddvEXT"))
			&& (glFogCoordfEXT = (PFNGLFOGCOORDFEXTPROC)get_proc("glFogCoordfEXT"))
			&& (glFogCoordfvEXT = (PFNGLFOGCOORDFVEXTPROC)get_proc("glFogCoordfvEXT"))
			&& (glFogCoordPointerEXT = (PFNGLFOGCOORDPOINTEREXTPROC)get_proc("glFogCoordPointerEXT"))
			;
	}

	//  ...for GL_EXT_framebuffer_object:
	else if (extension == "GL_EXT_framebuffer_object") {
		loaded = true
			&& (glBindFramebufferEXT = (PFNGLBINDFRAMEBUFFEREXTPROC)get_proc("glBindFramebufferEXT"))
			&& (glBindRenderbufferEXT = (PFNGLBINDRENDERBUFFEREXTPROC)get_proc("glBindRenderbufferEXT"))
			&& (glCheckFramebufferStatusEXT = (PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC)get_proc("glCheckFramebufferStatusEXT"))
			&& (glDeleteFramebuffersEXT = (PFNGLDELETEFRAMEBUFFERSEXTPROC)get_proc("glDeleteFramebuffersEXT"))
			&& (glDeleteRenderbuffersEXT = (PFNGLDELETERENDERBUFFERSEXTPROC)get_proc("glDeleteRenderbuffersEXT"))
			&& (glFramebufferRenderbufferEXT = (PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC)get_proc("glFramebufferRenderbufferEXT"))
			&& (glFramebufferTexture1DEXT = (PFNGLFRAMEBUFFERTEXTURE1DEXTPROC)get_proc("glFramebufferTexture1DEXT"))
			&& (glFramebufferTexture2DEXT = (PFNGLFRAMEBUFFERTEXTURE2DEXTPROC)get_proc("glFramebufferTexture2DEXT"))
			&& (glFramebufferTexture3DEXT = (PFNGLFRAMEBUFFERTEXTURE3DEXTPROC)get_proc("glFramebufferTexture3DEXT"))
			&& (glGenerateMipmapEXT = (PFNGLGENERATEMIPMAPEXTPROC)get_proc("glGenerateMipmapEXT"))
			&& (glGenFramebuffersEXT = (PFNGLGENFRAMEBUFFERSEXTPROC)get_proc("glGenFramebuffersEXT"))
			&& (glGenRenderbuffersEXT = (PFNGLGENRENDERBUFFERSEXTPROC)get_proc("glGenRenderbuffersEXT"))
			&& (glGetFramebufferAttachmentParameterivEXT = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC)get_proc("glGetFramebufferAttachmentParameterivEXT"))
			&& (glGetRenderbufferParameterivEXT = (PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC)get_proc("glGetRenderbufferParameterivEXT"))
			&& (glIsFramebufferEXT = (PFNGLISFRAMEBUFFEREXTPROC)get_proc("glIsFramebufferEXT"))
			&& (glIsRenderbufferEXT = (PFNGLISRENDERBUFFEREXTPROC)get_proc("glIsRenderbufferEXT"))
			&& (glRenderbufferStorageEXT = (PFNGLRENDERBUFFERSTORAGEEXTPROC)get_proc("glRenderbufferStorageEXT"))
			;
	}

	//  ...for GL_EXT_histogram:
	else if (extension == "GL_EXT_histogram") {
		loaded = true
			&& (glGetHistogramEXT = (PFNGLGETHISTOGRAMEXTPROC)get_proc("glGetHistogramEXT"))
			&& (glGetHistogramParameterfvEXT = (PFNGLGETHISTOGRAMPARAMETERFVEXTPROC)get_proc("glGetHistogramParameterfvEXT"))
			&& (glGetHistogramParameterivEXT = (PFNGLGETHISTOGRAMPARAMETERIVEXTPROC)get_proc("glGetHistogramParameterivEXT"))
			&& (glGetMinmaxEXT = (PFNGLGETMINMAXEXTPROC)get_proc("glGetMinmaxEXT"))
			&& (glGetMinmaxParameterfvEXT = (PFNGLGETMINMAXPARAMETERFVEXTPROC)get_proc("glGetMinmaxParameterfvEXT"))
			&& (glGetMinmaxParameterivEXT = (PFNGLGETMINMAXPARAMETERIVEXTPROC)get_proc("glGetMinmaxParameterivEXT"))
			&& (glHistogramEXT = (PFNGLHISTOGRAMEXTPROC)get_proc("glHistogramEXT"))
			&& (glMinmaxEXT = (PFNGLMINMAXEXTPROC)get_proc("glMinmaxEXT"))
			&& (glResetHistogramEXT = (PFNGLRESETHISTOGRAMEXTPROC)get_proc("glResetHistogramEXT"))
			&& (glResetMinmaxEXT = (PFNGLRESETMINMAXEXTPROC)get_proc("glResetMinmaxEXT"))
			;
	}

	//  ...for GL_EXT_index_func:
	else if (extension == "GL_EXT_index_func") {
		loaded = true
			&& (glIndexFuncEXT = (PFNGLINDEXFUNCEXTPROC)get_proc("glIndexFuncEXT"))
			;
	}

	//  ...for GL_EXT_index_material:
	else if (extension == "GL_EXT_index_material") {
		loaded = true
			&& (glIndexMaterialEXT = (PFNGLINDEXMATERIALEXTPROC)get_proc("glIndexMaterialEXT"))
			;
	}

	//  ...for GL_EXT_light_texture:
	else if (extension == "GL_EXT_light_texture") {
		loaded = true
			&& (glApplyTextureEXT = (PFNGLAPPLYTEXTUREEXTPROC)get_proc("glApplyTextureEXT"))
			&& (glTextureLightEXT = (PFNGLTEXTURELIGHTEXTPROC)get_proc("glTextureLightEXT"))
			&& (glTextureMaterialEXT = (PFNGLTEXTUREMATERIALEXTPROC)get_proc("glTextureMaterialEXT"))
			;
	}

	//  ...for GL_EXT_multi_draw_arrays:
	else if (extension == "GL_EXT_multi_draw_arrays") {
		loaded = true
			&& (glMultiDrawArraysEXT = (PFNGLMULTIDRAWARRAYSEXTPROC)get_proc("glMultiDrawArraysEXT"))
			&& (glMultiDrawElementsEXT = (PFNGLMULTIDRAWELEMENTSEXTPROC)get_proc("glMultiDrawElementsEXT"))
			;
	}

	//  ...for GL_EXT_multisample:
	else if (extension == "GL_EXT_multisample") {
		loaded = true
			&& (glSampleMaskEXT = (PFNGLSAMPLEMASKEXTPROC)get_proc("glSampleMaskEXT"))
			&& (glSamplePatternEXT = (PFNGLSAMPLEPATTERNEXTPROC)get_proc("glSamplePatternEXT"))
			;
	}

	//  ...for GL_EXT_paletted_texture:
	else if (extension == "GL_EXT_paletted_texture") {
		loaded = true
			&& (glColorTableEXT = (PFNGLCOLORTABLEEXTPROC)get_proc("glColorTableEXT"))
			&& (glGetColorTableEXT = (PFNGLGETCOLORTABLEEXTPROC)get_proc("glGetColorTableEXT"))
			&& (glGetColorTableParameterfvEXT = (PFNGLGETCOLORTABLEPARAMETERFVEXTPROC)get_proc("glGetColorTableParameterfvEXT"))
			&& (glGetColorTableParameterivEXT = (PFNGLGETCOLORTABLEPARAMETERIVEXTPROC)get_proc("glGetColorTableParameterivEXT"))
			;
	}

	//  ...for GL_EXT_pixel_transform:
	else if (extension == "GL_EXT_pixel_transform") {
		loaded = true
			&& (glPixelTransformParameterfEXT = (PFNGLPIXELTRANSFORMPARAMETERFEXTPROC)get_proc("glPixelTransformParameterfEXT"))
			&& (glPixelTransformParameterfvEXT = (PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC)get_proc("glPixelTransformParameterfvEXT"))
			&& (glPixelTransformParameteriEXT = (PFNGLPIXELTRANSFORMPARAMETERIEXTPROC)get_proc("glPixelTransformParameteriEXT"))
			&& (glPixelTransformParameterivEXT = (PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC)get_proc("glPixelTransformParameterivEXT"))
			;
	}

	//  ...for GL_EXT_point_parameters:
	else if (extension == "GL_EXT_point_parameters") {
		loaded = true
			&& (glPointParameterfEXT = (PFNGLPOINTPARAMETERFEXTPROC)get_proc("glPointParameterfEXT"))
			&& (glPointParameterfvEXT = (PFNGLPOINTPARAMETERFVEXTPROC)get_proc("glPointParameterfvEXT"))
			;
	}

	//  ...for GL_EXT_polygon_offset:
	else if (extension == "GL_EXT_polygon_offset") {
		loaded = true
			&& (glPolygonOffsetEXT = (PFNGLPOLYGONOFFSETEXTPROC)get_proc("glPolygonOffsetEXT"))
			;
	}

	//  ...for GL_EXT_secondary_color:
	else if (extension == "GL_EXT_secondary_color") {
		loaded = true
			&& (glSecondaryColor3bEXT = (PFNGLSECONDARYCOLOR3BEXTPROC)get_proc("glSecondaryColor3bEXT"))
			&& (glSecondaryColor3bvEXT = (PFNGLSECONDARYCOLOR3BVEXTPROC)get_proc("glSecondaryColor3bvEXT"))
			&& (glSecondaryColor3dEXT = (PFNGLSECONDARYCOLOR3DEXTPROC)get_proc("glSecondaryColor3dEXT"))
			&& (glSecondaryColor3dvEXT = (PFNGLSECONDARYCOLOR3DVEXTPROC)get_proc("glSecondaryColor3dvEXT"))
			&& (glSecondaryColor3fEXT = (PFNGLSECONDARYCOLOR3FEXTPROC)get_proc("glSecondaryColor3fEXT"))
			&& (glSecondaryColor3fvEXT = (PFNGLSECONDARYCOLOR3FVEXTPROC)get_proc("glSecondaryColor3fvEXT"))
			&& (glSecondaryColor3iEXT = (PFNGLSECONDARYCOLOR3IEXTPROC)get_proc("glSecondaryColor3iEXT"))
			&& (glSecondaryColor3ivEXT = (PFNGLSECONDARYCOLOR3IVEXTPROC)get_proc("glSecondaryColor3ivEXT"))
			&& (glSecondaryColor3sEXT = (PFNGLSECONDARYCOLOR3SEXTPROC)get_proc("glSecondaryColor3sEXT"))
			&& (glSecondaryColor3svEXT = (PFNGLSECONDARYCOLOR3SVEXTPROC)get_proc("glSecondaryColor3svEXT"))
			&& (glSecondaryColor3ubEXT = (PFNGLSECONDARYCOLOR3UBEXTPROC)get_proc("glSecondaryColor3ubEXT"))
			&& (glSecondaryColor3ubvEXT = (PFNGLSECONDARYCOLOR3UBVEXTPROC)get_proc("glSecondaryColor3ubvEXT"))
			&& (glSecondaryColor3uiEXT = (PFNGLSECONDARYCOLOR3UIEXTPROC)get_proc("glSecondaryColor3uiEXT"))
			&& (glSecondaryColor3uivEXT = (PFNGLSECONDARYCOLOR3UIVEXTPROC)get_proc("glSecondaryColor3uivEXT"))
			&& (glSecondaryColor3usEXT = (PFNGLSECONDARYCOLOR3USEXTPROC)get_proc("glSecondaryColor3usEXT"))
			&& (glSecondaryColor3usvEXT = (PFNGLSECONDARYCOLOR3USVEXTPROC)get_proc("glSecondaryColor3usvEXT"))
			&& (glSecondaryColorPointerEXT = (PFNGLSECONDARYCOLORPOINTEREXTPROC)get_proc("glSecondaryColorPointerEXT"))
			;
	}

	//  ...for GL_EXT_stencil_two_side:
	else if (extension == "GL_EXT_stencil_two_side") {
		loaded = true
			&& (glActiveStencilFaceEXT = (PFNGLACTIVESTENCILFACEEXTPROC)get_proc("glActiveStencilFaceEXT"))
			;
	}

	//  ...for GL_EXT_subtexture:
	else if (extension == "GL_EXT_subtexture") {
		loaded = true
			&& (glTexSubImage1DEXT = (PFNGLTEXSUBIMAGE1DEXTPROC)get_proc("glTexSubImage1DEXT"))
			&& (glTexSubImage2DEXT = (PFNGLTEXSUBIMAGE2DEXTPROC)get_proc("glTexSubImage2DEXT"))
			;
	}

	//  ...for GL_EXT_texture:
	else if (extension == "GL_EXT_texture") {
		loaded = true
			&& (glTexImage3DEXT = (PFNGLTEXIMAGE3DEXTPROC)get_proc("glTexImage3DEXT"))
			&& (glTexSubImage3DEXT = (PFNGLTEXSUBIMAGE3DEXTPROC)get_proc("glTexSubImage3DEXT"))
			;
	}

	//  ...for GL_EXT_texture_object:
	else if (extension == "GL_EXT_texture_object") {
		loaded = true
			&& (glAreTexturesResidentEXT = (PFNGLARETEXTURESRESIDENTEXTPROC)get_proc("glAreTexturesResidentEXT"))
			&& (glBindTextureEXT = (PFNGLBINDTEXTUREEXTPROC)get_proc("glBindTextureEXT"))
			&& (glDeleteTexturesEXT = (PFNGLDELETETEXTURESEXTPROC)get_proc("glDeleteTexturesEXT"))
			&& (glGenTexturesEXT = (PFNGLGENTEXTURESEXTPROC)get_proc("glGenTexturesEXT"))
			&& (glIsTextureEXT = (PFNGLISTEXTUREEXTPROC)get_proc("glIsTextureEXT"))
			&& (glPrioritizeTexturesEXT = (PFNGLPRIORITIZETEXTURESEXTPROC)get_proc("glPrioritizeTexturesEXT"))
			;
	}

	//  ...for GL_EXT_texture_perturb_normal:
	else if (extension == "GL_EXT_texture_perturb_normal") {
		loaded = true
			&& (glTextureNormalEXT = (PFNGLTEXTURENORMALEXTPROC)get_proc("glTextureNormalEXT"))
			;
	}

	//  ...for GL_EXT_vertex_array:
	else if (extension == "GL_EXT_vertex_array") {
		loaded = true
			&& (glArrayElementEXT = (PFNGLARRAYELEMENTEXTPROC)get_proc("glArrayElementEXT"))
			&& (glColorPointerEXT = (PFNGLCOLORPOINTEREXTPROC)get_proc("glColorPointerEXT"))
			&& (glDrawArraysEXT = (PFNGLDRAWARRAYSEXTPROC)get_proc("glDrawArraysEXT"))
			&& (glEdgeFlagPointerEXT = (PFNGLEDGEFLAGPOINTEREXTPROC)get_proc("glEdgeFlagPointerEXT"))
			&& (glGetPointervEXT = (PFNGLGETPOINTERVEXTPROC)get_proc("glGetPointervEXT"))
			&& (glIndexPointerEXT = (PFNGLINDEXPOINTEREXTPROC)get_proc("glIndexPointerEXT"))
			&& (glNormalPointerEXT = (PFNGLNORMALPOINTEREXTPROC)get_proc("glNormalPointerEXT"))
			&& (glTexCoordPointerEXT = (PFNGLTEXCOORDPOINTEREXTPROC)get_proc("glTexCoordPointerEXT"))
			&& (glVertexPointerEXT = (PFNGLVERTEXPOINTEREXTPROC)get_proc("glVertexPointerEXT"))
			;
	}

	//  ...for GL_EXT_vertex_shader:
	else if (extension == "GL_EXT_vertex_shader") {
		loaded = true
			&& (glBeginVertexShaderEXT = (PFNGLBEGINVERTEXSHADEREXTPROC)get_proc("glBeginVertexShaderEXT"))
			&& (glBindLightParameterEXT = (PFNGLBINDLIGHTPARAMETEREXTPROC)get_proc("glBindLightParameterEXT"))
			&& (glBindMaterialParameterEXT = (PFNGLBINDMATERIALPARAMETEREXTPROC)get_proc("glBindMaterialParameterEXT"))
			&& (glBindParameterEXT = (PFNGLBINDPARAMETEREXTPROC)get_proc("glBindParameterEXT"))
			&& (glBindTexGenParameterEXT = (PFNGLBINDTEXGENPARAMETEREXTPROC)get_proc("glBindTexGenParameterEXT"))
			&& (glBindTextureUnitParameterEXT = (PFNGLBINDTEXTUREUNITPARAMETEREXTPROC)get_proc("glBindTextureUnitParameterEXT"))
			&& (glBindVertexShaderEXT = (PFNGLBINDVERTEXSHADEREXTPROC)get_proc("glBindVertexShaderEXT"))
			&& (glDeleteVertexShaderEXT = (PFNGLDELETEVERTEXSHADEREXTPROC)get_proc("glDeleteVertexShaderEXT"))
			&& (glDisableVariantClientStateEXT = (PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC)get_proc("glDisableVariantClientStateEXT"))
			&& (glEnableVariantClientStateEXT = (PFNGLENABLEVARIANTCLIENTSTATEEXTPROC)get_proc("glEnableVariantClientStateEXT"))
			&& (glEndVertexShaderEXT = (PFNGLENDVERTEXSHADEREXTPROC)get_proc("glEndVertexShaderEXT"))
			&& (glExtractComponentEXT = (PFNGLEXTRACTCOMPONENTEXTPROC)get_proc("glExtractComponentEXT"))
			&& (glGenSymbolsEXT = (PFNGLGENSYMBOLSEXTPROC)get_proc("glGenSymbolsEXT"))
			&& (glGenVertexShadersEXT = (PFNGLGENVERTEXSHADERSEXTPROC)get_proc("glGenVertexShadersEXT"))
			&& (glGetInvariantBooleanvEXT = (PFNGLGETINVARIANTBOOLEANVEXTPROC)get_proc("glGetInvariantBooleanvEXT"))
			&& (glGetInvariantFloatvEXT = (PFNGLGETINVARIANTFLOATVEXTPROC)get_proc("glGetInvariantFloatvEXT"))
			&& (glGetInvariantIntegervEXT = (PFNGLGETINVARIANTINTEGERVEXTPROC)get_proc("glGetInvariantIntegervEXT"))
			&& (glGetLocalConstantBooleanvEXT = (PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC)get_proc("glGetLocalConstantBooleanvEXT"))
			&& (glGetLocalConstantFloatvEXT = (PFNGLGETLOCALCONSTANTFLOATVEXTPROC)get_proc("glGetLocalConstantFloatvEXT"))
			&& (glGetLocalConstantIntegervEXT = (PFNGLGETLOCALCONSTANTINTEGERVEXTPROC)get_proc("glGetLocalConstantIntegervEXT"))
			&& (glGetVariantBooleanvEXT = (PFNGLGETVARIANTBOOLEANVEXTPROC)get_proc("glGetVariantBooleanvEXT"))
			&& (glGetVariantFloatvEXT = (PFNGLGETVARIANTFLOATVEXTPROC)get_proc("glGetVariantFloatvEXT"))
			&& (glGetVariantIntegervEXT = (PFNGLGETVARIANTINTEGERVEXTPROC)get_proc("glGetVariantIntegervEXT"))
			&& (glGetVariantPointervEXT = (PFNGLGETVARIANTPOINTERVEXTPROC)get_proc("glGetVariantPointervEXT"))
			&& (glInsertComponentEXT = (PFNGLINSERTCOMPONENTEXTPROC)get_proc("glInsertComponentEXT"))
			&& (glIsVariantEnabledEXT = (PFNGLISVARIANTENABLEDEXTPROC)get_proc("glIsVariantEnabledEXT"))
			&& (glSetInvariantEXT = (PFNGLSETINVARIANTEXTPROC)get_proc("glSetInvariantEXT"))
			&& (glSetLocalConstantEXT = (PFNGLSETLOCALCONSTANTEXTPROC)get_proc("glSetLocalConstantEXT"))
			&& (glShaderOp1EXT = (PFNGLSHADEROP1EXTPROC)get_proc("glShaderOp1EXT"))
			&& (glShaderOp2EXT = (PFNGLSHADEROP2EXTPROC)get_proc("glShaderOp2EXT"))
			&& (glShaderOp3EXT = (PFNGLSHADEROP3EXTPROC)get_proc("glShaderOp3EXT"))
			&& (glSwizzleEXT = (PFNGLSWIZZLEEXTPROC)get_proc("glSwizzleEXT"))
			&& (glVariantbvEXT = (PFNGLVARIANTBVEXTPROC)get_proc("glVariantbvEXT"))
			&& (glVariantdvEXT = (PFNGLVARIANTDVEXTPROC)get_proc("glVariantdvEXT"))
			&& (glVariantfvEXT = (PFNGLVARIANTFVEXTPROC)get_proc("glVariantfvEXT"))
			&& (glVariantivEXT = (PFNGLVARIANTIVEXTPROC)get_proc("glVariantivEXT"))
			&& (glVariantPointerEXT = (PFNGLVARIANTPOINTEREXTPROC)get_proc("glVariantPointerEXT"))
			&& (glVariantsvEXT = (PFNGLVARIANTSVEXTPROC)get_proc("glVariantsvEXT"))
			&& (glVariantubvEXT = (PFNGLVARIANTUBVEXTPROC)get_proc("glVariantubvEXT"))
			&& (glVariantuivEXT = (PFNGLVARIANTUIVEXTPROC)get_proc("glVariantuivEXT"))
			&& (glVariantusvEXT = (PFNGLVARIANTUSVEXTPROC)get_proc("glVariantusvEXT"))
			&& (glWriteMaskEXT = (PFNGLWRITEMASKEXTPROC)get_proc("glWriteMaskEXT"))
			;
	}

	//  ...for GL_EXT_vertex_weighting:
	else if (extension == "GL_EXT_vertex_weighting") {
		loaded = true
			&& (glVertexWeightfEXT = (PFNGLVERTEXWEIGHTFEXTPROC)get_proc("glVertexWeightfEXT"))
			&& (glVertexWeightfvEXT = (PFNGLVERTEXWEIGHTFVEXTPROC)get_proc("glVertexWeightfvEXT"))
			&& (glVertexWeightPointerEXT = (PFNGLVERTEXWEIGHTPOINTEREXTPROC)get_proc("glVertexWeightPointerEXT"))
			;
	}

	//  ...for GL_GREMEDY_string_marker:
	else if (extension == "GL_GREMEDY_string_marker") {
		loaded = true
			&& (glStringMarkerGREMEDY = (PFNGLSTRINGMARKERGREMEDYPROC)get_proc("glStringMarkerGREMEDY"))
			;
	}

	//  ...for GL_HP_image_transform:
	else if (extension == "GL_HP_image_transform") {
		loaded = true
			&& (glGetImageTransformParameterfvHP = (PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC)get_proc("glGetImageTransformParameterfvHP"))
			&& (glGetImageTransformParameterivHP = (PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC)get_proc("glGetImageTransformParameterivHP"))
			&& (glImageTransformParameterfHP = (PFNGLIMAGETRANSFORMPARAMETERFHPPROC)get_proc("glImageTransformParameterfHP"))
			&& (glImageTransformParameterfvHP = (PFNGLIMAGETRANSFORMPARAMETERFVHPPROC)get_proc("glImageTransformParameterfvHP"))
			&& (glImageTransformParameteriHP = (PFNGLIMAGETRANSFORMPARAMETERIHPPROC)get_proc("glImageTransformParameteriHP"))
			&& (glImageTransformParameterivHP = (PFNGLIMAGETRANSFORMPARAMETERIVHPPROC)get_proc("glImageTransformParameterivHP"))
			;
	}

	//  ...for GL_IBM_multimode_draw_arrays:
	else if (extension == "GL_IBM_multimode_draw_arrays") {
		loaded = true
			&& (glMultiModeDrawArraysIBM = (PFNGLMULTIMODEDRAWARRAYSIBMPROC)get_proc("glMultiModeDrawArraysIBM"))
			&& (glMultiModeDrawElementsIBM = (PFNGLMULTIMODEDRAWELEMENTSIBMPROC)get_proc("glMultiModeDrawElementsIBM"))
			;
	}

	//  ...for GL_IBM_vertex_array_lists:
	else if (extension == "GL_IBM_vertex_array_lists") {
		loaded = true
			&& (glColorPointerListIBM = (PFNGLCOLORPOINTERLISTIBMPROC)get_proc("glColorPointerListIBM"))
			&& (glEdgeFlagPointerListIBM = (PFNGLEDGEFLAGPOINTERLISTIBMPROC)get_proc("glEdgeFlagPointerListIBM"))
			&& (glFogCoordPointerListIBM = (PFNGLFOGCOORDPOINTERLISTIBMPROC)get_proc("glFogCoordPointerListIBM"))
			&& (glIndexPointerListIBM = (PFNGLINDEXPOINTERLISTIBMPROC)get_proc("glIndexPointerListIBM"))
			&& (glNormalPointerListIBM = (PFNGLNORMALPOINTERLISTIBMPROC)get_proc("glNormalPointerListIBM"))
			&& (glSecondaryColorPointerListIBM = (PFNGLSECONDARYCOLORPOINTERLISTIBMPROC)get_proc("glSecondaryColorPointerListIBM"))
			&& (glTexCoordPointerListIBM = (PFNGLTEXCOORDPOINTERLISTIBMPROC)get_proc("glTexCoordPointerListIBM"))
			&& (glVertexPointerListIBM = (PFNGLVERTEXPOINTERLISTIBMPROC)get_proc("glVertexPointerListIBM"))
			;
	}

	//  ...for GL_INGR_blend_func_separate:
	else if (extension == "GL_INGR_blend_func_separate") {
		loaded = true
			&& (glBlendFuncSeparateINGR = (PFNGLBLENDFUNCSEPARATEINGRPROC)get_proc("glBlendFuncSeparateINGR"))
			;
	}

	//  ...for GL_INTEL_parallel_arrays:
	else if (extension == "GL_INTEL_parallel_arrays") {
		loaded = true
			&& (glColorPointervINTEL = (PFNGLCOLORPOINTERVINTELPROC)get_proc("glColorPointervINTEL"))
			&& (glNormalPointervINTEL = (PFNGLNORMALPOINTERVINTELPROC)get_proc("glNormalPointervINTEL"))
			&& (glTexCoordPointervINTEL = (PFNGLTEXCOORDPOINTERVINTELPROC)get_proc("glTexCoordPointervINTEL"))
			&& (glVertexPointervINTEL = (PFNGLVERTEXPOINTERVINTELPROC)get_proc("glVertexPointervINTEL"))
			;
	}

	//  ...for GL_MESA_resize_buffers:
	else if (extension == "GL_MESA_resize_buffers") {
		loaded = true
			&& (glResizeBuffersMESA = (PFNGLRESIZEBUFFERSMESAPROC)get_proc("glResizeBuffersMESA"))
			;
	}

	//  ...for GL_MESA_window_pos:
	else if (extension == "GL_MESA_window_pos") {
		loaded = true
			&& (glWindowPos2dMESA = (PFNGLWINDOWPOS2DMESAPROC)get_proc("glWindowPos2dMESA"))
			&& (glWindowPos2dvMESA = (PFNGLWINDOWPOS2DVMESAPROC)get_proc("glWindowPos2dvMESA"))
			&& (glWindowPos2fMESA = (PFNGLWINDOWPOS2FMESAPROC)get_proc("glWindowPos2fMESA"))
			&& (glWindowPos2fvMESA = (PFNGLWINDOWPOS2FVMESAPROC)get_proc("glWindowPos2fvMESA"))
			&& (glWindowPos2iMESA = (PFNGLWINDOWPOS2IMESAPROC)get_proc("glWindowPos2iMESA"))
			&& (glWindowPos2ivMESA = (PFNGLWINDOWPOS2IVMESAPROC)get_proc("glWindowPos2ivMESA"))
			&& (glWindowPos2sMESA = (PFNGLWINDOWPOS2SMESAPROC)get_proc("glWindowPos2sMESA"))
			&& (glWindowPos2svMESA = (PFNGLWINDOWPOS2SVMESAPROC)get_proc("glWindowPos2svMESA"))
			&& (glWindowPos3dMESA = (PFNGLWINDOWPOS3DMESAPROC)get_proc("glWindowPos3dMESA"))
			&& (glWindowPos3dvMESA = (PFNGLWINDOWPOS3DVMESAPROC)get_proc("glWindowPos3dvMESA"))
			&& (glWindowPos3fMESA = (PFNGLWINDOWPOS3FMESAPROC)get_proc("glWindowPos3fMESA"))
			&& (glWindowPos3fvMESA = (PFNGLWINDOWPOS3FVMESAPROC)get_proc("glWindowPos3fvMESA"))
			&& (glWindowPos3iMESA = (PFNGLWINDOWPOS3IMESAPROC)get_proc("glWindowPos3iMESA"))
			&& (glWindowPos3ivMESA = (PFNGLWINDOWPOS3IVMESAPROC)get_proc("glWindowPos3ivMESA"))
			&& (glWindowPos3sMESA = (PFNGLWINDOWPOS3SMESAPROC)get_proc("glWindowPos3sMESA"))
			&& (glWindowPos3svMESA = (PFNGLWINDOWPOS3SVMESAPROC)get_proc("glWindowPos3svMESA"))
			&& (glWindowPos4dMESA = (PFNGLWINDOWPOS4DMESAPROC)get_proc("glWindowPos4dMESA"))
			&& (glWindowPos4dvMESA = (PFNGLWINDOWPOS4DVMESAPROC)get_proc("glWindowPos4dvMESA"))
			&& (glWindowPos4fMESA = (PFNGLWINDOWPOS4FMESAPROC)get_proc("glWindowPos4fMESA"))
			&& (glWindowPos4fvMESA = (PFNGLWINDOWPOS4FVMESAPROC)get_proc("glWindowPos4fvMESA"))
			&& (glWindowPos4iMESA = (PFNGLWINDOWPOS4IMESAPROC)get_proc("glWindowPos4iMESA"))
			&& (glWindowPos4ivMESA = (PFNGLWINDOWPOS4IVMESAPROC)get_proc("glWindowPos4ivMESA"))
			&& (glWindowPos4sMESA = (PFNGLWINDOWPOS4SMESAPROC)get_proc("glWindowPos4sMESA"))
			&& (glWindowPos4svMESA = (PFNGLWINDOWPOS4SVMESAPROC)get_proc("glWindowPos4svMESA"))
			;
	}

	//  ...for GL_NV_evaluators:
	else if (extension == "GL_NV_evaluators") {
		loaded = true
			&& (glEvalMapsNV = (PFNGLEVALMAPSNVPROC)get_proc("glEvalMapsNV"))
			&& (glGetMapAttribParameterfvNV = (PFNGLGETMAPATTRIBPARAMETERFVNVPROC)get_proc("glGetMapAttribParameterfvNV"))
			&& (glGetMapAttribParameterivNV = (PFNGLGETMAPATTRIBPARAMETERIVNVPROC)get_proc("glGetMapAttribParameterivNV"))
			&& (glGetMapControlPointsNV = (PFNGLGETMAPCONTROLPOINTSNVPROC)get_proc("glGetMapControlPointsNV"))
			&& (glGetMapParameterfvNV = (PFNGLGETMAPPARAMETERFVNVPROC)get_proc("glGetMapParameterfvNV"))
			&& (glGetMapParameterivNV = (PFNGLGETMAPPARAMETERIVNVPROC)get_proc("glGetMapParameterivNV"))
			&& (glMapControlPointsNV = (PFNGLMAPCONTROLPOINTSNVPROC)get_proc("glMapControlPointsNV"))
			&& (glMapParameterfvNV = (PFNGLMAPPARAMETERFVNVPROC)get_proc("glMapParameterfvNV"))
			&& (glMapParameterivNV = (PFNGLMAPPARAMETERIVNVPROC)get_proc("glMapParameterivNV"))
			;
	}

	//  ...for GL_NV_fence:
	else if (extension == "GL_NV_fence") {
		loaded = true
			&& (glDeleteFencesNV = (PFNGLDELETEFENCESNVPROC)get_proc("glDeleteFencesNV"))
			&& (glFinishFenceNV = (PFNGLFINISHFENCENVPROC)get_proc("glFinishFenceNV"))
			&& (glGenFencesNV = (PFNGLGENFENCESNVPROC)get_proc("glGenFencesNV"))
			&& (glGetFenceivNV = (PFNGLGETFENCEIVNVPROC)get_proc("glGetFenceivNV"))
			&& (glIsFenceNV = (PFNGLISFENCENVPROC)get_proc("glIsFenceNV"))
			&& (glSetFenceNV = (PFNGLSETFENCENVPROC)get_proc("glSetFenceNV"))
			&& (glTestFenceNV = (PFNGLTESTFENCENVPROC)get_proc("glTestFenceNV"))
			;
	}

	//  ...for GL_NV_fragment_program:
	else if (extension == "GL_NV_fragment_program") {
		loaded = true
			&& (glGetProgramNamedParameterdvNV = (PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC)get_proc("glGetProgramNamedParameterdvNV"))
			&& (glGetProgramNamedParameterfvNV = (PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC)get_proc("glGetProgramNamedParameterfvNV"))
			&& (glProgramNamedParameter4dNV = (PFNGLPROGRAMNAMEDPARAMETER4DNVPROC)get_proc("glProgramNamedParameter4dNV"))
			&& (glProgramNamedParameter4dvNV = (PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC)get_proc("glProgramNamedParameter4dvNV"))
			&& (glProgramNamedParameter4fNV = (PFNGLPROGRAMNAMEDPARAMETER4FNVPROC)get_proc("glProgramNamedParameter4fNV"))
			&& (glProgramNamedParameter4fvNV = (PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC)get_proc("glProgramNamedParameter4fvNV"))
			;
	}

	//  ...for GL_NV_half_float:
	else if (extension == "GL_NV_half_float") {
		loaded = true
			&& (glColor3hNV = (PFNGLCOLOR3HNVPROC)get_proc("glColor3hNV"))
			&& (glColor3hvNV = (PFNGLCOLOR3HVNVPROC)get_proc("glColor3hvNV"))
			&& (glColor4hNV = (PFNGLCOLOR4HNVPROC)get_proc("glColor4hNV"))
			&& (glColor4hvNV = (PFNGLCOLOR4HVNVPROC)get_proc("glColor4hvNV"))
			&& (glFogCoordhNV = (PFNGLFOGCOORDHNVPROC)get_proc("glFogCoordhNV"))
			&& (glFogCoordhvNV = (PFNGLFOGCOORDHVNVPROC)get_proc("glFogCoordhvNV"))
			&& (glMultiTexCoord1hNV = (PFNGLMULTITEXCOORD1HNVPROC)get_proc("glMultiTexCoord1hNV"))
			&& (glMultiTexCoord1hvNV = (PFNGLMULTITEXCOORD1HVNVPROC)get_proc("glMultiTexCoord1hvNV"))
			&& (glMultiTexCoord2hNV = (PFNGLMULTITEXCOORD2HNVPROC)get_proc("glMultiTexCoord2hNV"))
			&& (glMultiTexCoord2hvNV = (PFNGLMULTITEXCOORD2HVNVPROC)get_proc("glMultiTexCoord2hvNV"))
			&& (glMultiTexCoord3hNV = (PFNGLMULTITEXCOORD3HNVPROC)get_proc("glMultiTexCoord3hNV"))
			&& (glMultiTexCoord3hvNV = (PFNGLMULTITEXCOORD3HVNVPROC)get_proc("glMultiTexCoord3hvNV"))
			&& (glMultiTexCoord4hNV = (PFNGLMULTITEXCOORD4HNVPROC)get_proc("glMultiTexCoord4hNV"))
			&& (glMultiTexCoord4hvNV = (PFNGLMULTITEXCOORD4HVNVPROC)get_proc("glMultiTexCoord4hvNV"))
			&& (glNormal3hNV = (PFNGLNORMAL3HNVPROC)get_proc("glNormal3hNV"))
			&& (glNormal3hvNV = (PFNGLNORMAL3HVNVPROC)get_proc("glNormal3hvNV"))
			&& (glSecondaryColor3hNV = (PFNGLSECONDARYCOLOR3HNVPROC)get_proc("glSecondaryColor3hNV"))
			&& (glSecondaryColor3hvNV = (PFNGLSECONDARYCOLOR3HVNVPROC)get_proc("glSecondaryColor3hvNV"))
			&& (glTexCoord1hNV = (PFNGLTEXCOORD1HNVPROC)get_proc("glTexCoord1hNV"))
			&& (glTexCoord1hvNV = (PFNGLTEXCOORD1HVNVPROC)get_proc("glTexCoord1hvNV"))
			&& (glTexCoord2hNV = (PFNGLTEXCOORD2HNVPROC)get_proc("glTexCoord2hNV"))
			&& (glTexCoord2hvNV = (PFNGLTEXCOORD2HVNVPROC)get_proc("glTexCoord2hvNV"))
			&& (glTexCoord3hNV = (PFNGLTEXCOORD3HNVPROC)get_proc("glTexCoord3hNV"))
			&& (glTexCoord3hvNV = (PFNGLTEXCOORD3HVNVPROC)get_proc("glTexCoord3hvNV"))
			&& (glTexCoord4hNV = (PFNGLTEXCOORD4HNVPROC)get_proc("glTexCoord4hNV"))
			&& (glTexCoord4hvNV = (PFNGLTEXCOORD4HVNVPROC)get_proc("glTexCoord4hvNV"))
			&& (glVertex2hNV = (PFNGLVERTEX2HNVPROC)get_proc("glVertex2hNV"))
			&& (glVertex2hvNV = (PFNGLVERTEX2HVNVPROC)get_proc("glVertex2hvNV"))
			&& (glVertex3hNV = (PFNGLVERTEX3HNVPROC)get_proc("glVertex3hNV"))
			&& (glVertex3hvNV = (PFNGLVERTEX3HVNVPROC)get_proc("glVertex3hvNV"))
			&& (glVertex4hNV = (PFNGLVERTEX4HNVPROC)get_proc("glVertex4hNV"))
			&& (glVertex4hvNV = (PFNGLVERTEX4HVNVPROC)get_proc("glVertex4hvNV"))
			&& (glVertexAttrib1hNV = (PFNGLVERTEXATTRIB1HNVPROC)get_proc("glVertexAttrib1hNV"))
			&& (glVertexAttrib1hvNV = (PFNGLVERTEXATTRIB1HVNVPROC)get_proc("glVertexAttrib1hvNV"))
			&& (glVertexAttrib2hNV = (PFNGLVERTEXATTRIB2HNVPROC)get_proc("glVertexAttrib2hNV"))
			&& (glVertexAttrib2hvNV = (PFNGLVERTEXATTRIB2HVNVPROC)get_proc("glVertexAttrib2hvNV"))
			&& (glVertexAttrib3hNV = (PFNGLVERTEXATTRIB3HNVPROC)get_proc("glVertexAttrib3hNV"))
			&& (glVertexAttrib3hvNV = (PFNGLVERTEXATTRIB3HVNVPROC)get_proc("glVertexAttrib3hvNV"))
			&& (glVertexAttrib4hNV = (PFNGLVERTEXATTRIB4HNVPROC)get_proc("glVertexAttrib4hNV"))
			&& (glVertexAttrib4hvNV = (PFNGLVERTEXATTRIB4HVNVPROC)get_proc("glVertexAttrib4hvNV"))
			&& (glVertexAttribs1hvNV = (PFNGLVERTEXATTRIBS1HVNVPROC)get_proc("glVertexAttribs1hvNV"))
			&& (glVertexAttribs2hvNV = (PFNGLVERTEXATTRIBS2HVNVPROC)get_proc("glVertexAttribs2hvNV"))
			&& (glVertexAttribs3hvNV = (PFNGLVERTEXATTRIBS3HVNVPROC)get_proc("glVertexAttribs3hvNV"))
			&& (glVertexAttribs4hvNV = (PFNGLVERTEXATTRIBS4HVNVPROC)get_proc("glVertexAttribs4hvNV"))
			&& (glVertexWeighthNV = (PFNGLVERTEXWEIGHTHNVPROC)get_proc("glVertexWeighthNV"))
			&& (glVertexWeighthvNV = (PFNGLVERTEXWEIGHTHVNVPROC)get_proc("glVertexWeighthvNV"))
			;
	}

	//  ...for GL_NV_occlusion_query:
	else if (extension == "GL_NV_occlusion_query") {
		loaded = true
			&& (glBeginOcclusionQueryNV = (PFNGLBEGINOCCLUSIONQUERYNVPROC)get_proc("glBeginOcclusionQueryNV"))
			&& (glDeleteOcclusionQueriesNV = (PFNGLDELETEOCCLUSIONQUERIESNVPROC)get_proc("glDeleteOcclusionQueriesNV"))
			&& (glEndOcclusionQueryNV = (PFNGLENDOCCLUSIONQUERYNVPROC)get_proc("glEndOcclusionQueryNV"))
			&& (glGenOcclusionQueriesNV = (PFNGLGENOCCLUSIONQUERIESNVPROC)get_proc("glGenOcclusionQueriesNV"))
			&& (glGetOcclusionQueryivNV = (PFNGLGETOCCLUSIONQUERYIVNVPROC)get_proc("glGetOcclusionQueryivNV"))
			&& (glGetOcclusionQueryuivNV = (PFNGLGETOCCLUSIONQUERYUIVNVPROC)get_proc("glGetOcclusionQueryuivNV"))
			&& (glIsOcclusionQueryNV = (PFNGLISOCCLUSIONQUERYNVPROC)get_proc("glIsOcclusionQueryNV"))
			;
	}

	//  ...for GL_NV_pixel_data_range:
	else if (extension == "GL_NV_pixel_data_range") {
		loaded = true
			&& (glFlushPixelDataRangeNV = (PFNGLFLUSHPIXELDATARANGENVPROC)get_proc("glFlushPixelDataRangeNV"))
			&& (glPixelDataRangeNV = (PFNGLPIXELDATARANGENVPROC)get_proc("glPixelDataRangeNV"))
			;
	}

	//  ...for GL_NV_point_sprite:
	else if (extension == "GL_NV_point_sprite") {
		loaded = true
			&& (glPointParameteriNV = (PFNGLPOINTPARAMETERINVPROC)get_proc("glPointParameteriNV"))
			&& (glPointParameterivNV = (PFNGLPOINTPARAMETERIVNVPROC)get_proc("glPointParameterivNV"))
			;
	}

	//  ...for GL_NV_primitive_restart:
	else if (extension == "GL_NV_primitive_restart") {
		loaded = true
			&& (glPrimitiveRestartIndexNV = (PFNGLPRIMITIVERESTARTINDEXNVPROC)get_proc("glPrimitiveRestartIndexNV"))
			&& (glPrimitiveRestartNV = (PFNGLPRIMITIVERESTARTNVPROC)get_proc("glPrimitiveRestartNV"))
			;
	}

	//  ...for GL_NV_register_combiners:
	else if (extension == "GL_NV_register_combiners") {
		loaded = true
			&& (glCombinerInputNV = (PFNGLCOMBINERINPUTNVPROC)get_proc("glCombinerInputNV"))
			&& (glCombinerOutputNV = (PFNGLCOMBINEROUTPUTNVPROC)get_proc("glCombinerOutputNV"))
			&& (glCombinerParameterfNV = (PFNGLCOMBINERPARAMETERFNVPROC)get_proc("glCombinerParameterfNV"))
			&& (glCombinerParameterfvNV = (PFNGLCOMBINERPARAMETERFVNVPROC)get_proc("glCombinerParameterfvNV"))
			&& (glCombinerParameteriNV = (PFNGLCOMBINERPARAMETERINVPROC)get_proc("glCombinerParameteriNV"))
			&& (glCombinerParameterivNV = (PFNGLCOMBINERPARAMETERIVNVPROC)get_proc("glCombinerParameterivNV"))
			&& (glCombinerStageParameterfvNV = (PFNGLCOMBINERSTAGEPARAMETERFVNVPROC)get_proc("glCombinerStageParameterfvNV"))
			&& (glFinalCombinerInputNV = (PFNGLFINALCOMBINERINPUTNVPROC)get_proc("glFinalCombinerInputNV"))
			&& (glGetCombinerInputParameterfvNV = (PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC)get_proc("glGetCombinerInputParameterfvNV"))
			&& (glGetCombinerInputParameterivNV = (PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC)get_proc("glGetCombinerInputParameterivNV"))
			&& (glGetCombinerOutputParameterfvNV = (PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC)get_proc("glGetCombinerOutputParameterfvNV"))
			&& (glGetCombinerOutputParameterivNV = (PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC)get_proc("glGetCombinerOutputParameterivNV"))
			&& (glGetCombinerStageParameterfvNV = (PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC)get_proc("glGetCombinerStageParameterfvNV"))
			&& (glGetFinalCombinerInputParameterfvNV = (PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC)get_proc("glGetFinalCombinerInputParameterfvNV"))
			&& (glGetFinalCombinerInputParameterivNV = (PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC)get_proc("glGetFinalCombinerInputParameterivNV"))
			;
	}

	//  ...for GL_NV_vertex_array_range:
	else if (extension == "GL_NV_vertex_array_range") {
		loaded = true
			&& (glFlushVertexArrayRangeNV = (PFNGLFLUSHVERTEXARRAYRANGENVPROC)get_proc("glFlushVertexArrayRangeNV"))
			&& (glVertexArrayRangeNV = (PFNGLVERTEXARRAYRANGENVPROC)get_proc("glVertexArrayRangeNV"))
			;
	}

	//  ...for GL_NV_vertex_program:
	else if (extension == "GL_NV_vertex_program") {
		loaded = true
			&& (glAreProgramsResidentNV = (PFNGLAREPROGRAMSRESIDENTNVPROC)get_proc("glAreProgramsResidentNV"))
			&& (glBindProgramNV = (PFNGLBINDPROGRAMNVPROC)get_proc("glBindProgramNV"))
			&& (glDeleteProgramsNV = (PFNGLDELETEPROGRAMSNVPROC)get_proc("glDeleteProgramsNV"))
			&& (glExecuteProgramNV = (PFNGLEXECUTEPROGRAMNVPROC)get_proc("glExecuteProgramNV"))
			&& (glGenProgramsNV = (PFNGLGENPROGRAMSNVPROC)get_proc("glGenProgramsNV"))
			&& (glGetProgramivNV = (PFNGLGETPROGRAMIVNVPROC)get_proc("glGetProgramivNV"))
			&& (glGetProgramParameterdvNV = (PFNGLGETPROGRAMPARAMETERDVNVPROC)get_proc("glGetProgramParameterdvNV"))
			&& (glGetProgramParameterfvNV = (PFNGLGETPROGRAMPARAMETERFVNVPROC)get_proc("glGetProgramParameterfvNV"))
			&& (glGetProgramStringNV = (PFNGLGETPROGRAMSTRINGNVPROC)get_proc("glGetProgramStringNV"))
			&& (glGetTrackMatrixivNV = (PFNGLGETTRACKMATRIXIVNVPROC)get_proc("glGetTrackMatrixivNV"))
			&& (glGetVertexAttribdvNV = (PFNGLGETVERTEXATTRIBDVNVPROC)get_proc("glGetVertexAttribdvNV"))
			&& (glGetVertexAttribfvNV = (PFNGLGETVERTEXATTRIBFVNVPROC)get_proc("glGetVertexAttribfvNV"))
			&& (glGetVertexAttribivNV = (PFNGLGETVERTEXATTRIBIVNVPROC)get_proc("glGetVertexAttribivNV"))
			&& (glGetVertexAttribPointervNV = (PFNGLGETVERTEXATTRIBPOINTERVNVPROC)get_proc("glGetVertexAttribPointervNV"))
			&& (glIsProgramNV = (PFNGLISPROGRAMNVPROC)get_proc("glIsProgramNV"))
			&& (glLoadProgramNV = (PFNGLLOADPROGRAMNVPROC)get_proc("glLoadProgramNV"))
			&& (glProgramParameter4dNV = (PFNGLPROGRAMPARAMETER4DNVPROC)get_proc("glProgramParameter4dNV"))
			&& (glProgramParameter4dvNV = (PFNGLPROGRAMPARAMETER4DVNVPROC)get_proc("glProgramParameter4dvNV"))
			&& (glProgramParameter4fNV = (PFNGLPROGRAMPARAMETER4FNVPROC)get_proc("glProgramParameter4fNV"))
			&& (glProgramParameter4fvNV = (PFNGLPROGRAMPARAMETER4FVNVPROC)get_proc("glProgramParameter4fvNV"))
			&& (glProgramParameters4dvNV = (PFNGLPROGRAMPARAMETERS4DVNVPROC)get_proc("glProgramParameters4dvNV"))
			&& (glProgramParameters4fvNV = (PFNGLPROGRAMPARAMETERS4FVNVPROC)get_proc("glProgramParameters4fvNV"))
			&& (glRequestResidentProgramsNV = (PFNGLREQUESTRESIDENTPROGRAMSNVPROC)get_proc("glRequestResidentProgramsNV"))
			&& (glTrackMatrixNV = (PFNGLTRACKMATRIXNVPROC)get_proc("glTrackMatrixNV"))
			&& (glVertexAttrib1dNV = (PFNGLVERTEXATTRIB1DNVPROC)get_proc("glVertexAttrib1dNV"))
			&& (glVertexAttrib1dvNV = (PFNGLVERTEXATTRIB1DVNVPROC)get_proc("glVertexAttrib1dvNV"))
			&& (glVertexAttrib1fNV = (PFNGLVERTEXATTRIB1FNVPROC)get_proc("glVertexAttrib1fNV"))
			&& (glVertexAttrib1fvNV = (PFNGLVERTEXATTRIB1FVNVPROC)get_proc("glVertexAttrib1fvNV"))
			&& (glVertexAttrib1sNV = (PFNGLVERTEXATTRIB1SNVPROC)get_proc("glVertexAttrib1sNV"))
			&& (glVertexAttrib1svNV = (PFNGLVERTEXATTRIB1SVNVPROC)get_proc("glVertexAttrib1svNV"))
			&& (glVertexAttrib2dNV = (PFNGLVERTEXATTRIB2DNVPROC)get_proc("glVertexAttrib2dNV"))
			&& (glVertexAttrib2dvNV = (PFNGLVERTEXATTRIB2DVNVPROC)get_proc("glVertexAttrib2dvNV"))
			&& (glVertexAttrib2fNV = (PFNGLVERTEXATTRIB2FNVPROC)get_proc("glVertexAttrib2fNV"))
			&& (glVertexAttrib2fvNV = (PFNGLVERTEXATTRIB2FVNVPROC)get_proc("glVertexAttrib2fvNV"))
			&& (glVertexAttrib2sNV = (PFNGLVERTEXATTRIB2SNVPROC)get_proc("glVertexAttrib2sNV"))
			&& (glVertexAttrib2svNV = (PFNGLVERTEXATTRIB2SVNVPROC)get_proc("glVertexAttrib2svNV"))
			&& (glVertexAttrib3dNV = (PFNGLVERTEXATTRIB3DNVPROC)get_proc("glVertexAttrib3dNV"))
			&& (glVertexAttrib3dvNV = (PFNGLVERTEXATTRIB3DVNVPROC)get_proc("glVertexAttrib3dvNV"))
			&& (glVertexAttrib3fNV = (PFNGLVERTEXATTRIB3FNVPROC)get_proc("glVertexAttrib3fNV"))
			&& (glVertexAttrib3fvNV = (PFNGLVERTEXATTRIB3FVNVPROC)get_proc("glVertexAttrib3fvNV"))
			&& (glVertexAttrib3sNV = (PFNGLVERTEXATTRIB3SNVPROC)get_proc("glVertexAttrib3sNV"))
			&& (glVertexAttrib3svNV = (PFNGLVERTEXATTRIB3SVNVPROC)get_proc("glVertexAttrib3svNV"))
			&& (glVertexAttrib4dNV = (PFNGLVERTEXATTRIB4DNVPROC)get_proc("glVertexAttrib4dNV"))
			&& (glVertexAttrib4dvNV = (PFNGLVERTEXATTRIB4DVNVPROC)get_proc("glVertexAttrib4dvNV"))
			&& (glVertexAttrib4fNV = (PFNGLVERTEXATTRIB4FNVPROC)get_proc("glVertexAttrib4fNV"))
			&& (glVertexAttrib4fvNV = (PFNGLVERTEXATTRIB4FVNVPROC)get_proc("glVertexAttrib4fvNV"))
			&& (glVertexAttrib4sNV = (PFNGLVERTEXATTRIB4SNVPROC)get_proc("glVertexAttrib4sNV"))
			&& (glVertexAttrib4svNV = (PFNGLVERTEXATTRIB4SVNVPROC)get_proc("glVertexAttrib4svNV"))
			&& (glVertexAttrib4ubNV = (PFNGLVERTEXATTRIB4UBNVPROC)get_proc("glVertexAttrib4ubNV"))
			&& (glVertexAttrib4ubvNV = (PFNGLVERTEXATTRIB4UBVNVPROC)get_proc("glVertexAttrib4ubvNV"))
			&& (glVertexAttribPointerNV = (PFNGLVERTEXATTRIBPOINTERNVPROC)get_proc("glVertexAttribPointerNV"))
			&& (glVertexAttribs1dvNV = (PFNGLVERTEXATTRIBS1DVNVPROC)get_proc("glVertexAttribs1dvNV"))
			&& (glVertexAttribs1fvNV = (PFNGLVERTEXATTRIBS1FVNVPROC)get_proc("glVertexAttribs1fvNV"))
			&& (glVertexAttribs1svNV = (PFNGLVERTEXATTRIBS1SVNVPROC)get_proc("glVertexAttribs1svNV"))
			&& (glVertexAttribs2dvNV = (PFNGLVERTEXATTRIBS2DVNVPROC)get_proc("glVertexAttribs2dvNV"))
			&& (glVertexAttribs2fvNV = (PFNGLVERTEXATTRIBS2FVNVPROC)get_proc("glVertexAttribs2fvNV"))
			&& (glVertexAttribs2svNV = (PFNGLVERTEXATTRIBS2SVNVPROC)get_proc("glVertexAttribs2svNV"))
			&& (glVertexAttribs3dvNV = (PFNGLVERTEXATTRIBS3DVNVPROC)get_proc("glVertexAttribs3dvNV"))
			&& (glVertexAttribs3fvNV = (PFNGLVERTEXATTRIBS3FVNVPROC)get_proc("glVertexAttribs3fvNV"))
			&& (glVertexAttribs3svNV = (PFNGLVERTEXATTRIBS3SVNVPROC)get_proc("glVertexAttribs3svNV"))
			&& (glVertexAttribs4dvNV = (PFNGLVERTEXATTRIBS4DVNVPROC)get_proc("glVertexAttribs4dvNV"))
			&& (glVertexAttribs4fvNV = (PFNGLVERTEXATTRIBS4FVNVPROC)get_proc("glVertexAttribs4fvNV"))
			&& (glVertexAttribs4svNV = (PFNGLVERTEXATTRIBS4SVNVPROC)get_proc("glVertexAttribs4svNV"))
			&& (glVertexAttribs4ubvNV = (PFNGLVERTEXATTRIBS4UBVNVPROC)get_proc("glVertexAttribs4ubvNV"))
			;
	}

	//  ...for GL_PGI_misc_hints:
	else if (extension == "GL_PGI_misc_hints") {
		loaded = true
			&& (glHintPGI = (PFNGLHINTPGIPROC)get_proc("glHintPGI"))
			;
	}

	//  ...for GL_SGIS_detail_texture:
	else if (extension == "GL_SGIS_detail_texture") {
		loaded = true
			&& (glDetailTexFuncSGIS = (PFNGLDETAILTEXFUNCSGISPROC)get_proc("glDetailTexFuncSGIS"))
			&& (glGetDetailTexFuncSGIS = (PFNGLGETDETAILTEXFUNCSGISPROC)get_proc("glGetDetailTexFuncSGIS"))
			;
	}

	//  ...for GL_SGIS_fog_function:
	else if (extension == "GL_SGIS_fog_function") {
		loaded = true
			&& (glFogFuncSGIS = (PFNGLFOGFUNCSGISPROC)get_proc("glFogFuncSGIS"))
			&& (glGetFogFuncSGIS = (PFNGLGETFOGFUNCSGISPROC)get_proc("glGetFogFuncSGIS"))
			;
	}

	//  ...for GL_SGIS_multisample:
	else if (extension == "GL_SGIS_multisample") {
		loaded = true
			&& (glSampleMaskSGIS = (PFNGLSAMPLEMASKSGISPROC)get_proc("glSampleMaskSGIS"))
			&& (glSamplePatternSGIS = (PFNGLSAMPLEPATTERNSGISPROC)get_proc("glSamplePatternSGIS"))
			;
	}

	//  ...for GL_SGIS_pixel_texture:
	else if (extension == "GL_SGIS_pixel_texture") {
		loaded = true
			&& (glGetPixelTexGenParameterfvSGIS = (PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC)get_proc("glGetPixelTexGenParameterfvSGIS"))
			&& (glGetPixelTexGenParameterivSGIS = (PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC)get_proc("glGetPixelTexGenParameterivSGIS"))
			&& (glPixelTexGenParameterfSGIS = (PFNGLPIXELTEXGENPARAMETERFSGISPROC)get_proc("glPixelTexGenParameterfSGIS"))
			&& (glPixelTexGenParameterfvSGIS = (PFNGLPIXELTEXGENPARAMETERFVSGISPROC)get_proc("glPixelTexGenParameterfvSGIS"))
			&& (glPixelTexGenParameteriSGIS = (PFNGLPIXELTEXGENPARAMETERISGISPROC)get_proc("glPixelTexGenParameteriSGIS"))
			&& (glPixelTexGenParameterivSGIS = (PFNGLPIXELTEXGENPARAMETERIVSGISPROC)get_proc("glPixelTexGenParameterivSGIS"))
			;
	}

	//  ...for GL_SGIS_point_parameters:
	else if (extension == "GL_SGIS_point_parameters") {
		loaded = true
			&& (glPointParameterfSGIS = (PFNGLPOINTPARAMETERFSGISPROC)get_proc("glPointParameterfSGIS"))
			&& (glPointParameterfvSGIS = (PFNGLPOINTPARAMETERFVSGISPROC)get_proc("glPointParameterfvSGIS"))
			;
	}

	//  ...for GL_SGIS_sharpen_texture:
	else if (extension == "GL_SGIS_sharpen_texture") {
		loaded = true
			&& (glGetSharpenTexFuncSGIS = (PFNGLGETSHARPENTEXFUNCSGISPROC)get_proc("glGetSharpenTexFuncSGIS"))
			&& (glSharpenTexFuncSGIS = (PFNGLSHARPENTEXFUNCSGISPROC)get_proc("glSharpenTexFuncSGIS"))
			;
	}

	//  ...for GL_SGIS_texture:
	else if (extension == "GL_SGIS_texture") {
		loaded = true
			&& (glTexImage4DSGIS = (PFNGLTEXIMAGE4DSGISPROC)get_proc("glTexImage4DSGIS"))
			&& (glTexSubImage4DSGIS = (PFNGLTEXSUBIMAGE4DSGISPROC)get_proc("glTexSubImage4DSGIS"))
			;
	}

	//  ...for GL_SGIS_texture_color_mask:
	else if (extension == "GL_SGIS_texture_color_mask") {
		loaded = true
			&& (glTextureColorMaskSGIS = (PFNGLTEXTURECOLORMASKSGISPROC)get_proc("glTextureColorMaskSGIS"))
			;
	}

	//  ...for GL_SGIS_texture_filter:
	else if (extension == "GL_SGIS_texture_filter") {
		loaded = true
			&& (glGetTexFilterFuncSGIS = (PFNGLGETTEXFILTERFUNCSGISPROC)get_proc("glGetTexFilterFuncSGIS"))
			&& (glTexFilterFuncSGIS = (PFNGLTEXFILTERFUNCSGISPROC)get_proc("glTexFilterFuncSGIS"))
			;
	}

	//  ...for GL_SGIX_async:
	else if (extension == "GL_SGIX_async") {
		loaded = true
			&& (glAsyncMarkerSGIX = (PFNGLASYNCMARKERSGIXPROC)get_proc("glAsyncMarkerSGIX"))
			&& (glDeleteAsyncMarkersSGIX = (PFNGLDELETEASYNCMARKERSSGIXPROC)get_proc("glDeleteAsyncMarkersSGIX"))
			&& (glFinishAsyncSGIX = (PFNGLFINISHASYNCSGIXPROC)get_proc("glFinishAsyncSGIX"))
			&& (glGenAsyncMarkersSGIX = (PFNGLGENASYNCMARKERSSGIXPROC)get_proc("glGenAsyncMarkersSGIX"))
			&& (glIsAsyncMarkerSGIX = (PFNGLISASYNCMARKERSGIXPROC)get_proc("glIsAsyncMarkerSGIX"))
			&& (glPollAsyncSGIX = (PFNGLPOLLASYNCSGIXPROC)get_proc("glPollAsyncSGIX"))
			;
	}

	//  ...for GL_SGIX_depth_pass_instrument:
	else if (extension == "GL_SGIX_depth_pass_instrument") {
		loaded = true
			&& (glTbufferMask3DFX = (PFNGLTBUFFERMASK3DFXPROC)get_proc("glTbufferMask3DFX"))
			;
	}

	//  ...for GL_SGIX_flush_raster:
	else if (extension == "GL_SGIX_flush_raster") {
		loaded = true
			&& (glFlushRasterSGIX = (PFNGLFLUSHRASTERSGIXPROC)get_proc("glFlushRasterSGIX"))
			;
	}

	//  ...for GL_SGIX_fragment_lighting:
	else if (extension == "GL_SGIX_fragment_lighting") {
		loaded = true
			&& (glFragmentColorMaterialSGIX = (PFNGLFRAGMENTCOLORMATERIALSGIXPROC)get_proc("glFragmentColorMaterialSGIX"))
			&& (glFragmentLightfSGIX = (PFNGLFRAGMENTLIGHTFSGIXPROC)get_proc("glFragmentLightfSGIX"))
			&& (glFragmentLightfvSGIX = (PFNGLFRAGMENTLIGHTFVSGIXPROC)get_proc("glFragmentLightfvSGIX"))
			&& (glFragmentLightiSGIX = (PFNGLFRAGMENTLIGHTISGIXPROC)get_proc("glFragmentLightiSGIX"))
			&& (glFragmentLightivSGIX = (PFNGLFRAGMENTLIGHTIVSGIXPROC)get_proc("glFragmentLightivSGIX"))
			&& (glFragmentLightModelfSGIX = (PFNGLFRAGMENTLIGHTMODELFSGIXPROC)get_proc("glFragmentLightModelfSGIX"))
			&& (glFragmentLightModelfvSGIX = (PFNGLFRAGMENTLIGHTMODELFVSGIXPROC)get_proc("glFragmentLightModelfvSGIX"))
			&& (glFragmentLightModeliSGIX = (PFNGLFRAGMENTLIGHTMODELISGIXPROC)get_proc("glFragmentLightModeliSGIX"))
			&& (glFragmentLightModelivSGIX = (PFNGLFRAGMENTLIGHTMODELIVSGIXPROC)get_proc("glFragmentLightModelivSGIX"))
			&& (glFragmentMaterialfSGIX = (PFNGLFRAGMENTMATERIALFSGIXPROC)get_proc("glFragmentMaterialfSGIX"))
			&& (glFragmentMaterialfvSGIX = (PFNGLFRAGMENTMATERIALFVSGIXPROC)get_proc("glFragmentMaterialfvSGIX"))
			&& (glFragmentMaterialiSGIX = (PFNGLFRAGMENTMATERIALISGIXPROC)get_proc("glFragmentMaterialiSGIX"))
			&& (glFragmentMaterialivSGIX = (PFNGLFRAGMENTMATERIALIVSGIXPROC)get_proc("glFragmentMaterialivSGIX"))
			&& (glGetFragmentLightfvSGIX = (PFNGLGETFRAGMENTLIGHTFVSGIXPROC)get_proc("glGetFragmentLightfvSGIX"))
			&& (glGetFragmentLightivSGIX = (PFNGLGETFRAGMENTLIGHTIVSGIXPROC)get_proc("glGetFragmentLightivSGIX"))
			&& (glGetFragmentMaterialfvSGIX = (PFNGLGETFRAGMENTMATERIALFVSGIXPROC)get_proc("glGetFragmentMaterialfvSGIX"))
			&& (glGetFragmentMaterialivSGIX = (PFNGLGETFRAGMENTMATERIALIVSGIXPROC)get_proc("glGetFragmentMaterialivSGIX"))
			&& (glLightEnviSGIX = (PFNGLLIGHTENVISGIXPROC)get_proc("glLightEnviSGIX"))
			;
	}

	//  ...for GL_SGIX_framezoom:
	else if (extension == "GL_SGIX_framezoom") {
		loaded = true
			&& (glFrameZoomSGIX = (PFNGLFRAMEZOOMSGIXPROC)get_proc("glFrameZoomSGIX"))
			;
	}

	//  ...for GL_SGIX_igloo_interface:
	else if (extension == "GL_SGIX_igloo_interface") {
		loaded = true
			&& (glIglooInterfaceSGIX = (PFNGLIGLOOINTERFACESGIXPROC)get_proc("glIglooInterfaceSGIX"))
			;
	}

	//  ...for GL_SGIX_instruments:
	else if (extension == "GL_SGIX_instruments") {
		loaded = true
			&& (glGetInstrumentsSGIX = (PFNGLGETINSTRUMENTSSGIXPROC)get_proc("glGetInstrumentsSGIX"))
			&& (glInstrumentsBufferSGIX = (PFNGLINSTRUMENTSBUFFERSGIXPROC)get_proc("glInstrumentsBufferSGIX"))
			&& (glPollInstrumentsSGIX = (PFNGLPOLLINSTRUMENTSSGIXPROC)get_proc("glPollInstrumentsSGIX"))
			&& (glReadInstrumentsSGIX = (PFNGLREADINSTRUMENTSSGIXPROC)get_proc("glReadInstrumentsSGIX"))
			&& (glStartInstrumentsSGIX = (PFNGLSTARTINSTRUMENTSSGIXPROC)get_proc("glStartInstrumentsSGIX"))
			&& (glStopInstrumentsSGIX = (PFNGLSTOPINSTRUMENTSSGIXPROC)get_proc("glStopInstrumentsSGIX"))
			;
	}

	//  ...for GL_SGIX_list_priority:
	else if (extension == "GL_SGIX_list_priority") {
		loaded = true
			&& (glGetListParameterfvSGIX = (PFNGLGETLISTPARAMETERFVSGIXPROC)get_proc("glGetListParameterfvSGIX"))
			&& (glGetListParameterivSGIX = (PFNGLGETLISTPARAMETERIVSGIXPROC)get_proc("glGetListParameterivSGIX"))
			&& (glListParameterfSGIX = (PFNGLLISTPARAMETERFSGIXPROC)get_proc("glListParameterfSGIX"))
			&& (glListParameterfvSGIX = (PFNGLLISTPARAMETERFVSGIXPROC)get_proc("glListParameterfvSGIX"))
			&& (glListParameteriSGIX = (PFNGLLISTPARAMETERISGIXPROC)get_proc("glListParameteriSGIX"))
			&& (glListParameterivSGIX = (PFNGLLISTPARAMETERIVSGIXPROC)get_proc("glListParameterivSGIX"))
			;
	}

	//  ...for GL_SGIX_pixel_texture:
	else if (extension == "GL_SGIX_pixel_texture") {
		loaded = true
			&& (glPixelTexGenSGIX = (PFNGLPIXELTEXGENSGIXPROC)get_proc("glPixelTexGenSGIX"))
			;
	}

	//  ...for GL_SGIX_polynomial_ffd:
	else if (extension == "GL_SGIX_polynomial_ffd") {
		loaded = true
			&& (glDeformationMap3dSGIX = (PFNGLDEFORMATIONMAP3DSGIXPROC)get_proc("glDeformationMap3dSGIX"))
			&& (glDeformationMap3fSGIX = (PFNGLDEFORMATIONMAP3FSGIXPROC)get_proc("glDeformationMap3fSGIX"))
			&& (glDeformSGIX = (PFNGLDEFORMSGIXPROC)get_proc("glDeformSGIX"))
			&& (glLoadIdentityDeformationMapSGIX = (PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC)get_proc("glLoadIdentityDeformationMapSGIX"))
			;
	}

	//  ...for GL_SGIX_reference_plane:
	else if (extension == "GL_SGIX_reference_plane") {
		loaded = true
			&& (glReferencePlaneSGIX = (PFNGLREFERENCEPLANESGIXPROC)get_proc("glReferencePlaneSGIX"))
			;
	}

	//  ...for GL_SGIX_sprite:
	else if (extension == "GL_SGIX_sprite") {
		loaded = true
			&& (glSpriteParameterfSGIX = (PFNGLSPRITEPARAMETERFSGIXPROC)get_proc("glSpriteParameterfSGIX"))
			&& (glSpriteParameterfvSGIX = (PFNGLSPRITEPARAMETERFVSGIXPROC)get_proc("glSpriteParameterfvSGIX"))
			&& (glSpriteParameteriSGIX = (PFNGLSPRITEPARAMETERISGIXPROC)get_proc("glSpriteParameteriSGIX"))
			&& (glSpriteParameterivSGIX = (PFNGLSPRITEPARAMETERIVSGIXPROC)get_proc("glSpriteParameterivSGIX"))
			;
	}

	//  ...for GL_SGIX_tag_sample_buffer:
	else if (extension == "GL_SGIX_tag_sample_buffer") {
		loaded = true
			&& (glTagSampleBufferSGIX = (PFNGLTAGSAMPLEBUFFERSGIXPROC)get_proc("glTagSampleBufferSGIX"))
			;
	}

	//  ...for GL_SGI_color_table:
	else if (extension == "GL_SGI_color_table") {
		loaded = true
			&& (glColorTableParameterfvSGI = (PFNGLCOLORTABLEPARAMETERFVSGIPROC)get_proc("glColorTableParameterfvSGI"))
			&& (glColorTableParameterivSGI = (PFNGLCOLORTABLEPARAMETERIVSGIPROC)get_proc("glColorTableParameterivSGI"))
			&& (glColorTableSGI = (PFNGLCOLORTABLESGIPROC)get_proc("glColorTableSGI"))
			&& (glCopyColorTableSGI = (PFNGLCOPYCOLORTABLESGIPROC)get_proc("glCopyColorTableSGI"))
			&& (glGetColorTableParameterfvSGI = (PFNGLGETCOLORTABLEPARAMETERFVSGIPROC)get_proc("glGetColorTableParameterfvSGI"))
			&& (glGetColorTableParameterivSGI = (PFNGLGETCOLORTABLEPARAMETERIVSGIPROC)get_proc("glGetColorTableParameterivSGI"))
			&& (glGetColorTableSGI = (PFNGLGETCOLORTABLESGIPROC)get_proc("glGetColorTableSGI"))
			;
	}

	//  ...for GL_SUNX_constant_data:
	else if (extension == "GL_SUNX_constant_data") {
		loaded = true
			&& (glFinishTextureSUNX = (PFNGLFINISHTEXTURESUNXPROC)get_proc("glFinishTextureSUNX"))
			;
	}

	//  ...for GL_SUN_global_alpha:
	else if (extension == "GL_SUN_global_alpha") {
		loaded = true
			&& (glGlobalAlphaFactorbSUN = (PFNGLGLOBALALPHAFACTORBSUNPROC)get_proc("glGlobalAlphaFactorbSUN"))
			&& (glGlobalAlphaFactordSUN = (PFNGLGLOBALALPHAFACTORDSUNPROC)get_proc("glGlobalAlphaFactordSUN"))
			&& (glGlobalAlphaFactorfSUN = (PFNGLGLOBALALPHAFACTORFSUNPROC)get_proc("glGlobalAlphaFactorfSUN"))
			&& (glGlobalAlphaFactoriSUN = (PFNGLGLOBALALPHAFACTORISUNPROC)get_proc("glGlobalAlphaFactoriSUN"))
			&& (glGlobalAlphaFactorsSUN = (PFNGLGLOBALALPHAFACTORSSUNPROC)get_proc("glGlobalAlphaFactorsSUN"))
			&& (glGlobalAlphaFactorubSUN = (PFNGLGLOBALALPHAFACTORUBSUNPROC)get_proc("glGlobalAlphaFactorubSUN"))
			&& (glGlobalAlphaFactoruiSUN = (PFNGLGLOBALALPHAFACTORUISUNPROC)get_proc("glGlobalAlphaFactoruiSUN"))
			&& (glGlobalAlphaFactorusSUN = (PFNGLGLOBALALPHAFACTORUSSUNPROC)get_proc("glGlobalAlphaFactorusSUN"))
			;
	}

	//  ...for GL_SUN_mesh_array:
	else if (extension == "GL_SUN_mesh_array") {
		loaded = true
			&& (glDrawMeshArraysSUN = (PFNGLDRAWMESHARRAYSSUNPROC)get_proc("glDrawMeshArraysSUN"))
			;
	}

	//  ...for GL_SUN_triangle_list:
	else if (extension == "GL_SUN_triangle_list") {
		loaded = true
			&& (glReplacementCodePointerSUN = (PFNGLREPLACEMENTCODEPOINTERSUNPROC)get_proc("glReplacementCodePointerSUN"))
			&& (glReplacementCodeubSUN = (PFNGLREPLACEMENTCODEUBSUNPROC)get_proc("glReplacementCodeubSUN"))
			&& (glReplacementCodeubvSUN = (PFNGLREPLACEMENTCODEUBVSUNPROC)get_proc("glReplacementCodeubvSUN"))
			&& (glReplacementCodeuiSUN = (PFNGLREPLACEMENTCODEUISUNPROC)get_proc("glReplacementCodeuiSUN"))
			&& (glReplacementCodeuivSUN = (PFNGLREPLACEMENTCODEUIVSUNPROC)get_proc("glReplacementCodeuivSUN"))
			&& (glReplacementCodeusSUN = (PFNGLREPLACEMENTCODEUSSUNPROC)get_proc("glReplacementCodeusSUN"))
			&& (glReplacementCodeusvSUN = (PFNGLREPLACEMENTCODEUSVSUNPROC)get_proc("glReplacementCodeusvSUN"))
			;
	}

	//  ...for GL_SUN_vertex:
	else if (extension == "GL_SUN_vertex") {
		loaded = true
			&& (glColor3fVertex3fSUN = (PFNGLCOLOR3FVERTEX3FSUNPROC)get_proc("glColor3fVertex3fSUN"))
			&& (glColor3fVertex3fvSUN = (PFNGLCOLOR3FVERTEX3FVSUNPROC)get_proc("glColor3fVertex3fvSUN"))
			&& (glColor4fNormal3fVertex3fSUN = (PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC)get_proc("glColor4fNormal3fVertex3fSUN"))
			&& (glColor4fNormal3fVertex3fvSUN = (PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC)get_proc("glColor4fNormal3fVertex3fvSUN"))
			&& (glColor4ubVertex2fSUN = (PFNGLCOLOR4UBVERTEX2FSUNPROC)get_proc("glColor4ubVertex2fSUN"))
			&& (glColor4ubVertex2fvSUN = (PFNGLCOLOR4UBVERTEX2FVSUNPROC)get_proc("glColor4ubVertex2fvSUN"))
			&& (glColor4ubVertex3fSUN = (PFNGLCOLOR4UBVERTEX3FSUNPROC)get_proc("glColor4ubVertex3fSUN"))
			&& (glColor4ubVertex3fvSUN = (PFNGLCOLOR4UBVERTEX3FVSUNPROC)get_proc("glColor4ubVertex3fvSUN"))
			&& (glNormal3fVertex3fSUN = (PFNGLNORMAL3FVERTEX3FSUNPROC)get_proc("glNormal3fVertex3fSUN"))
			&& (glNormal3fVertex3fvSUN = (PFNGLNORMAL3FVERTEX3FVSUNPROC)get_proc("glNormal3fVertex3fvSUN"))
			&& (glReplacementCodeuiColor3fVertex3fSUN = (PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC)get_proc("glReplacementCodeuiColor3fVertex3fSUN"))
			&& (glReplacementCodeuiColor3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiColor3fVertex3fvSUN"))
			&& (glReplacementCodeuiColor4fNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC)get_proc("glReplacementCodeuiColor4fNormal3fVertex3fSUN"))
			&& (glReplacementCodeuiColor4fNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiColor4fNormal3fVertex3fvSUN"))
			&& (glReplacementCodeuiColor4ubVertex3fSUN = (PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC)get_proc("glReplacementCodeuiColor4ubVertex3fSUN"))
			&& (glReplacementCodeuiColor4ubVertex3fvSUN = (PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiColor4ubVertex3fvSUN"))
			&& (glReplacementCodeuiNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC)get_proc("glReplacementCodeuiNormal3fVertex3fSUN"))
			&& (glReplacementCodeuiNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiNormal3fVertex3fvSUN"))
			&& (glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC)get_proc("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN"))
			&& (glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN"))
			&& (glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC)get_proc("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN"))
			&& (glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN"))
			&& (glReplacementCodeuiTexCoord2fVertex3fSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC)get_proc("glReplacementCodeuiTexCoord2fVertex3fSUN"))
			&& (glReplacementCodeuiTexCoord2fVertex3fvSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiTexCoord2fVertex3fvSUN"))
			&& (glReplacementCodeuiVertex3fSUN = (PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC)get_proc("glReplacementCodeuiVertex3fSUN"))
			&& (glReplacementCodeuiVertex3fvSUN = (PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC)get_proc("glReplacementCodeuiVertex3fvSUN"))
			&& (glTexCoord2fColor3fVertex3fSUN = (PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC)get_proc("glTexCoord2fColor3fVertex3fSUN"))
			&& (glTexCoord2fColor3fVertex3fvSUN = (PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC)get_proc("glTexCoord2fColor3fVertex3fvSUN"))
			&& (glTexCoord2fColor4fNormal3fVertex3fSUN = (PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC)get_proc("glTexCoord2fColor4fNormal3fVertex3fSUN"))
			&& (glTexCoord2fColor4fNormal3fVertex3fvSUN = (PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC)get_proc("glTexCoord2fColor4fNormal3fVertex3fvSUN"))
			&& (glTexCoord2fColor4ubVertex3fSUN = (PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC)get_proc("glTexCoord2fColor4ubVertex3fSUN"))
			&& (glTexCoord2fColor4ubVertex3fvSUN = (PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC)get_proc("glTexCoord2fColor4ubVertex3fvSUN"))
			&& (glTexCoord2fNormal3fVertex3fSUN = (PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC)get_proc("glTexCoord2fNormal3fVertex3fSUN"))
			&& (glTexCoord2fNormal3fVertex3fvSUN = (PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC)get_proc("glTexCoord2fNormal3fVertex3fvSUN"))
			&& (glTexCoord2fVertex3fSUN = (PFNGLTEXCOORD2FVERTEX3FSUNPROC)get_proc("glTexCoord2fVertex3fSUN"))
			&& (glTexCoord2fVertex3fvSUN = (PFNGLTEXCOORD2FVERTEX3FVSUNPROC)get_proc("glTexCoord2fVertex3fvSUN"))
			&& (glTexCoord4fColor4fNormal3fVertex4fSUN = (PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC)get_proc("glTexCoord4fColor4fNormal3fVertex4fSUN"))
			&& (glTexCoord4fColor4fNormal3fVertex4fvSUN = (PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC)get_proc("glTexCoord4fColor4fNormal3fVertex4fvSUN"))
			&& (glTexCoord4fVertex4fSUN = (PFNGLTEXCOORD4FVERTEX4FSUNPROC)get_proc("glTexCoord4fVertex4fSUN"))
			&& (glTexCoord4fVertex4fvSUN = (PFNGLTEXCOORD4FVERTEX4FVSUNPROC)get_proc("glTexCoord4fVertex4fvSUN"))
			;
	}
	else {
		cerr << "Extension name '" << extension << "' not found." << endl;
		return false;
	}
	if (loaded) {
		get_set().insert(extension);
		return true;
	} else {
		cerr << "Extension name '" << extension << "' not loaded." << endl;
		return false;
	}
#else
	return true;
#endif
}

#ifndef MACOSX

//Actually define the function pointers...

//  ...for GL_APPLE_element_array:
PFNGLDRAWELEMENTARRAYAPPLEPROC glDrawElementArrayAPPLE;
PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC glDrawRangeElementArrayAPPLE;
PFNGLELEMENTPOINTERAPPLEPROC glElementPointerAPPLE;
PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC glMultiDrawElementArrayAPPLE;
PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC glMultiDrawRangeElementArrayAPPLE;

//  ...for GL_APPLE_fence:
PFNGLDELETEFENCESAPPLEPROC glDeleteFencesAPPLE;
PFNGLFINISHFENCEAPPLEPROC glFinishFenceAPPLE;
PFNGLFINISHOBJECTAPPLEPROC glFinishObjectAPPLE;
PFNGLGENFENCESAPPLEPROC glGenFencesAPPLE;
PFNGLISFENCEAPPLEPROC glIsFenceAPPLE;
PFNGLSETFENCEAPPLEPROC glSetFenceAPPLE;
PFNGLTESTFENCEAPPLEPROC glTestFenceAPPLE;
PFNGLTESTOBJECTAPPLEPROC glTestObjectAPPLE;

//  ...for GL_APPLE_vertex_array_object:
PFNGLBINDVERTEXARRAYAPPLEPROC glBindVertexArrayAPPLE;
PFNGLDELETEVERTEXARRAYSAPPLEPROC glDeleteVertexArraysAPPLE;
PFNGLGENVERTEXARRAYSAPPLEPROC glGenVertexArraysAPPLE;
PFNGLISVERTEXARRAYAPPLEPROC glIsVertexArrayAPPLE;

//  ...for GL_APPLE_vertex_array_range:
PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC glFlushVertexArrayRangeAPPLE;
PFNGLVERTEXARRAYPARAMETERIAPPLEPROC glVertexArrayParameteriAPPLE;
PFNGLVERTEXARRAYRANGEAPPLEPROC glVertexArrayRangeAPPLE;

//  ...for GL_ARB_color_buffer_float:
PFNGLCLAMPCOLORARBPROC glClampColorARB;

//  ...for GL_ARB_draw_buffers:
PFNGLDRAWBUFFERSARBPROC glDrawBuffersARB;

//  ...for GL_ARB_matrix_palette:
PFNGLCURRENTPALETTEMATRIXARBPROC glCurrentPaletteMatrixARB;
PFNGLMATRIXINDEXPOINTERARBPROC glMatrixIndexPointerARB;
PFNGLMATRIXINDEXUBVARBPROC glMatrixIndexubvARB;
PFNGLMATRIXINDEXUIVARBPROC glMatrixIndexuivARB;
PFNGLMATRIXINDEXUSVARBPROC glMatrixIndexusvARB;

//  ...for GL_ARB_multisample:
PFNGLSAMPLECOVERAGEARBPROC glSampleCoverageARB;

//  ...for GL_ARB_multitexture:
PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;
PFNGLCLIENTACTIVETEXTUREARBPROC glClientActiveTextureARB;
PFNGLMULTITEXCOORD1DARBPROC glMultiTexCoord1dARB;
PFNGLMULTITEXCOORD1DVARBPROC glMultiTexCoord1dvARB;
PFNGLMULTITEXCOORD1FARBPROC glMultiTexCoord1fARB;
PFNGLMULTITEXCOORD1FVARBPROC glMultiTexCoord1fvARB;
PFNGLMULTITEXCOORD1IARBPROC glMultiTexCoord1iARB;
PFNGLMULTITEXCOORD1IVARBPROC glMultiTexCoord1ivARB;
PFNGLMULTITEXCOORD1SARBPROC glMultiTexCoord1sARB;
PFNGLMULTITEXCOORD1SVARBPROC glMultiTexCoord1svARB;
PFNGLMULTITEXCOORD2DARBPROC glMultiTexCoord2dARB;
PFNGLMULTITEXCOORD2DVARBPROC glMultiTexCoord2dvARB;
PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB;
PFNGLMULTITEXCOORD2FVARBPROC glMultiTexCoord2fvARB;
PFNGLMULTITEXCOORD2IARBPROC glMultiTexCoord2iARB;
PFNGLMULTITEXCOORD2IVARBPROC glMultiTexCoord2ivARB;
PFNGLMULTITEXCOORD2SARBPROC glMultiTexCoord2sARB;
PFNGLMULTITEXCOORD2SVARBPROC glMultiTexCoord2svARB;
PFNGLMULTITEXCOORD3DARBPROC glMultiTexCoord3dARB;
PFNGLMULTITEXCOORD3DVARBPROC glMultiTexCoord3dvARB;
PFNGLMULTITEXCOORD3FARBPROC glMultiTexCoord3fARB;
PFNGLMULTITEXCOORD3FVARBPROC glMultiTexCoord3fvARB;
PFNGLMULTITEXCOORD3IARBPROC glMultiTexCoord3iARB;
PFNGLMULTITEXCOORD3IVARBPROC glMultiTexCoord3ivARB;
PFNGLMULTITEXCOORD3SARBPROC glMultiTexCoord3sARB;
PFNGLMULTITEXCOORD3SVARBPROC glMultiTexCoord3svARB;
PFNGLMULTITEXCOORD4DARBPROC glMultiTexCoord4dARB;
PFNGLMULTITEXCOORD4DVARBPROC glMultiTexCoord4dvARB;
PFNGLMULTITEXCOORD4FARBPROC glMultiTexCoord4fARB;
PFNGLMULTITEXCOORD4FVARBPROC glMultiTexCoord4fvARB;
PFNGLMULTITEXCOORD4IARBPROC glMultiTexCoord4iARB;
PFNGLMULTITEXCOORD4IVARBPROC glMultiTexCoord4ivARB;
PFNGLMULTITEXCOORD4SARBPROC glMultiTexCoord4sARB;
PFNGLMULTITEXCOORD4SVARBPROC glMultiTexCoord4svARB;

//  ...for GL_ARB_occlusion_query:
PFNGLBEGINQUERYARBPROC glBeginQueryARB;
PFNGLDELETEQUERIESARBPROC glDeleteQueriesARB;
PFNGLENDQUERYARBPROC glEndQueryARB;
PFNGLGENQUERIESARBPROC glGenQueriesARB;
PFNGLGETQUERYIVARBPROC glGetQueryivARB;
PFNGLGETQUERYOBJECTIVARBPROC glGetQueryObjectivARB;
PFNGLGETQUERYOBJECTUIVARBPROC glGetQueryObjectuivARB;
PFNGLISQUERYARBPROC glIsQueryARB;

//  ...for GL_ARB_point_parameters:
PFNGLPOINTPARAMETERFARBPROC glPointParameterfARB;
PFNGLPOINTPARAMETERFVARBPROC glPointParameterfvARB;

//  ...for GL_ARB_shader_objects:
PFNGLATTACHOBJECTARBPROC glAttachObjectARB;
PFNGLCOMPILESHADERARBPROC glCompileShaderARB;
PFNGLCREATEPROGRAMOBJECTARBPROC glCreateProgramObjectARB;
PFNGLCREATESHADEROBJECTARBPROC glCreateShaderObjectARB;
PFNGLDELETEOBJECTARBPROC glDeleteObjectARB;
PFNGLDETACHOBJECTARBPROC glDetachObjectARB;
PFNGLGETACTIVEUNIFORMARBPROC glGetActiveUniformARB;
PFNGLGETATTACHEDOBJECTSARBPROC glGetAttachedObjectsARB;
PFNGLGETHANDLEARBPROC glGetHandleARB;
PFNGLGETINFOLOGARBPROC glGetInfoLogARB;
PFNGLGETOBJECTPARAMETERFVARBPROC glGetObjectParameterfvARB;
PFNGLGETOBJECTPARAMETERIVARBPROC glGetObjectParameterivARB;
PFNGLGETSHADERSOURCEARBPROC glGetShaderSourceARB;
PFNGLGETUNIFORMFVARBPROC glGetUniformfvARB;
PFNGLGETUNIFORMIVARBPROC glGetUniformivARB;
PFNGLGETUNIFORMLOCATIONARBPROC glGetUniformLocationARB;
PFNGLLINKPROGRAMARBPROC glLinkProgramARB;
PFNGLSHADERSOURCEARBPROC glShaderSourceARB;
PFNGLUNIFORM1FARBPROC glUniform1fARB;
PFNGLUNIFORM1FVARBPROC glUniform1fvARB;
PFNGLUNIFORM1IARBPROC glUniform1iARB;
PFNGLUNIFORM1IVARBPROC glUniform1ivARB;
PFNGLUNIFORM2FARBPROC glUniform2fARB;
PFNGLUNIFORM2FVARBPROC glUniform2fvARB;
PFNGLUNIFORM2IARBPROC glUniform2iARB;
PFNGLUNIFORM2IVARBPROC glUniform2ivARB;
PFNGLUNIFORM3FARBPROC glUniform3fARB;
PFNGLUNIFORM3FVARBPROC glUniform3fvARB;
PFNGLUNIFORM3IARBPROC glUniform3iARB;
PFNGLUNIFORM3IVARBPROC glUniform3ivARB;
PFNGLUNIFORM4FARBPROC glUniform4fARB;
PFNGLUNIFORM4FVARBPROC glUniform4fvARB;
PFNGLUNIFORM4IARBPROC glUniform4iARB;
PFNGLUNIFORM4IVARBPROC glUniform4ivARB;
PFNGLUNIFORMMATRIX2FVARBPROC glUniformMatrix2fvARB;
PFNGLUNIFORMMATRIX3FVARBPROC glUniformMatrix3fvARB;
PFNGLUNIFORMMATRIX4FVARBPROC glUniformMatrix4fvARB;
PFNGLUSEPROGRAMOBJECTARBPROC glUseProgramObjectARB;
PFNGLVALIDATEPROGRAMARBPROC glValidateProgramARB;

//  ...for GL_ARB_texture_compression:
PFNGLCOMPRESSEDTEXIMAGE1DARBPROC glCompressedTexImage1DARB;
PFNGLCOMPRESSEDTEXIMAGE2DARBPROC glCompressedTexImage2DARB;
PFNGLCOMPRESSEDTEXIMAGE3DARBPROC glCompressedTexImage3DARB;
PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC glCompressedTexSubImage1DARB;
PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC glCompressedTexSubImage2DARB;
PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC glCompressedTexSubImage3DARB;
PFNGLGETCOMPRESSEDTEXIMAGEARBPROC glGetCompressedTexImageARB;

//  ...for GL_ARB_transpose_matrix:
PFNGLLOADTRANSPOSEMATRIXDARBPROC glLoadTransposeMatrixdARB;
PFNGLLOADTRANSPOSEMATRIXFARBPROC glLoadTransposeMatrixfARB;
PFNGLMULTTRANSPOSEMATRIXDARBPROC glMultTransposeMatrixdARB;
PFNGLMULTTRANSPOSEMATRIXFARBPROC glMultTransposeMatrixfARB;

//  ...for GL_ARB_vertex_blend:
PFNGLVERTEXBLENDARBPROC glVertexBlendARB;
PFNGLWEIGHTBVARBPROC glWeightbvARB;
PFNGLWEIGHTDVARBPROC glWeightdvARB;
PFNGLWEIGHTFVARBPROC glWeightfvARB;
PFNGLWEIGHTIVARBPROC glWeightivARB;
PFNGLWEIGHTPOINTERARBPROC glWeightPointerARB;
PFNGLWEIGHTSVARBPROC glWeightsvARB;
PFNGLWEIGHTUBVARBPROC glWeightubvARB;
PFNGLWEIGHTUIVARBPROC glWeightuivARB;
PFNGLWEIGHTUSVARBPROC glWeightusvARB;

//  ...for GL_ARB_vertex_buffer_object:
PFNGLBINDBUFFERARBPROC glBindBufferARB;
PFNGLBUFFERDATAARBPROC glBufferDataARB;
PFNGLBUFFERSUBDATAARBPROC glBufferSubDataARB;
PFNGLDELETEBUFFERSARBPROC glDeleteBuffersARB;
PFNGLGENBUFFERSARBPROC glGenBuffersARB;
PFNGLGETBUFFERPARAMETERIVARBPROC glGetBufferParameterivARB;
PFNGLGETBUFFERPOINTERVARBPROC glGetBufferPointervARB;
PFNGLGETBUFFERSUBDATAARBPROC glGetBufferSubDataARB;
PFNGLISBUFFERARBPROC glIsBufferARB;
PFNGLMAPBUFFERARBPROC glMapBufferARB;
PFNGLUNMAPBUFFERARBPROC glUnmapBufferARB;

//  ...for GL_ARB_vertex_program:
PFNGLBINDPROGRAMARBPROC glBindProgramARB;
PFNGLDELETEPROGRAMSARBPROC glDeleteProgramsARB;
PFNGLDISABLEVERTEXATTRIBARRAYARBPROC glDisableVertexAttribArrayARB;
PFNGLENABLEVERTEXATTRIBARRAYARBPROC glEnableVertexAttribArrayARB;
PFNGLGENPROGRAMSARBPROC glGenProgramsARB;
PFNGLGETPROGRAMENVPARAMETERDVARBPROC glGetProgramEnvParameterdvARB;
PFNGLGETPROGRAMENVPARAMETERFVARBPROC glGetProgramEnvParameterfvARB;
PFNGLGETPROGRAMIVARBPROC glGetProgramivARB;
PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC glGetProgramLocalParameterdvARB;
PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC glGetProgramLocalParameterfvARB;
PFNGLGETPROGRAMSTRINGARBPROC glGetProgramStringARB;
PFNGLGETVERTEXATTRIBDVARBPROC glGetVertexAttribdvARB;
PFNGLGETVERTEXATTRIBFVARBPROC glGetVertexAttribfvARB;
PFNGLGETVERTEXATTRIBIVARBPROC glGetVertexAttribivARB;
PFNGLGETVERTEXATTRIBPOINTERVARBPROC glGetVertexAttribPointervARB;
PFNGLISPROGRAMARBPROC glIsProgramARB;
PFNGLPROGRAMENVPARAMETER4DARBPROC glProgramEnvParameter4dARB;
PFNGLPROGRAMENVPARAMETER4DVARBPROC glProgramEnvParameter4dvARB;
PFNGLPROGRAMENVPARAMETER4FARBPROC glProgramEnvParameter4fARB;
PFNGLPROGRAMENVPARAMETER4FVARBPROC glProgramEnvParameter4fvARB;
PFNGLPROGRAMLOCALPARAMETER4DARBPROC glProgramLocalParameter4dARB;
PFNGLPROGRAMLOCALPARAMETER4DVARBPROC glProgramLocalParameter4dvARB;
PFNGLPROGRAMLOCALPARAMETER4FARBPROC glProgramLocalParameter4fARB;
PFNGLPROGRAMLOCALPARAMETER4FVARBPROC glProgramLocalParameter4fvARB;
PFNGLPROGRAMSTRINGARBPROC glProgramStringARB;
PFNGLVERTEXATTRIB1DARBPROC glVertexAttrib1dARB;
PFNGLVERTEXATTRIB1DVARBPROC glVertexAttrib1dvARB;
PFNGLVERTEXATTRIB1FARBPROC glVertexAttrib1fARB;
PFNGLVERTEXATTRIB1FVARBPROC glVertexAttrib1fvARB;
PFNGLVERTEXATTRIB1SARBPROC glVertexAttrib1sARB;
PFNGLVERTEXATTRIB1SVARBPROC glVertexAttrib1svARB;
PFNGLVERTEXATTRIB2DARBPROC glVertexAttrib2dARB;
PFNGLVERTEXATTRIB2DVARBPROC glVertexAttrib2dvARB;
PFNGLVERTEXATTRIB2FARBPROC glVertexAttrib2fARB;
PFNGLVERTEXATTRIB2FVARBPROC glVertexAttrib2fvARB;
PFNGLVERTEXATTRIB2SARBPROC glVertexAttrib2sARB;
PFNGLVERTEXATTRIB2SVARBPROC glVertexAttrib2svARB;
PFNGLVERTEXATTRIB3DARBPROC glVertexAttrib3dARB;
PFNGLVERTEXATTRIB3DVARBPROC glVertexAttrib3dvARB;
PFNGLVERTEXATTRIB3FARBPROC glVertexAttrib3fARB;
PFNGLVERTEXATTRIB3FVARBPROC glVertexAttrib3fvARB;
PFNGLVERTEXATTRIB3SARBPROC glVertexAttrib3sARB;
PFNGLVERTEXATTRIB3SVARBPROC glVertexAttrib3svARB;
PFNGLVERTEXATTRIB4BVARBPROC glVertexAttrib4bvARB;
PFNGLVERTEXATTRIB4DARBPROC glVertexAttrib4dARB;
PFNGLVERTEXATTRIB4DVARBPROC glVertexAttrib4dvARB;
PFNGLVERTEXATTRIB4FARBPROC glVertexAttrib4fARB;
PFNGLVERTEXATTRIB4FVARBPROC glVertexAttrib4fvARB;
PFNGLVERTEXATTRIB4IVARBPROC glVertexAttrib4ivARB;
PFNGLVERTEXATTRIB4NBVARBPROC glVertexAttrib4NbvARB;
PFNGLVERTEXATTRIB4NIVARBPROC glVertexAttrib4NivARB;
PFNGLVERTEXATTRIB4NSVARBPROC glVertexAttrib4NsvARB;
PFNGLVERTEXATTRIB4NUBARBPROC glVertexAttrib4NubARB;
PFNGLVERTEXATTRIB4NUBVARBPROC glVertexAttrib4NubvARB;
PFNGLVERTEXATTRIB4NUIVARBPROC glVertexAttrib4NuivARB;
PFNGLVERTEXATTRIB4NUSVARBPROC glVertexAttrib4NusvARB;
PFNGLVERTEXATTRIB4SARBPROC glVertexAttrib4sARB;
PFNGLVERTEXATTRIB4SVARBPROC glVertexAttrib4svARB;
PFNGLVERTEXATTRIB4UBVARBPROC glVertexAttrib4ubvARB;
PFNGLVERTEXATTRIB4UIVARBPROC glVertexAttrib4uivARB;
PFNGLVERTEXATTRIB4USVARBPROC glVertexAttrib4usvARB;
PFNGLVERTEXATTRIBPOINTERARBPROC glVertexAttribPointerARB;

//  ...for GL_ARB_vertex_shader:
PFNGLBINDATTRIBLOCATIONARBPROC glBindAttribLocationARB;
PFNGLGETACTIVEATTRIBARBPROC glGetActiveAttribARB;
PFNGLGETATTRIBLOCATIONARBPROC glGetAttribLocationARB;

//  ...for GL_ARB_window_pos:
PFNGLWINDOWPOS2DARBPROC glWindowPos2dARB;
PFNGLWINDOWPOS2DVARBPROC glWindowPos2dvARB;
PFNGLWINDOWPOS2FARBPROC glWindowPos2fARB;
PFNGLWINDOWPOS2FVARBPROC glWindowPos2fvARB;
PFNGLWINDOWPOS2IARBPROC glWindowPos2iARB;
PFNGLWINDOWPOS2IVARBPROC glWindowPos2ivARB;
PFNGLWINDOWPOS2SARBPROC glWindowPos2sARB;
PFNGLWINDOWPOS2SVARBPROC glWindowPos2svARB;
PFNGLWINDOWPOS3DARBPROC glWindowPos3dARB;
PFNGLWINDOWPOS3DVARBPROC glWindowPos3dvARB;
PFNGLWINDOWPOS3FARBPROC glWindowPos3fARB;
PFNGLWINDOWPOS3FVARBPROC glWindowPos3fvARB;
PFNGLWINDOWPOS3IARBPROC glWindowPos3iARB;
PFNGLWINDOWPOS3IVARBPROC glWindowPos3ivARB;
PFNGLWINDOWPOS3SARBPROC glWindowPos3sARB;
PFNGLWINDOWPOS3SVARBPROC glWindowPos3svARB;

//  ...for GL_ATI_draw_buffers:
PFNGLDRAWBUFFERSATIPROC glDrawBuffersATI;

//  ...for GL_ATI_element_array:
PFNGLDRAWELEMENTARRAYATIPROC glDrawElementArrayATI;
PFNGLDRAWRANGEELEMENTARRAYATIPROC glDrawRangeElementArrayATI;
PFNGLELEMENTPOINTERATIPROC glElementPointerATI;

//  ...for GL_ATI_envmap_bumpmap:
PFNGLGETTEXBUMPPARAMETERFVATIPROC glGetTexBumpParameterfvATI;
PFNGLGETTEXBUMPPARAMETERIVATIPROC glGetTexBumpParameterivATI;
PFNGLTEXBUMPPARAMETERFVATIPROC glTexBumpParameterfvATI;
PFNGLTEXBUMPPARAMETERIVATIPROC glTexBumpParameterivATI;

//  ...for GL_ATI_fragment_shader:
PFNGLALPHAFRAGMENTOP1ATIPROC glAlphaFragmentOp1ATI;
PFNGLALPHAFRAGMENTOP2ATIPROC glAlphaFragmentOp2ATI;
PFNGLALPHAFRAGMENTOP3ATIPROC glAlphaFragmentOp3ATI;
PFNGLBEGINFRAGMENTSHADERATIPROC glBeginFragmentShaderATI;
PFNGLBINDFRAGMENTSHADERATIPROC glBindFragmentShaderATI;
PFNGLCOLORFRAGMENTOP1ATIPROC glColorFragmentOp1ATI;
PFNGLCOLORFRAGMENTOP2ATIPROC glColorFragmentOp2ATI;
PFNGLCOLORFRAGMENTOP3ATIPROC glColorFragmentOp3ATI;
PFNGLDELETEFRAGMENTSHADERATIPROC glDeleteFragmentShaderATI;
PFNGLENDFRAGMENTSHADERATIPROC glEndFragmentShaderATI;
PFNGLGENFRAGMENTSHADERSATIPROC glGenFragmentShadersATI;
PFNGLPASSTEXCOORDATIPROC glPassTexCoordATI;
PFNGLSAMPLEMAPATIPROC glSampleMapATI;
PFNGLSETFRAGMENTSHADERCONSTANTATIPROC glSetFragmentShaderConstantATI;

//  ...for GL_ATI_map_object_buffer:
PFNGLMAPOBJECTBUFFERATIPROC glMapObjectBufferATI;
PFNGLUNMAPOBJECTBUFFERATIPROC glUnmapObjectBufferATI;

//  ...for GL_ATI_pn_triangles:
PFNGLPNTRIANGLESFATIPROC glPNTrianglesfATI;
PFNGLPNTRIANGLESIATIPROC glPNTrianglesiATI;

//  ...for GL_ATI_separate_stencil:
PFNGLSTENCILFUNCSEPARATEATIPROC glStencilFuncSeparateATI;
PFNGLSTENCILOPSEPARATEATIPROC glStencilOpSeparateATI;

//  ...for GL_ATI_vertex_array_object:
PFNGLARRAYOBJECTATIPROC glArrayObjectATI;
PFNGLFREEOBJECTBUFFERATIPROC glFreeObjectBufferATI;
PFNGLGETARRAYOBJECTFVATIPROC glGetArrayObjectfvATI;
PFNGLGETARRAYOBJECTIVATIPROC glGetArrayObjectivATI;
PFNGLGETOBJECTBUFFERFVATIPROC glGetObjectBufferfvATI;
PFNGLGETOBJECTBUFFERIVATIPROC glGetObjectBufferivATI;
PFNGLGETVARIANTARRAYOBJECTFVATIPROC glGetVariantArrayObjectfvATI;
PFNGLGETVARIANTARRAYOBJECTIVATIPROC glGetVariantArrayObjectivATI;
PFNGLISOBJECTBUFFERATIPROC glIsObjectBufferATI;
PFNGLNEWOBJECTBUFFERATIPROC glNewObjectBufferATI;
PFNGLUPDATEOBJECTBUFFERATIPROC glUpdateObjectBufferATI;
PFNGLVARIANTARRAYOBJECTATIPROC glVariantArrayObjectATI;

//  ...for GL_ATI_vertex_attrib_array_object:
PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC glGetVertexAttribArrayObjectfvATI;
PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC glGetVertexAttribArrayObjectivATI;
PFNGLVERTEXATTRIBARRAYOBJECTATIPROC glVertexAttribArrayObjectATI;

//  ...for GL_ATI_vertex_streams:
PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC glClientActiveVertexStreamATI;
PFNGLNORMALSTREAM3BATIPROC glNormalStream3bATI;
PFNGLNORMALSTREAM3BVATIPROC glNormalStream3bvATI;
PFNGLNORMALSTREAM3DATIPROC glNormalStream3dATI;
PFNGLNORMALSTREAM3DVATIPROC glNormalStream3dvATI;
PFNGLNORMALSTREAM3FATIPROC glNormalStream3fATI;
PFNGLNORMALSTREAM3FVATIPROC glNormalStream3fvATI;
PFNGLNORMALSTREAM3IATIPROC glNormalStream3iATI;
PFNGLNORMALSTREAM3IVATIPROC glNormalStream3ivATI;
PFNGLNORMALSTREAM3SATIPROC glNormalStream3sATI;
PFNGLNORMALSTREAM3SVATIPROC glNormalStream3svATI;
PFNGLVERTEXBLENDENVFATIPROC glVertexBlendEnvfATI;
PFNGLVERTEXBLENDENVIATIPROC glVertexBlendEnviATI;
PFNGLVERTEXSTREAM1DATIPROC glVertexStream1dATI;
PFNGLVERTEXSTREAM1DVATIPROC glVertexStream1dvATI;
PFNGLVERTEXSTREAM1FATIPROC glVertexStream1fATI;
PFNGLVERTEXSTREAM1FVATIPROC glVertexStream1fvATI;
PFNGLVERTEXSTREAM1IATIPROC glVertexStream1iATI;
PFNGLVERTEXSTREAM1IVATIPROC glVertexStream1ivATI;
PFNGLVERTEXSTREAM1SATIPROC glVertexStream1sATI;
PFNGLVERTEXSTREAM1SVATIPROC glVertexStream1svATI;
PFNGLVERTEXSTREAM2DATIPROC glVertexStream2dATI;
PFNGLVERTEXSTREAM2DVATIPROC glVertexStream2dvATI;
PFNGLVERTEXSTREAM2FATIPROC glVertexStream2fATI;
PFNGLVERTEXSTREAM2FVATIPROC glVertexStream2fvATI;
PFNGLVERTEXSTREAM2IATIPROC glVertexStream2iATI;
PFNGLVERTEXSTREAM2IVATIPROC glVertexStream2ivATI;
PFNGLVERTEXSTREAM2SATIPROC glVertexStream2sATI;
PFNGLVERTEXSTREAM2SVATIPROC glVertexStream2svATI;
PFNGLVERTEXSTREAM3DATIPROC glVertexStream3dATI;
PFNGLVERTEXSTREAM3DVATIPROC glVertexStream3dvATI;
PFNGLVERTEXSTREAM3FATIPROC glVertexStream3fATI;
PFNGLVERTEXSTREAM3FVATIPROC glVertexStream3fvATI;
PFNGLVERTEXSTREAM3IATIPROC glVertexStream3iATI;
PFNGLVERTEXSTREAM3IVATIPROC glVertexStream3ivATI;
PFNGLVERTEXSTREAM3SATIPROC glVertexStream3sATI;
PFNGLVERTEXSTREAM3SVATIPROC glVertexStream3svATI;
PFNGLVERTEXSTREAM4DATIPROC glVertexStream4dATI;
PFNGLVERTEXSTREAM4DVATIPROC glVertexStream4dvATI;
PFNGLVERTEXSTREAM4FATIPROC glVertexStream4fATI;
PFNGLVERTEXSTREAM4FVATIPROC glVertexStream4fvATI;
PFNGLVERTEXSTREAM4IATIPROC glVertexStream4iATI;
PFNGLVERTEXSTREAM4IVATIPROC glVertexStream4ivATI;
PFNGLVERTEXSTREAM4SATIPROC glVertexStream4sATI;
PFNGLVERTEXSTREAM4SVATIPROC glVertexStream4svATI;

//  ...for GL_EXT_blend_color:
PFNGLBLENDCOLOREXTPROC glBlendColorEXT;

//  ...for GL_EXT_blend_equation_separate:
PFNGLBLENDEQUATIONSEPARATEEXTPROC glBlendEquationSeparateEXT;

//  ...for GL_EXT_blend_func_separate:
PFNGLBLENDFUNCSEPARATEEXTPROC glBlendFuncSeparateEXT;

//  ...for GL_EXT_blend_minmax:
PFNGLBLENDEQUATIONEXTPROC glBlendEquationEXT;

//  ...for GL_EXT_color_subtable:
PFNGLCOLORSUBTABLEEXTPROC glColorSubTableEXT;
PFNGLCOPYCOLORSUBTABLEEXTPROC glCopyColorSubTableEXT;

//  ...for GL_EXT_compiled_vertex_array:
PFNGLLOCKARRAYSEXTPROC glLockArraysEXT;
PFNGLUNLOCKARRAYSEXTPROC glUnlockArraysEXT;

//  ...for GL_EXT_convolution:
PFNGLCONVOLUTIONFILTER1DEXTPROC glConvolutionFilter1DEXT;
PFNGLCONVOLUTIONFILTER2DEXTPROC glConvolutionFilter2DEXT;
PFNGLCONVOLUTIONPARAMETERFEXTPROC glConvolutionParameterfEXT;
PFNGLCONVOLUTIONPARAMETERFVEXTPROC glConvolutionParameterfvEXT;
PFNGLCONVOLUTIONPARAMETERIEXTPROC glConvolutionParameteriEXT;
PFNGLCONVOLUTIONPARAMETERIVEXTPROC glConvolutionParameterivEXT;
PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC glCopyConvolutionFilter1DEXT;
PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC glCopyConvolutionFilter2DEXT;
PFNGLGETCONVOLUTIONFILTEREXTPROC glGetConvolutionFilterEXT;
PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC glGetConvolutionParameterfvEXT;
PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC glGetConvolutionParameterivEXT;
PFNGLGETSEPARABLEFILTEREXTPROC glGetSeparableFilterEXT;
PFNGLSEPARABLEFILTER2DEXTPROC glSeparableFilter2DEXT;

//  ...for GL_EXT_coordinate_frame:
PFNGLBINORMAL3BEXTPROC glBinormal3bEXT;
PFNGLBINORMAL3BVEXTPROC glBinormal3bvEXT;
PFNGLBINORMAL3DEXTPROC glBinormal3dEXT;
PFNGLBINORMAL3DVEXTPROC glBinormal3dvEXT;
PFNGLBINORMAL3FEXTPROC glBinormal3fEXT;
PFNGLBINORMAL3FVEXTPROC glBinormal3fvEXT;
PFNGLBINORMAL3IEXTPROC glBinormal3iEXT;
PFNGLBINORMAL3IVEXTPROC glBinormal3ivEXT;
PFNGLBINORMAL3SEXTPROC glBinormal3sEXT;
PFNGLBINORMAL3SVEXTPROC glBinormal3svEXT;
PFNGLBINORMALPOINTEREXTPROC glBinormalPointerEXT;
PFNGLTANGENT3BEXTPROC glTangent3bEXT;
PFNGLTANGENT3BVEXTPROC glTangent3bvEXT;
PFNGLTANGENT3DEXTPROC glTangent3dEXT;
PFNGLTANGENT3DVEXTPROC glTangent3dvEXT;
PFNGLTANGENT3FEXTPROC glTangent3fEXT;
PFNGLTANGENT3FVEXTPROC glTangent3fvEXT;
PFNGLTANGENT3IEXTPROC glTangent3iEXT;
PFNGLTANGENT3IVEXTPROC glTangent3ivEXT;
PFNGLTANGENT3SEXTPROC glTangent3sEXT;
PFNGLTANGENT3SVEXTPROC glTangent3svEXT;
PFNGLTANGENTPOINTEREXTPROC glTangentPointerEXT;

//  ...for GL_EXT_copy_texture:
PFNGLCOPYTEXIMAGE1DEXTPROC glCopyTexImage1DEXT;
PFNGLCOPYTEXIMAGE2DEXTPROC glCopyTexImage2DEXT;
PFNGLCOPYTEXSUBIMAGE1DEXTPROC glCopyTexSubImage1DEXT;
PFNGLCOPYTEXSUBIMAGE2DEXTPROC glCopyTexSubImage2DEXT;
PFNGLCOPYTEXSUBIMAGE3DEXTPROC glCopyTexSubImage3DEXT;

//  ...for GL_EXT_cull_vertex:
PFNGLCULLPARAMETERDVEXTPROC glCullParameterdvEXT;
PFNGLCULLPARAMETERFVEXTPROC glCullParameterfvEXT;

//  ...for GL_EXT_depth_bounds_test:
PFNGLDEPTHBOUNDSEXTPROC glDepthBoundsEXT;

//  ...for GL_EXT_draw_range_elements:
PFNGLDRAWRANGEELEMENTSEXTPROC glDrawRangeElementsEXT;

//  ...for GL_EXT_fog_coord:
PFNGLFOGCOORDDEXTPROC glFogCoorddEXT;
PFNGLFOGCOORDDVEXTPROC glFogCoorddvEXT;
PFNGLFOGCOORDFEXTPROC glFogCoordfEXT;
PFNGLFOGCOORDFVEXTPROC glFogCoordfvEXT;
PFNGLFOGCOORDPOINTEREXTPROC glFogCoordPointerEXT;

//  ...for GL_EXT_framebuffer_object:
PFNGLBINDFRAMEBUFFEREXTPROC glBindFramebufferEXT;
PFNGLBINDRENDERBUFFEREXTPROC glBindRenderbufferEXT;
PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC glCheckFramebufferStatusEXT;
PFNGLDELETEFRAMEBUFFERSEXTPROC glDeleteFramebuffersEXT;
PFNGLDELETERENDERBUFFERSEXTPROC glDeleteRenderbuffersEXT;
PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC glFramebufferRenderbufferEXT;
PFNGLFRAMEBUFFERTEXTURE1DEXTPROC glFramebufferTexture1DEXT;
PFNGLFRAMEBUFFERTEXTURE2DEXTPROC glFramebufferTexture2DEXT;
PFNGLFRAMEBUFFERTEXTURE3DEXTPROC glFramebufferTexture3DEXT;
PFNGLGENERATEMIPMAPEXTPROC glGenerateMipmapEXT;
PFNGLGENFRAMEBUFFERSEXTPROC glGenFramebuffersEXT;
PFNGLGENRENDERBUFFERSEXTPROC glGenRenderbuffersEXT;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC glGetFramebufferAttachmentParameterivEXT;
PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC glGetRenderbufferParameterivEXT;
PFNGLISFRAMEBUFFEREXTPROC glIsFramebufferEXT;
PFNGLISRENDERBUFFEREXTPROC glIsRenderbufferEXT;
PFNGLRENDERBUFFERSTORAGEEXTPROC glRenderbufferStorageEXT;

//  ...for GL_EXT_histogram:
PFNGLGETHISTOGRAMEXTPROC glGetHistogramEXT;
PFNGLGETHISTOGRAMPARAMETERFVEXTPROC glGetHistogramParameterfvEXT;
PFNGLGETHISTOGRAMPARAMETERIVEXTPROC glGetHistogramParameterivEXT;
PFNGLGETMINMAXEXTPROC glGetMinmaxEXT;
PFNGLGETMINMAXPARAMETERFVEXTPROC glGetMinmaxParameterfvEXT;
PFNGLGETMINMAXPARAMETERIVEXTPROC glGetMinmaxParameterivEXT;
PFNGLHISTOGRAMEXTPROC glHistogramEXT;
PFNGLMINMAXEXTPROC glMinmaxEXT;
PFNGLRESETHISTOGRAMEXTPROC glResetHistogramEXT;
PFNGLRESETMINMAXEXTPROC glResetMinmaxEXT;

//  ...for GL_EXT_index_func:
PFNGLINDEXFUNCEXTPROC glIndexFuncEXT;

//  ...for GL_EXT_index_material:
PFNGLINDEXMATERIALEXTPROC glIndexMaterialEXT;

//  ...for GL_EXT_light_texture:
PFNGLAPPLYTEXTUREEXTPROC glApplyTextureEXT;
PFNGLTEXTURELIGHTEXTPROC glTextureLightEXT;
PFNGLTEXTUREMATERIALEXTPROC glTextureMaterialEXT;

//  ...for GL_EXT_multi_draw_arrays:
PFNGLMULTIDRAWARRAYSEXTPROC glMultiDrawArraysEXT;
PFNGLMULTIDRAWELEMENTSEXTPROC glMultiDrawElementsEXT;

//  ...for GL_EXT_multisample:
PFNGLSAMPLEMASKEXTPROC glSampleMaskEXT;
PFNGLSAMPLEPATTERNEXTPROC glSamplePatternEXT;

//  ...for GL_EXT_paletted_texture:
PFNGLCOLORTABLEEXTPROC glColorTableEXT;
PFNGLGETCOLORTABLEEXTPROC glGetColorTableEXT;
PFNGLGETCOLORTABLEPARAMETERFVEXTPROC glGetColorTableParameterfvEXT;
PFNGLGETCOLORTABLEPARAMETERIVEXTPROC glGetColorTableParameterivEXT;

//  ...for GL_EXT_pixel_transform:
PFNGLPIXELTRANSFORMPARAMETERFEXTPROC glPixelTransformParameterfEXT;
PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC glPixelTransformParameterfvEXT;
PFNGLPIXELTRANSFORMPARAMETERIEXTPROC glPixelTransformParameteriEXT;
PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC glPixelTransformParameterivEXT;

//  ...for GL_EXT_point_parameters:
PFNGLPOINTPARAMETERFEXTPROC glPointParameterfEXT;
PFNGLPOINTPARAMETERFVEXTPROC glPointParameterfvEXT;

//  ...for GL_EXT_polygon_offset:
PFNGLPOLYGONOFFSETEXTPROC glPolygonOffsetEXT;

//  ...for GL_EXT_secondary_color:
PFNGLSECONDARYCOLOR3BEXTPROC glSecondaryColor3bEXT;
PFNGLSECONDARYCOLOR3BVEXTPROC glSecondaryColor3bvEXT;
PFNGLSECONDARYCOLOR3DEXTPROC glSecondaryColor3dEXT;
PFNGLSECONDARYCOLOR3DVEXTPROC glSecondaryColor3dvEXT;
PFNGLSECONDARYCOLOR3FEXTPROC glSecondaryColor3fEXT;
PFNGLSECONDARYCOLOR3FVEXTPROC glSecondaryColor3fvEXT;
PFNGLSECONDARYCOLOR3IEXTPROC glSecondaryColor3iEXT;
PFNGLSECONDARYCOLOR3IVEXTPROC glSecondaryColor3ivEXT;
PFNGLSECONDARYCOLOR3SEXTPROC glSecondaryColor3sEXT;
PFNGLSECONDARYCOLOR3SVEXTPROC glSecondaryColor3svEXT;
PFNGLSECONDARYCOLOR3UBEXTPROC glSecondaryColor3ubEXT;
PFNGLSECONDARYCOLOR3UBVEXTPROC glSecondaryColor3ubvEXT;
PFNGLSECONDARYCOLOR3UIEXTPROC glSecondaryColor3uiEXT;
PFNGLSECONDARYCOLOR3UIVEXTPROC glSecondaryColor3uivEXT;
PFNGLSECONDARYCOLOR3USEXTPROC glSecondaryColor3usEXT;
PFNGLSECONDARYCOLOR3USVEXTPROC glSecondaryColor3usvEXT;
PFNGLSECONDARYCOLORPOINTEREXTPROC glSecondaryColorPointerEXT;

//  ...for GL_EXT_stencil_two_side:
PFNGLACTIVESTENCILFACEEXTPROC glActiveStencilFaceEXT;

//  ...for GL_EXT_subtexture:
PFNGLTEXSUBIMAGE1DEXTPROC glTexSubImage1DEXT;
PFNGLTEXSUBIMAGE2DEXTPROC glTexSubImage2DEXT;

//  ...for GL_EXT_texture:
PFNGLTEXIMAGE3DEXTPROC glTexImage3DEXT;
PFNGLTEXSUBIMAGE3DEXTPROC glTexSubImage3DEXT;

//  ...for GL_EXT_texture_object:
PFNGLARETEXTURESRESIDENTEXTPROC glAreTexturesResidentEXT;
PFNGLBINDTEXTUREEXTPROC glBindTextureEXT;
PFNGLDELETETEXTURESEXTPROC glDeleteTexturesEXT;
PFNGLGENTEXTURESEXTPROC glGenTexturesEXT;
PFNGLISTEXTUREEXTPROC glIsTextureEXT;
PFNGLPRIORITIZETEXTURESEXTPROC glPrioritizeTexturesEXT;

//  ...for GL_EXT_texture_perturb_normal:
PFNGLTEXTURENORMALEXTPROC glTextureNormalEXT;

//  ...for GL_EXT_vertex_array:
PFNGLARRAYELEMENTEXTPROC glArrayElementEXT;
PFNGLCOLORPOINTEREXTPROC glColorPointerEXT;
PFNGLDRAWARRAYSEXTPROC glDrawArraysEXT;
PFNGLEDGEFLAGPOINTEREXTPROC glEdgeFlagPointerEXT;
PFNGLGETPOINTERVEXTPROC glGetPointervEXT;
PFNGLINDEXPOINTEREXTPROC glIndexPointerEXT;
PFNGLNORMALPOINTEREXTPROC glNormalPointerEXT;
PFNGLTEXCOORDPOINTEREXTPROC glTexCoordPointerEXT;
PFNGLVERTEXPOINTEREXTPROC glVertexPointerEXT;

//  ...for GL_EXT_vertex_shader:
PFNGLBEGINVERTEXSHADEREXTPROC glBeginVertexShaderEXT;
PFNGLBINDLIGHTPARAMETEREXTPROC glBindLightParameterEXT;
PFNGLBINDMATERIALPARAMETEREXTPROC glBindMaterialParameterEXT;
PFNGLBINDPARAMETEREXTPROC glBindParameterEXT;
PFNGLBINDTEXGENPARAMETEREXTPROC glBindTexGenParameterEXT;
PFNGLBINDTEXTUREUNITPARAMETEREXTPROC glBindTextureUnitParameterEXT;
PFNGLBINDVERTEXSHADEREXTPROC glBindVertexShaderEXT;
PFNGLDELETEVERTEXSHADEREXTPROC glDeleteVertexShaderEXT;
PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC glDisableVariantClientStateEXT;
PFNGLENABLEVARIANTCLIENTSTATEEXTPROC glEnableVariantClientStateEXT;
PFNGLENDVERTEXSHADEREXTPROC glEndVertexShaderEXT;
PFNGLEXTRACTCOMPONENTEXTPROC glExtractComponentEXT;
PFNGLGENSYMBOLSEXTPROC glGenSymbolsEXT;
PFNGLGENVERTEXSHADERSEXTPROC glGenVertexShadersEXT;
PFNGLGETINVARIANTBOOLEANVEXTPROC glGetInvariantBooleanvEXT;
PFNGLGETINVARIANTFLOATVEXTPROC glGetInvariantFloatvEXT;
PFNGLGETINVARIANTINTEGERVEXTPROC glGetInvariantIntegervEXT;
PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC glGetLocalConstantBooleanvEXT;
PFNGLGETLOCALCONSTANTFLOATVEXTPROC glGetLocalConstantFloatvEXT;
PFNGLGETLOCALCONSTANTINTEGERVEXTPROC glGetLocalConstantIntegervEXT;
PFNGLGETVARIANTBOOLEANVEXTPROC glGetVariantBooleanvEXT;
PFNGLGETVARIANTFLOATVEXTPROC glGetVariantFloatvEXT;
PFNGLGETVARIANTINTEGERVEXTPROC glGetVariantIntegervEXT;
PFNGLGETVARIANTPOINTERVEXTPROC glGetVariantPointervEXT;
PFNGLINSERTCOMPONENTEXTPROC glInsertComponentEXT;
PFNGLISVARIANTENABLEDEXTPROC glIsVariantEnabledEXT;
PFNGLSETINVARIANTEXTPROC glSetInvariantEXT;
PFNGLSETLOCALCONSTANTEXTPROC glSetLocalConstantEXT;
PFNGLSHADEROP1EXTPROC glShaderOp1EXT;
PFNGLSHADEROP2EXTPROC glShaderOp2EXT;
PFNGLSHADEROP3EXTPROC glShaderOp3EXT;
PFNGLSWIZZLEEXTPROC glSwizzleEXT;
PFNGLVARIANTBVEXTPROC glVariantbvEXT;
PFNGLVARIANTDVEXTPROC glVariantdvEXT;
PFNGLVARIANTFVEXTPROC glVariantfvEXT;
PFNGLVARIANTIVEXTPROC glVariantivEXT;
PFNGLVARIANTPOINTEREXTPROC glVariantPointerEXT;
PFNGLVARIANTSVEXTPROC glVariantsvEXT;
PFNGLVARIANTUBVEXTPROC glVariantubvEXT;
PFNGLVARIANTUIVEXTPROC glVariantuivEXT;
PFNGLVARIANTUSVEXTPROC glVariantusvEXT;
PFNGLWRITEMASKEXTPROC glWriteMaskEXT;

//  ...for GL_EXT_vertex_weighting:
PFNGLVERTEXWEIGHTFEXTPROC glVertexWeightfEXT;
PFNGLVERTEXWEIGHTFVEXTPROC glVertexWeightfvEXT;
PFNGLVERTEXWEIGHTPOINTEREXTPROC glVertexWeightPointerEXT;

//  ...for GL_GREMEDY_string_marker:
PFNGLSTRINGMARKERGREMEDYPROC glStringMarkerGREMEDY;

//  ...for GL_HP_image_transform:
PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC glGetImageTransformParameterfvHP;
PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC glGetImageTransformParameterivHP;
PFNGLIMAGETRANSFORMPARAMETERFHPPROC glImageTransformParameterfHP;
PFNGLIMAGETRANSFORMPARAMETERFVHPPROC glImageTransformParameterfvHP;
PFNGLIMAGETRANSFORMPARAMETERIHPPROC glImageTransformParameteriHP;
PFNGLIMAGETRANSFORMPARAMETERIVHPPROC glImageTransformParameterivHP;

//  ...for GL_IBM_multimode_draw_arrays:
PFNGLMULTIMODEDRAWARRAYSIBMPROC glMultiModeDrawArraysIBM;
PFNGLMULTIMODEDRAWELEMENTSIBMPROC glMultiModeDrawElementsIBM;

//  ...for GL_IBM_vertex_array_lists:
PFNGLCOLORPOINTERLISTIBMPROC glColorPointerListIBM;
PFNGLEDGEFLAGPOINTERLISTIBMPROC glEdgeFlagPointerListIBM;
PFNGLFOGCOORDPOINTERLISTIBMPROC glFogCoordPointerListIBM;
PFNGLINDEXPOINTERLISTIBMPROC glIndexPointerListIBM;
PFNGLNORMALPOINTERLISTIBMPROC glNormalPointerListIBM;
PFNGLSECONDARYCOLORPOINTERLISTIBMPROC glSecondaryColorPointerListIBM;
PFNGLTEXCOORDPOINTERLISTIBMPROC glTexCoordPointerListIBM;
PFNGLVERTEXPOINTERLISTIBMPROC glVertexPointerListIBM;

//  ...for GL_INGR_blend_func_separate:
PFNGLBLENDFUNCSEPARATEINGRPROC glBlendFuncSeparateINGR;

//  ...for GL_INTEL_parallel_arrays:
PFNGLCOLORPOINTERVINTELPROC glColorPointervINTEL;
PFNGLNORMALPOINTERVINTELPROC glNormalPointervINTEL;
PFNGLTEXCOORDPOINTERVINTELPROC glTexCoordPointervINTEL;
PFNGLVERTEXPOINTERVINTELPROC glVertexPointervINTEL;

//  ...for GL_MESA_resize_buffers:
PFNGLRESIZEBUFFERSMESAPROC glResizeBuffersMESA;

//  ...for GL_MESA_window_pos:
PFNGLWINDOWPOS2DMESAPROC glWindowPos2dMESA;
PFNGLWINDOWPOS2DVMESAPROC glWindowPos2dvMESA;
PFNGLWINDOWPOS2FMESAPROC glWindowPos2fMESA;
PFNGLWINDOWPOS2FVMESAPROC glWindowPos2fvMESA;
PFNGLWINDOWPOS2IMESAPROC glWindowPos2iMESA;
PFNGLWINDOWPOS2IVMESAPROC glWindowPos2ivMESA;
PFNGLWINDOWPOS2SMESAPROC glWindowPos2sMESA;
PFNGLWINDOWPOS2SVMESAPROC glWindowPos2svMESA;
PFNGLWINDOWPOS3DMESAPROC glWindowPos3dMESA;
PFNGLWINDOWPOS3DVMESAPROC glWindowPos3dvMESA;
PFNGLWINDOWPOS3FMESAPROC glWindowPos3fMESA;
PFNGLWINDOWPOS3FVMESAPROC glWindowPos3fvMESA;
PFNGLWINDOWPOS3IMESAPROC glWindowPos3iMESA;
PFNGLWINDOWPOS3IVMESAPROC glWindowPos3ivMESA;
PFNGLWINDOWPOS3SMESAPROC glWindowPos3sMESA;
PFNGLWINDOWPOS3SVMESAPROC glWindowPos3svMESA;
PFNGLWINDOWPOS4DMESAPROC glWindowPos4dMESA;
PFNGLWINDOWPOS4DVMESAPROC glWindowPos4dvMESA;
PFNGLWINDOWPOS4FMESAPROC glWindowPos4fMESA;
PFNGLWINDOWPOS4FVMESAPROC glWindowPos4fvMESA;
PFNGLWINDOWPOS4IMESAPROC glWindowPos4iMESA;
PFNGLWINDOWPOS4IVMESAPROC glWindowPos4ivMESA;
PFNGLWINDOWPOS4SMESAPROC glWindowPos4sMESA;
PFNGLWINDOWPOS4SVMESAPROC glWindowPos4svMESA;

//  ...for GL_NV_evaluators:
PFNGLEVALMAPSNVPROC glEvalMapsNV;
PFNGLGETMAPATTRIBPARAMETERFVNVPROC glGetMapAttribParameterfvNV;
PFNGLGETMAPATTRIBPARAMETERIVNVPROC glGetMapAttribParameterivNV;
PFNGLGETMAPCONTROLPOINTSNVPROC glGetMapControlPointsNV;
PFNGLGETMAPPARAMETERFVNVPROC glGetMapParameterfvNV;
PFNGLGETMAPPARAMETERIVNVPROC glGetMapParameterivNV;
PFNGLMAPCONTROLPOINTSNVPROC glMapControlPointsNV;
PFNGLMAPPARAMETERFVNVPROC glMapParameterfvNV;
PFNGLMAPPARAMETERIVNVPROC glMapParameterivNV;

//  ...for GL_NV_fence:
PFNGLDELETEFENCESNVPROC glDeleteFencesNV;
PFNGLFINISHFENCENVPROC glFinishFenceNV;
PFNGLGENFENCESNVPROC glGenFencesNV;
PFNGLGETFENCEIVNVPROC glGetFenceivNV;
PFNGLISFENCENVPROC glIsFenceNV;
PFNGLSETFENCENVPROC glSetFenceNV;
PFNGLTESTFENCENVPROC glTestFenceNV;

//  ...for GL_NV_fragment_program:
PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC glGetProgramNamedParameterdvNV;
PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC glGetProgramNamedParameterfvNV;
PFNGLPROGRAMNAMEDPARAMETER4DNVPROC glProgramNamedParameter4dNV;
PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC glProgramNamedParameter4dvNV;
PFNGLPROGRAMNAMEDPARAMETER4FNVPROC glProgramNamedParameter4fNV;
PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC glProgramNamedParameter4fvNV;

//  ...for GL_NV_half_float:
PFNGLCOLOR3HNVPROC glColor3hNV;
PFNGLCOLOR3HVNVPROC glColor3hvNV;
PFNGLCOLOR4HNVPROC glColor4hNV;
PFNGLCOLOR4HVNVPROC glColor4hvNV;
PFNGLFOGCOORDHNVPROC glFogCoordhNV;
PFNGLFOGCOORDHVNVPROC glFogCoordhvNV;
PFNGLMULTITEXCOORD1HNVPROC glMultiTexCoord1hNV;
PFNGLMULTITEXCOORD1HVNVPROC glMultiTexCoord1hvNV;
PFNGLMULTITEXCOORD2HNVPROC glMultiTexCoord2hNV;
PFNGLMULTITEXCOORD2HVNVPROC glMultiTexCoord2hvNV;
PFNGLMULTITEXCOORD3HNVPROC glMultiTexCoord3hNV;
PFNGLMULTITEXCOORD3HVNVPROC glMultiTexCoord3hvNV;
PFNGLMULTITEXCOORD4HNVPROC glMultiTexCoord4hNV;
PFNGLMULTITEXCOORD4HVNVPROC glMultiTexCoord4hvNV;
PFNGLNORMAL3HNVPROC glNormal3hNV;
PFNGLNORMAL3HVNVPROC glNormal3hvNV;
PFNGLSECONDARYCOLOR3HNVPROC glSecondaryColor3hNV;
PFNGLSECONDARYCOLOR3HVNVPROC glSecondaryColor3hvNV;
PFNGLTEXCOORD1HNVPROC glTexCoord1hNV;
PFNGLTEXCOORD1HVNVPROC glTexCoord1hvNV;
PFNGLTEXCOORD2HNVPROC glTexCoord2hNV;
PFNGLTEXCOORD2HVNVPROC glTexCoord2hvNV;
PFNGLTEXCOORD3HNVPROC glTexCoord3hNV;
PFNGLTEXCOORD3HVNVPROC glTexCoord3hvNV;
PFNGLTEXCOORD4HNVPROC glTexCoord4hNV;
PFNGLTEXCOORD4HVNVPROC glTexCoord4hvNV;
PFNGLVERTEX2HNVPROC glVertex2hNV;
PFNGLVERTEX2HVNVPROC glVertex2hvNV;
PFNGLVERTEX3HNVPROC glVertex3hNV;
PFNGLVERTEX3HVNVPROC glVertex3hvNV;
PFNGLVERTEX4HNVPROC glVertex4hNV;
PFNGLVERTEX4HVNVPROC glVertex4hvNV;
PFNGLVERTEXATTRIB1HNVPROC glVertexAttrib1hNV;
PFNGLVERTEXATTRIB1HVNVPROC glVertexAttrib1hvNV;
PFNGLVERTEXATTRIB2HNVPROC glVertexAttrib2hNV;
PFNGLVERTEXATTRIB2HVNVPROC glVertexAttrib2hvNV;
PFNGLVERTEXATTRIB3HNVPROC glVertexAttrib3hNV;
PFNGLVERTEXATTRIB3HVNVPROC glVertexAttrib3hvNV;
PFNGLVERTEXATTRIB4HNVPROC glVertexAttrib4hNV;
PFNGLVERTEXATTRIB4HVNVPROC glVertexAttrib4hvNV;
PFNGLVERTEXATTRIBS1HVNVPROC glVertexAttribs1hvNV;
PFNGLVERTEXATTRIBS2HVNVPROC glVertexAttribs2hvNV;
PFNGLVERTEXATTRIBS3HVNVPROC glVertexAttribs3hvNV;
PFNGLVERTEXATTRIBS4HVNVPROC glVertexAttribs4hvNV;
PFNGLVERTEXWEIGHTHNVPROC glVertexWeighthNV;
PFNGLVERTEXWEIGHTHVNVPROC glVertexWeighthvNV;

//  ...for GL_NV_occlusion_query:
PFNGLBEGINOCCLUSIONQUERYNVPROC glBeginOcclusionQueryNV;
PFNGLDELETEOCCLUSIONQUERIESNVPROC glDeleteOcclusionQueriesNV;
PFNGLENDOCCLUSIONQUERYNVPROC glEndOcclusionQueryNV;
PFNGLGENOCCLUSIONQUERIESNVPROC glGenOcclusionQueriesNV;
PFNGLGETOCCLUSIONQUERYIVNVPROC glGetOcclusionQueryivNV;
PFNGLGETOCCLUSIONQUERYUIVNVPROC glGetOcclusionQueryuivNV;
PFNGLISOCCLUSIONQUERYNVPROC glIsOcclusionQueryNV;

//  ...for GL_NV_pixel_data_range:
PFNGLFLUSHPIXELDATARANGENVPROC glFlushPixelDataRangeNV;
PFNGLPIXELDATARANGENVPROC glPixelDataRangeNV;

//  ...for GL_NV_point_sprite:
PFNGLPOINTPARAMETERINVPROC glPointParameteriNV;
PFNGLPOINTPARAMETERIVNVPROC glPointParameterivNV;

//  ...for GL_NV_primitive_restart:
PFNGLPRIMITIVERESTARTINDEXNVPROC glPrimitiveRestartIndexNV;
PFNGLPRIMITIVERESTARTNVPROC glPrimitiveRestartNV;

//  ...for GL_NV_register_combiners:
PFNGLCOMBINERINPUTNVPROC glCombinerInputNV;
PFNGLCOMBINEROUTPUTNVPROC glCombinerOutputNV;
PFNGLCOMBINERPARAMETERFNVPROC glCombinerParameterfNV;
PFNGLCOMBINERPARAMETERFVNVPROC glCombinerParameterfvNV;
PFNGLCOMBINERPARAMETERINVPROC glCombinerParameteriNV;
PFNGLCOMBINERPARAMETERIVNVPROC glCombinerParameterivNV;
PFNGLCOMBINERSTAGEPARAMETERFVNVPROC glCombinerStageParameterfvNV;
PFNGLFINALCOMBINERINPUTNVPROC glFinalCombinerInputNV;
PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC glGetCombinerInputParameterfvNV;
PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC glGetCombinerInputParameterivNV;
PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC glGetCombinerOutputParameterfvNV;
PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC glGetCombinerOutputParameterivNV;
PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC glGetCombinerStageParameterfvNV;
PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC glGetFinalCombinerInputParameterfvNV;
PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC glGetFinalCombinerInputParameterivNV;

//  ...for GL_NV_vertex_array_range:
PFNGLFLUSHVERTEXARRAYRANGENVPROC glFlushVertexArrayRangeNV;
PFNGLVERTEXARRAYRANGENVPROC glVertexArrayRangeNV;

//  ...for GL_NV_vertex_program:
PFNGLAREPROGRAMSRESIDENTNVPROC glAreProgramsResidentNV;
PFNGLBINDPROGRAMNVPROC glBindProgramNV;
PFNGLDELETEPROGRAMSNVPROC glDeleteProgramsNV;
PFNGLEXECUTEPROGRAMNVPROC glExecuteProgramNV;
PFNGLGENPROGRAMSNVPROC glGenProgramsNV;
PFNGLGETPROGRAMIVNVPROC glGetProgramivNV;
PFNGLGETPROGRAMPARAMETERDVNVPROC glGetProgramParameterdvNV;
PFNGLGETPROGRAMPARAMETERFVNVPROC glGetProgramParameterfvNV;
PFNGLGETPROGRAMSTRINGNVPROC glGetProgramStringNV;
PFNGLGETTRACKMATRIXIVNVPROC glGetTrackMatrixivNV;
PFNGLGETVERTEXATTRIBDVNVPROC glGetVertexAttribdvNV;
PFNGLGETVERTEXATTRIBFVNVPROC glGetVertexAttribfvNV;
PFNGLGETVERTEXATTRIBIVNVPROC glGetVertexAttribivNV;
PFNGLGETVERTEXATTRIBPOINTERVNVPROC glGetVertexAttribPointervNV;
PFNGLISPROGRAMNVPROC glIsProgramNV;
PFNGLLOADPROGRAMNVPROC glLoadProgramNV;
PFNGLPROGRAMPARAMETER4DNVPROC glProgramParameter4dNV;
PFNGLPROGRAMPARAMETER4DVNVPROC glProgramParameter4dvNV;
PFNGLPROGRAMPARAMETER4FNVPROC glProgramParameter4fNV;
PFNGLPROGRAMPARAMETER4FVNVPROC glProgramParameter4fvNV;
PFNGLPROGRAMPARAMETERS4DVNVPROC glProgramParameters4dvNV;
PFNGLPROGRAMPARAMETERS4FVNVPROC glProgramParameters4fvNV;
PFNGLREQUESTRESIDENTPROGRAMSNVPROC glRequestResidentProgramsNV;
PFNGLTRACKMATRIXNVPROC glTrackMatrixNV;
PFNGLVERTEXATTRIB1DNVPROC glVertexAttrib1dNV;
PFNGLVERTEXATTRIB1DVNVPROC glVertexAttrib1dvNV;
PFNGLVERTEXATTRIB1FNVPROC glVertexAttrib1fNV;
PFNGLVERTEXATTRIB1FVNVPROC glVertexAttrib1fvNV;
PFNGLVERTEXATTRIB1SNVPROC glVertexAttrib1sNV;
PFNGLVERTEXATTRIB1SVNVPROC glVertexAttrib1svNV;
PFNGLVERTEXATTRIB2DNVPROC glVertexAttrib2dNV;
PFNGLVERTEXATTRIB2DVNVPROC glVertexAttrib2dvNV;
PFNGLVERTEXATTRIB2FNVPROC glVertexAttrib2fNV;
PFNGLVERTEXATTRIB2FVNVPROC glVertexAttrib2fvNV;
PFNGLVERTEXATTRIB2SNVPROC glVertexAttrib2sNV;
PFNGLVERTEXATTRIB2SVNVPROC glVertexAttrib2svNV;
PFNGLVERTEXATTRIB3DNVPROC glVertexAttrib3dNV;
PFNGLVERTEXATTRIB3DVNVPROC glVertexAttrib3dvNV;
PFNGLVERTEXATTRIB3FNVPROC glVertexAttrib3fNV;
PFNGLVERTEXATTRIB3FVNVPROC glVertexAttrib3fvNV;
PFNGLVERTEXATTRIB3SNVPROC glVertexAttrib3sNV;
PFNGLVERTEXATTRIB3SVNVPROC glVertexAttrib3svNV;
PFNGLVERTEXATTRIB4DNVPROC glVertexAttrib4dNV;
PFNGLVERTEXATTRIB4DVNVPROC glVertexAttrib4dvNV;
PFNGLVERTEXATTRIB4FNVPROC glVertexAttrib4fNV;
PFNGLVERTEXATTRIB4FVNVPROC glVertexAttrib4fvNV;
PFNGLVERTEXATTRIB4SNVPROC glVertexAttrib4sNV;
PFNGLVERTEXATTRIB4SVNVPROC glVertexAttrib4svNV;
PFNGLVERTEXATTRIB4UBNVPROC glVertexAttrib4ubNV;
PFNGLVERTEXATTRIB4UBVNVPROC glVertexAttrib4ubvNV;
PFNGLVERTEXATTRIBPOINTERNVPROC glVertexAttribPointerNV;
PFNGLVERTEXATTRIBS1DVNVPROC glVertexAttribs1dvNV;
PFNGLVERTEXATTRIBS1FVNVPROC glVertexAttribs1fvNV;
PFNGLVERTEXATTRIBS1SVNVPROC glVertexAttribs1svNV;
PFNGLVERTEXATTRIBS2DVNVPROC glVertexAttribs2dvNV;
PFNGLVERTEXATTRIBS2FVNVPROC glVertexAttribs2fvNV;
PFNGLVERTEXATTRIBS2SVNVPROC glVertexAttribs2svNV;
PFNGLVERTEXATTRIBS3DVNVPROC glVertexAttribs3dvNV;
PFNGLVERTEXATTRIBS3FVNVPROC glVertexAttribs3fvNV;
PFNGLVERTEXATTRIBS3SVNVPROC glVertexAttribs3svNV;
PFNGLVERTEXATTRIBS4DVNVPROC glVertexAttribs4dvNV;
PFNGLVERTEXATTRIBS4FVNVPROC glVertexAttribs4fvNV;
PFNGLVERTEXATTRIBS4SVNVPROC glVertexAttribs4svNV;
PFNGLVERTEXATTRIBS4UBVNVPROC glVertexAttribs4ubvNV;

//  ...for GL_PGI_misc_hints:
PFNGLHINTPGIPROC glHintPGI;

//  ...for GL_SGIS_detail_texture:
PFNGLDETAILTEXFUNCSGISPROC glDetailTexFuncSGIS;
PFNGLGETDETAILTEXFUNCSGISPROC glGetDetailTexFuncSGIS;

//  ...for GL_SGIS_fog_function:
PFNGLFOGFUNCSGISPROC glFogFuncSGIS;
PFNGLGETFOGFUNCSGISPROC glGetFogFuncSGIS;

//  ...for GL_SGIS_multisample:
PFNGLSAMPLEMASKSGISPROC glSampleMaskSGIS;
PFNGLSAMPLEPATTERNSGISPROC glSamplePatternSGIS;

//  ...for GL_SGIS_pixel_texture:
PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC glGetPixelTexGenParameterfvSGIS;
PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC glGetPixelTexGenParameterivSGIS;
PFNGLPIXELTEXGENPARAMETERFSGISPROC glPixelTexGenParameterfSGIS;
PFNGLPIXELTEXGENPARAMETERFVSGISPROC glPixelTexGenParameterfvSGIS;
PFNGLPIXELTEXGENPARAMETERISGISPROC glPixelTexGenParameteriSGIS;
PFNGLPIXELTEXGENPARAMETERIVSGISPROC glPixelTexGenParameterivSGIS;

//  ...for GL_SGIS_point_parameters:
PFNGLPOINTPARAMETERFSGISPROC glPointParameterfSGIS;
PFNGLPOINTPARAMETERFVSGISPROC glPointParameterfvSGIS;

//  ...for GL_SGIS_sharpen_texture:
PFNGLGETSHARPENTEXFUNCSGISPROC glGetSharpenTexFuncSGIS;
PFNGLSHARPENTEXFUNCSGISPROC glSharpenTexFuncSGIS;

//  ...for GL_SGIS_texture:
PFNGLTEXIMAGE4DSGISPROC glTexImage4DSGIS;
PFNGLTEXSUBIMAGE4DSGISPROC glTexSubImage4DSGIS;

//  ...for GL_SGIS_texture_color_mask:
PFNGLTEXTURECOLORMASKSGISPROC glTextureColorMaskSGIS;

//  ...for GL_SGIS_texture_filter:
PFNGLGETTEXFILTERFUNCSGISPROC glGetTexFilterFuncSGIS;
PFNGLTEXFILTERFUNCSGISPROC glTexFilterFuncSGIS;

//  ...for GL_SGIX_async:
PFNGLASYNCMARKERSGIXPROC glAsyncMarkerSGIX;
PFNGLDELETEASYNCMARKERSSGIXPROC glDeleteAsyncMarkersSGIX;
PFNGLFINISHASYNCSGIXPROC glFinishAsyncSGIX;
PFNGLGENASYNCMARKERSSGIXPROC glGenAsyncMarkersSGIX;
PFNGLISASYNCMARKERSGIXPROC glIsAsyncMarkerSGIX;
PFNGLPOLLASYNCSGIXPROC glPollAsyncSGIX;

//  ...for GL_SGIX_depth_pass_instrument:
PFNGLTBUFFERMASK3DFXPROC glTbufferMask3DFX;

//  ...for GL_SGIX_flush_raster:
PFNGLFLUSHRASTERSGIXPROC glFlushRasterSGIX;

//  ...for GL_SGIX_fragment_lighting:
PFNGLFRAGMENTCOLORMATERIALSGIXPROC glFragmentColorMaterialSGIX;
PFNGLFRAGMENTLIGHTFSGIXPROC glFragmentLightfSGIX;
PFNGLFRAGMENTLIGHTFVSGIXPROC glFragmentLightfvSGIX;
PFNGLFRAGMENTLIGHTISGIXPROC glFragmentLightiSGIX;
PFNGLFRAGMENTLIGHTIVSGIXPROC glFragmentLightivSGIX;
PFNGLFRAGMENTLIGHTMODELFSGIXPROC glFragmentLightModelfSGIX;
PFNGLFRAGMENTLIGHTMODELFVSGIXPROC glFragmentLightModelfvSGIX;
PFNGLFRAGMENTLIGHTMODELISGIXPROC glFragmentLightModeliSGIX;
PFNGLFRAGMENTLIGHTMODELIVSGIXPROC glFragmentLightModelivSGIX;
PFNGLFRAGMENTMATERIALFSGIXPROC glFragmentMaterialfSGIX;
PFNGLFRAGMENTMATERIALFVSGIXPROC glFragmentMaterialfvSGIX;
PFNGLFRAGMENTMATERIALISGIXPROC glFragmentMaterialiSGIX;
PFNGLFRAGMENTMATERIALIVSGIXPROC glFragmentMaterialivSGIX;
PFNGLGETFRAGMENTLIGHTFVSGIXPROC glGetFragmentLightfvSGIX;
PFNGLGETFRAGMENTLIGHTIVSGIXPROC glGetFragmentLightivSGIX;
PFNGLGETFRAGMENTMATERIALFVSGIXPROC glGetFragmentMaterialfvSGIX;
PFNGLGETFRAGMENTMATERIALIVSGIXPROC glGetFragmentMaterialivSGIX;
PFNGLLIGHTENVISGIXPROC glLightEnviSGIX;

//  ...for GL_SGIX_framezoom:
PFNGLFRAMEZOOMSGIXPROC glFrameZoomSGIX;

//  ...for GL_SGIX_igloo_interface:
PFNGLIGLOOINTERFACESGIXPROC glIglooInterfaceSGIX;

//  ...for GL_SGIX_instruments:
PFNGLGETINSTRUMENTSSGIXPROC glGetInstrumentsSGIX;
PFNGLINSTRUMENTSBUFFERSGIXPROC glInstrumentsBufferSGIX;
PFNGLPOLLINSTRUMENTSSGIXPROC glPollInstrumentsSGIX;
PFNGLREADINSTRUMENTSSGIXPROC glReadInstrumentsSGIX;
PFNGLSTARTINSTRUMENTSSGIXPROC glStartInstrumentsSGIX;
PFNGLSTOPINSTRUMENTSSGIXPROC glStopInstrumentsSGIX;

//  ...for GL_SGIX_list_priority:
PFNGLGETLISTPARAMETERFVSGIXPROC glGetListParameterfvSGIX;
PFNGLGETLISTPARAMETERIVSGIXPROC glGetListParameterivSGIX;
PFNGLLISTPARAMETERFSGIXPROC glListParameterfSGIX;
PFNGLLISTPARAMETERFVSGIXPROC glListParameterfvSGIX;
PFNGLLISTPARAMETERISGIXPROC glListParameteriSGIX;
PFNGLLISTPARAMETERIVSGIXPROC glListParameterivSGIX;

//  ...for GL_SGIX_pixel_texture:
PFNGLPIXELTEXGENSGIXPROC glPixelTexGenSGIX;

//  ...for GL_SGIX_polynomial_ffd:
PFNGLDEFORMATIONMAP3DSGIXPROC glDeformationMap3dSGIX;
PFNGLDEFORMATIONMAP3FSGIXPROC glDeformationMap3fSGIX;
PFNGLDEFORMSGIXPROC glDeformSGIX;
PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC glLoadIdentityDeformationMapSGIX;

//  ...for GL_SGIX_reference_plane:
PFNGLREFERENCEPLANESGIXPROC glReferencePlaneSGIX;

//  ...for GL_SGIX_sprite:
PFNGLSPRITEPARAMETERFSGIXPROC glSpriteParameterfSGIX;
PFNGLSPRITEPARAMETERFVSGIXPROC glSpriteParameterfvSGIX;
PFNGLSPRITEPARAMETERISGIXPROC glSpriteParameteriSGIX;
PFNGLSPRITEPARAMETERIVSGIXPROC glSpriteParameterivSGIX;

//  ...for GL_SGIX_tag_sample_buffer:
PFNGLTAGSAMPLEBUFFERSGIXPROC glTagSampleBufferSGIX;

//  ...for GL_SGI_color_table:
PFNGLCOLORTABLEPARAMETERFVSGIPROC glColorTableParameterfvSGI;
PFNGLCOLORTABLEPARAMETERIVSGIPROC glColorTableParameterivSGI;
PFNGLCOLORTABLESGIPROC glColorTableSGI;
PFNGLCOPYCOLORTABLESGIPROC glCopyColorTableSGI;
PFNGLGETCOLORTABLEPARAMETERFVSGIPROC glGetColorTableParameterfvSGI;
PFNGLGETCOLORTABLEPARAMETERIVSGIPROC glGetColorTableParameterivSGI;
PFNGLGETCOLORTABLESGIPROC glGetColorTableSGI;

//  ...for GL_SUNX_constant_data:
PFNGLFINISHTEXTURESUNXPROC glFinishTextureSUNX;

//  ...for GL_SUN_global_alpha:
PFNGLGLOBALALPHAFACTORBSUNPROC glGlobalAlphaFactorbSUN;
PFNGLGLOBALALPHAFACTORDSUNPROC glGlobalAlphaFactordSUN;
PFNGLGLOBALALPHAFACTORFSUNPROC glGlobalAlphaFactorfSUN;
PFNGLGLOBALALPHAFACTORISUNPROC glGlobalAlphaFactoriSUN;
PFNGLGLOBALALPHAFACTORSSUNPROC glGlobalAlphaFactorsSUN;
PFNGLGLOBALALPHAFACTORUBSUNPROC glGlobalAlphaFactorubSUN;
PFNGLGLOBALALPHAFACTORUISUNPROC glGlobalAlphaFactoruiSUN;
PFNGLGLOBALALPHAFACTORUSSUNPROC glGlobalAlphaFactorusSUN;

//  ...for GL_SUN_mesh_array:
PFNGLDRAWMESHARRAYSSUNPROC glDrawMeshArraysSUN;

//  ...for GL_SUN_triangle_list:
PFNGLREPLACEMENTCODEPOINTERSUNPROC glReplacementCodePointerSUN;
PFNGLREPLACEMENTCODEUBSUNPROC glReplacementCodeubSUN;
PFNGLREPLACEMENTCODEUBVSUNPROC glReplacementCodeubvSUN;
PFNGLREPLACEMENTCODEUISUNPROC glReplacementCodeuiSUN;
PFNGLREPLACEMENTCODEUIVSUNPROC glReplacementCodeuivSUN;
PFNGLREPLACEMENTCODEUSSUNPROC glReplacementCodeusSUN;
PFNGLREPLACEMENTCODEUSVSUNPROC glReplacementCodeusvSUN;

//  ...for GL_SUN_vertex:
PFNGLCOLOR3FVERTEX3FSUNPROC glColor3fVertex3fSUN;
PFNGLCOLOR3FVERTEX3FVSUNPROC glColor3fVertex3fvSUN;
PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC glColor4fNormal3fVertex3fSUN;
PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC glColor4fNormal3fVertex3fvSUN;
PFNGLCOLOR4UBVERTEX2FSUNPROC glColor4ubVertex2fSUN;
PFNGLCOLOR4UBVERTEX2FVSUNPROC glColor4ubVertex2fvSUN;
PFNGLCOLOR4UBVERTEX3FSUNPROC glColor4ubVertex3fSUN;
PFNGLCOLOR4UBVERTEX3FVSUNPROC glColor4ubVertex3fvSUN;
PFNGLNORMAL3FVERTEX3FSUNPROC glNormal3fVertex3fSUN;
PFNGLNORMAL3FVERTEX3FVSUNPROC glNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC glReplacementCodeuiColor3fVertex3fSUN;
PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC glReplacementCodeuiColor3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC glReplacementCodeuiColor4fNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC glReplacementCodeuiColor4fNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC glReplacementCodeuiColor4ubVertex3fSUN;
PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC glReplacementCodeuiColor4ubVertex3fvSUN;
PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC glReplacementCodeuiNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC glReplacementCodeuiNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC glReplacementCodeuiTexCoord2fVertex3fSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC glReplacementCodeuiTexCoord2fVertex3fvSUN;
PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC glReplacementCodeuiVertex3fSUN;
PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC glReplacementCodeuiVertex3fvSUN;
PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC glTexCoord2fColor3fVertex3fSUN;
PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC glTexCoord2fColor3fVertex3fvSUN;
PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC glTexCoord2fColor4fNormal3fVertex3fSUN;
PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC glTexCoord2fColor4fNormal3fVertex3fvSUN;
PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC glTexCoord2fColor4ubVertex3fSUN;
PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC glTexCoord2fColor4ubVertex3fvSUN;
PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC glTexCoord2fNormal3fVertex3fSUN;
PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC glTexCoord2fNormal3fVertex3fvSUN;
PFNGLTEXCOORD2FVERTEX3FSUNPROC glTexCoord2fVertex3fSUN;
PFNGLTEXCOORD2FVERTEX3FVSUNPROC glTexCoord2fVertex3fvSUN;
PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC glTexCoord4fColor4fNormal3fVertex4fSUN;
PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC glTexCoord4fColor4fNormal3fVertex4fvSUN;
PFNGLTEXCOORD4FVERTEX4FSUNPROC glTexCoord4fVertex4fSUN;
PFNGLTEXCOORD4FVERTEX4FVSUNPROC glTexCoord4fVertex4fvSUN;

#endif
