#ifndef GRAPHICS_CACHE
#define GRAPHICS_CACHE

#include <assert.h>
#include <string>
#include <map>

namespace Graphics {

using std::string;
using std::map;

class CachableItem {
public:
	CachableItem();
	unsigned int refcount;
	unsigned int id;
	virtual void reload() = 0;
};

template< class CLASS >
class CacheRef {
public:
	CacheRef(CLASS *_ref = NULL) : ref(NULL) {
		set(_ref);
	}
	CacheRef(CacheRef const &other) : ref(NULL) {
		set(other.ref);
	}
	~CacheRef() {
		set(NULL);
	}
	const CLASS *operator -> () const {
		return ref;
	}
	void set(CLASS *_ref) {
		if (ref != NULL) {
			assert(ref->refcount > 0);
			--(ref->refcount);
		}
		ref = _ref;
		if (ref != NULL) ++(ref->refcount);
	}
	CLASS *ref;
};

class Cache {
public:
//these are for cached data providers (fonts, textures, and such):
	void add_item(string const &key, CachableItem *item);
	CachableItem *get_item(string const &key);
//this is for your application to call at reasonable points (like when you
//suspect there is a lot of cache turnover):
	void garbage_collect();
private:
	map< string, CachableItem * > items;
};

Cache &get_cache();

} //namespace Graphics

#endif //GRAPHICS_CACHE
