#include "control_utils.hpp"

namespace Character {

float delta_penalty(Control const &control, StateDelta const &delta, float const time) {
	Vector3f dir = delta.position / time;
	float turn = delta.orientation / time;
	float len = length(dir);
	float control_len = length(control.desired_velocity);
	float dis = 0.0f;
	if (len + control_len > 0.1f) {
		dis += 1.0f * (1.0f - ((dir * control.desired_velocity) / (len + control_len)));
	}
	dis += fabs(len - control_len);
	dis += fabs(turn - control.desired_turning);
	return dis;
	
}

float delta_quality(Control const &control, StateDelta const &delta, float const time) {
	float penalty = delta_penalty(control, delta, time);
	return powf(0.75, 8.0f * penalty);
	
}


}
