#ifndef CHARACTER_HPP
#define CHARACTER_HPP

#include <Vector/Vector.hpp>
#include <Vector/Quat.hpp>
#include <vector>

namespace Library {
	class Skeleton;
}

//Important character data:
namespace Character {

using std::vector;

//Control is input that affects state
class Control {
public:
	void clear();
	//both relative to the body frame.
	Vector3f desired_velocity; //rate & direction of movement (z-forward)
	float desired_turning; //rate & direction of turning (around y)
	/* flags for actions go here */
};

//State is high-level data about a character
class State {
public:
	void clear();
	int action_flags;
	enum {
		ActionFlagJump = 1 << 0,
		ActionFlagDuck = 1 << 1,
		/* ... etc ... */
	};
	Vector3f position;
	float orientation; //yaw
};

class StateDelta {
public:
	void clear();
	Vector3f position; //(z-forward; z,x only)
	float orientation; //(yaw around y axis)
};

class Pose;

//Angles is a joint-angles precursor to Pose
//(though, to be fair, the first three things in angles are
// actually root position, but let's not stress too much.)
class Angles {
public:
	void clear(unsigned int DOF = 0, Library::Skeleton const *skel = NULL);
	void to_pose(Pose &into) const;
	vector< double > angles;
	Library::Skeleton const *skeleton;
};

//Pose is limb positions and such.
class Pose {
public:
	void clear(unsigned int bones = 0);
	Pose &operator=(Pose const &other);
	Vector3f root_position;
	Quatf root_orientation;
	vector< Quatf > bone_orientations;
	Library::Skeleton const *skeleton;
};

}

#endif //CHARACTER_HPP
