#include "Character.hpp"
#include <Library/Skeleton.hpp>

namespace Character {

void Control::clear() {
	desired_velocity = make_vector< float >(0.0f, 0.0f, 0.0f);
	desired_turning = 0;
}

void State::clear() {
	action_flags = 0;
	position = make_vector< float >(0.0f, 0.0f, 0.0f);
	orientation = 0;
}

void StateDelta::clear() {
	position = make_vector< float >(0.0f, 0.0f, 0.0f);
	orientation = 0;
}

void Angles::clear(unsigned int DOF, Library::Skeleton const *skel) {
	angles.clear();
	angles.resize(DOF, 0.0);
	skeleton = skel;
}

void Angles::to_pose(Pose &to) const {
	assert(skeleton);
	skeleton->build_pose(&(angles[0]), to);
}

void Pose::clear(unsigned int bones) {
	root_position = make_vector(0.0f,0.0f,0.0f);
	root_orientation.clear();

	bone_orientations.resize(bones);

	skeleton = NULL;	

	for (unsigned int i = 0; i < bones; ++i) {
		bone_orientations[i].clear();
	}
}

Pose &Pose::operator=(Pose const &other) {
	root_position = other.root_position;
	root_orientation = other.root_orientation;
	bone_orientations = other.bone_orientations;
	skeleton = other.skeleton;
	return *this;
}

}
