#ifndef BOX_HPP
#define BOX_HPP

#include "Vector.hpp"

template< typename NUM, int size >
class Box {
public:
	Vector< NUM, size > min;
	Vector< NUM, size > max;
	bool contains(Vector< NUM, size > const &p) const {
		bool ret = true;
		for (unsigned int c = 0; c < size; ++c) {
			ret = ret && (p.c[c] >= min.c[c]);
			ret = ret && (p.c[c] <= max.c[c]);
		}
		return ret;
	}
	bool intersects(Box< NUM, size > const &b) const {
		bool ret = true;
		for (unsigned int c = 0; c < size; ++c) {
			ret = ret && !(min.c[c] > b.max.c[c]);
			ret = ret && !(max.c[c] < b.min.c[c]);
		}
		return ret;
	}
	Vector< NUM, size > clamp(Vector< NUM, size > const &in) const {
		Vector< NUM, size > ret;
		for (unsigned int c = 0; c < size; ++c) {
			if (in.c[c] < min.c[c]) ret.c[c] = min.c[c];
			else if (in.c[c] > max.c[c]) ret.c[c] = max.c[c];
			else ret.c[c] = in.c[c];
		}
		return ret;
	}
	Vector< NUM, size > center() const {
		return 0.5f * (min + max);
	}
};

template< typename NUM, int size >
inline Box< NUM, size > make_box(Vector< NUM, size > const &min, Vector< NUM, size > const &max) {
	Box< NUM, size > box;
	box.min = min;
	box.max = max;
	return box;
}

typedef Box< int, 2 > Box2i;
typedef Box< int, 3 > Box3i;
typedef Box< int, 4 > Box4i;

typedef Box< float, 2 > Box2f;
typedef Box< float, 3 > Box3f;
typedef Box< float, 4 > Box4f;

typedef Box< double, 2 > Box2d;
typedef Box< double, 3 > Box3d;
typedef Box< double, 4 > Box4d;

#endif //BOX_HPP
